/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import lv.id.bonne.animalpen.registries.AnimalPenTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Sheep.class})
public abstract class AnimalPenSheep
extends AnimalPenAnimal {
    @Shadow
    @Final
    private static Map<DyeColor, ItemLike> f_29800_;
    @Unique
    private int animalPen$woolCooldown;
    @Unique
    private static final List<ItemStack> animal_pen$DYE;

    protected AnimalPenSheep(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract DyeColor m_29874_();

    @Shadow
    public abstract void m_29855_(DyeColor var1);

    @Shadow
    public abstract void m_29878_(boolean var1);

    @Shadow
    public abstract boolean m_29875_();

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$woolCooldown > 0) {
            --this.animalPen$woolCooldown;
            return true;
        }
        if (this.m_29875_()) {
            this.m_29878_(false);
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.m_128405_("wool_cooldown", this.animalPen$woolCooldown);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$woolCooldown = tag.m_128451_("wool_cooldown");
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42574_) || itemStack.m_204117_(AnimalPenTags.FORGE_SHEARS) || itemStack.m_204117_(AnimalPenTags.COMMON_SHEARS)) {
            if (this.animalPen$woolCooldown > 0) {
                AnimalPen.sendDebug("Under cooldown for " + this.animalPen$woolCooldown);
                return false;
            }
            if (player.m_9236_().m_5776_()) {
                return true;
            }
            this.m_29878_(true);
            AnimalPenInterface.triggerItemUse((Entity)this, (ServerPlayer)player, itemStack, 1);
            itemStack.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
            ItemLike itemLike = f_29800_.get(this.m_29874_());
            int woolCount = 1;
            int dropLimits = AnimalPen.config().getDropLimits(Items.f_41870_);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int i = 0;
            while ((long)i < this.animalPen$animalCount && woolCount < dropLimits) {
                woolCount += player.m_9236_().m_213780_().m_188503_(3);
                ++i;
            }
            while (woolCount > 0) {
                ItemStack woolStack = new ItemStack(itemLike);
                if (woolCount > 64) {
                    woolStack.m_41764_(64);
                    woolCount -= 64;
                } else {
                    woolStack.m_41764_(woolCount);
                    woolCount = 0;
                }
                Block.m_49840_((Level)player.m_9236_(), (BlockPos)position.m_7494_(), (ItemStack)woolStack);
            }
            player.m_9236_().m_5594_(null, position, SoundEvents.f_12344_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$woolCooldown = AnimalPen.config().getEntityCooldown(this.m_6095_(), Items.f_42574_, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.m_41720_().arch$registryName()));
            return true;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            if (player.m_9236_().m_5776_()) {
                return true;
            }
            this.m_29855_(dye.m_41089_());
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
                player.m_21008_(hand, itemStack);
            }
            player.m_9236_().m_5594_(null, position, SoundEvents.f_144133_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.m_41720_().arch$registryName()));
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public ItemStack animalPen$animalPenInteract(ServerLevel level, ItemStack itemStack, BlockPos position) {
        if (itemStack.m_150930_(Items.f_42574_) || itemStack.m_204117_(AnimalPenTags.FORGE_SHEARS) || itemStack.m_204117_(AnimalPenTags.COMMON_SHEARS)) {
            if (this.animalPen$woolCooldown > 0) {
                AnimalPen.sendDebug("Under cooldown for " + this.animalPen$woolCooldown);
                return ItemStack.f_41583_;
            }
            this.m_29878_(true);
            if (itemStack.m_220157_(1, level.m_213780_(), null)) {
                itemStack.m_41764_(0);
            }
            ItemLike itemLike = f_29800_.get(this.m_29874_());
            int woolCount = 1;
            int dropLimits = AnimalPen.config().getDropLimits(Items.f_41870_);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int i = 0;
            while ((long)i < this.animalPen$animalCount && woolCount < dropLimits) {
                woolCount += level.m_213780_().m_188503_(3);
                ++i;
            }
            while (woolCount > 0) {
                ItemStack woolStack = new ItemStack(itemLike);
                if (woolCount > 64) {
                    woolStack.m_41764_(64);
                    woolCount -= 64;
                } else {
                    woolStack.m_41764_(woolCount);
                    woolCount = 0;
                }
                Block.m_49840_((Level)level, (BlockPos)position.m_7494_(), (ItemStack)woolStack);
            }
            level.m_5594_(null, position, SoundEvents.f_12344_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$woolCooldown = AnimalPen.config().getEntityCooldown(this.m_6095_(), Items.f_42574_, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.m_41720_().arch$registryName()));
            return ItemStack.f_41583_;
        }
        return super.animalPen$animalPenInteract(level, itemStack, position);
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        ItemStack dyeItem;
        List<Pair<ItemStack[], Component>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (!AnimalPen.config().isShowAllInteractions() && shortLine && AnimalPen.config().getEntityCooldown(this.m_6095_(), Items.f_42574_, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = this.animalPen$woolCooldown == 0 ? Component.m_237110_((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.full_ready"), (Object[])new Object[]{Component.m_237113_((String)"\ue000"), Component.m_237113_((String)"\ue001")}).m_130940_(ChatFormatting.GREEN) : Component.m_237110_((String)(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.wool_cooldown"), (Object[])new Object[]{Component.m_237113_((String)"\ue000"), Component.m_237113_((String)"\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$woolCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
        ItemLike itemLike = f_29800_.get(this.m_29874_());
        lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.f_42574_.m_7968_(), itemLike.m_5456_().m_7968_()}, (Object)component));
        if (!AnimalPen.config().isShowAllInteractions() && shortLine) {
            return lines;
        }
        MutableComponent text = Component.m_237110_((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.color_ready"), (Object[])new Object[]{Component.m_237113_((String)"\ue000"), Component.m_237113_((String)"\ue001")}).m_130940_(ChatFormatting.GREEN);
        if (animal_pen$DYE.isEmpty()) {
            return lines;
        }
        if (animal_pen$DYE.size() == 1) {
            dyeItem = animal_pen$DYE.get(0);
        } else {
            int size = animal_pen$DYE.size();
            int index = tick / 100 % size;
            dyeItem = animal_pen$DYE.get(index);
        }
        ItemStack woolItem = f_29800_.get(((DyeItem)dyeItem.m_41720_()).m_41089_()).m_5456_().m_7968_();
        lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{dyeItem, woolItem}, (Object)text));
        return lines;
    }

    @Override
    @Intrinsic
    public int animalPen$getRedStoneSignal() {
        if (this.animalPen$woolCooldown > 0) {
            return super.animalPen$getRedStoneSignal();
        }
        return super.animalPen$getRedStoneSignal() | 4;
    }

    static {
        animal_pen$DYE = BuiltInRegistries.f_257033_.m_123024_().filter(item -> item instanceof DyeItem).map(Item::m_7968_).toList();
    }
}

