/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.time.LocalTime;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Goat.class})
public abstract class AnimalPenGoat
extends AnimalPenAnimal {
    @Unique
    private int animalPen$milkCooldown;

    protected AnimalPenGoat(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$milkCooldown > 0) {
            --this.animalPen$milkCooldown;
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.m_128405_("milk_cooldown", this.animalPen$milkCooldown);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$milkCooldown = tag.m_128451_("milk_cooldown");
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42446_)) {
            if (this.animalPen$milkCooldown > 0) {
                return false;
            }
            if (player.m_183503_().m_5776_()) {
                return true;
            }
            ItemStack remainingStack = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)Items.f_42455_.m_7968_());
            player.m_21008_(hand, remainingStack);
            player.m_183503_().m_5594_(null, position, SoundEvents.f_144168_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$milkCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42446_, this.animalPen$animalCount);
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public ItemStack animalPen$animalPenInteract(ServerLevel level, ItemStack itemStack, BlockPos position) {
        if (itemStack.m_150930_(Items.f_42446_)) {
            if (this.animalPen$milkCooldown > 0) {
                return ItemStack.f_41583_;
            }
            itemStack.m_41774_(1);
            level.m_5594_(null, position, SoundEvents.f_11833_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$milkCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42446_, this.animalPen$animalCount);
            return Items.f_42455_.m_7968_();
        }
        return super.animalPen$animalPenInteract(level, itemStack, position);
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        List<Pair<ItemStack[], Component>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (shortLine && AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42446_, this.animalPen$animalCount) == 0) {
            return lines;
        }
        TextComponent component = new TextComponent("");
        if (this.animalPen$milkCooldown == 0) {
            component.m_7220_((Component)new TranslatableComponent(shortLine ? "display.animal_pen.ready" : "display.animal_pen.full_ready", new Object[]{new TextComponent("\ue000"), new TextComponent("\ue001")}).m_130940_(ChatFormatting.GREEN));
        } else {
            component.m_7220_((Component)new TranslatableComponent(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.milk_cooldown", new Object[]{new TextComponent("\ue000"), new TextComponent("\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$milkCooldown / 20).format(AnimalPen.DATE_FORMATTER)}));
        }
        lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.f_42446_.m_7968_(), Items.f_42455_.m_7968_()}, (Object)component));
        return lines;
    }

    @Override
    @Intrinsic
    public int animalPen$getRedStoneSignal() {
        if (this.animalPen$milkCooldown > 0) {
            return super.animalPen$getRedStoneSignal();
        }
        return super.animalPen$getRedStoneSignal() | 4;
    }
}

