/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.ReloadListenerRegistry;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import lv.id.bonne.animalpen.blocks.behaviour.UseToolsBehaviour;
import lv.id.bonne.animalpen.commands.AnimalPenCommands;
import lv.id.bonne.animalpen.config.ConfigurationManager;
import lv.id.bonne.animalpen.listeners.AnimalFoodReloadListener;
import lv.id.bonne.animalpen.mixin.accessors.DispenserBlockAccessor;
import lv.id.bonne.animalpen.network.packets.AnimalFoodRegistryData;
import lv.id.bonne.animalpen.network.packets.RemoveDisplayAnimalData;
import lv.id.bonne.animalpen.network.packets.UpdateAnimalSizeData;
import lv.id.bonne.animalpen.network.packets.UpdateDisplayAnimalData;
import lv.id.bonne.animalpen.network.packets.UpdateVariantScreenData;
import lv.id.bonne.animalpen.registries.AnimalPenBlockRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensCreativeTabRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import org.slf4j.Logger;

public final class AnimalPen {
    public static final String MOD_ID = "animal_pen";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ConfigurationManager CONFIG_MANAGER = new ConfigurationManager();
    public static final NetworkChannel CHANNEL = NetworkChannel.create((ResourceLocation)new ResourceLocation("animal_pen", "network"));
    public static DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();

    public static void init() {
        AnimalPensCreativeTabRegistry.register();
        AnimalPenBlockRegistry.register();
        AnimalPensItemRegistry.register();
        AnimalPenTileEntityRegistry.register();
        CONFIG_MANAGER.readConfig();
        CommandRegistrationEvent.EVENT.register((dispatcher, var2, var3) -> AnimalPenCommands.register((CommandDispatcher<CommandSourceStack>)dispatcher));
        DispenserBlock.m_52672_((ItemLike)Items.f_42574_, (DispenseItemBehavior)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(Items.f_42574_)));
        DispenserBlock.m_52672_((ItemLike)Items.f_42590_, (DispenseItemBehavior)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(Items.f_42590_)));
        DispenserBlock.m_52672_((ItemLike)Items.f_42446_, (DispenseItemBehavior)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(Items.f_42446_)));
        DispenserBlock.m_52672_((ItemLike)Items.f_42399_, (DispenseItemBehavior)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(Items.f_42399_)));
        DispenserBlock.m_52672_((ItemLike)Items.f_42447_, (DispenseItemBehavior)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(Items.f_42447_)));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)UpdateDisplayAnimalData.ID, UpdateDisplayAnimalData::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)RemoveDisplayAnimalData.ID, RemoveDisplayAnimalData::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)UpdateAnimalSizeData.ID, UpdateAnimalSizeData::handle);
        CHANNEL.register(AnimalFoodRegistryData.class, AnimalFoodRegistryData::encode, AnimalFoodRegistryData::decode, AnimalFoodRegistryData::handle);
        CHANNEL.register(UpdateVariantScreenData.class, UpdateVariantScreenData::encode, UpdateVariantScreenData::decode, UpdateVariantScreenData::handle);
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new AnimalFoodReloadListener(), (ResourceLocation)new ResourceLocation(MOD_ID, "animal_foods"));
        PlayerEvent.PLAYER_JOIN.register(player -> CHANNEL.sendToPlayer(player, (Object)AnimalFoodRegistryData.serverData()));
    }
}

