/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.items;

import java.util.List;
import java.util.Optional;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AquariumTileEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalContainerItem
extends Item {
    public static final String TAG_ENTITY_ID = "id";
    public static final String TAG_VARIANTS = "animal_variants";
    public static final String TAG_AMOUNT = "animal_count";

    public AnimalContainerItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        if (!list.isEmpty()) {
            list.add((Component)Component.m_237119_());
        }
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_(TAG_ENTITY_ID)) {
            list.add((Component)Component.m_237110_((String)"item.animal_pen.water_animal_container.entity", (Object[])new Object[]{AnimalContainerItem.getEntityTranslationName(itemStack.m_41783_().m_128461_(TAG_ENTITY_ID))}).m_130940_(ChatFormatting.GRAY));
        }
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_(TAG_AMOUNT)) {
            list.add((Component)Component.m_237110_((String)"item.animal_pen.water_animal_container.amount", (Object[])new Object[]{itemStack.m_41783_().m_128454_(TAG_AMOUNT)}).m_130940_(ChatFormatting.GRAY));
        }
        if (!itemStack.m_41782_() || !itemStack.m_41783_().m_128441_(TAG_ENTITY_ID)) {
            list.add((Component)Component.m_237115_((String)"item.animal_pen.water_animal_container.tip").m_130940_(ChatFormatting.GRAY));
        }
        list.add((Component)Component.m_237115_((String)"item.animal_pen.water_animal_container.warning").m_130940_(ChatFormatting.GRAY));
    }

    @NotNull
    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand interactionHand) {
        InteractionResult interactionResult = super.m_6880_(itemStack, player, livingEntity, interactionHand);
        if (interactionResult == InteractionResult.FAIL) {
            player.m_5661_((Component)Component.m_237115_((String)"item.animal_pen.water_animal_container.error.unknown").m_130940_(ChatFormatting.DARK_RED), true);
            return interactionResult;
        }
        if (player.m_9236_().m_5776_() || livingEntity instanceof Player || !livingEntity.m_6084_()) {
            return InteractionResult.FAIL;
        }
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().isBlocked(livingEntity.m_6095_())) {
            player.m_5661_((Component)Component.m_237115_((String)"item.animal_pen.animal_cage.error.blocked").m_130940_(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        if (!livingEntity.m_6084_() || livingEntity.m_6162_()) {
            player.m_5661_((Component)Component.m_237115_((String)"item.animal_pen.water_animal_container.error.baby").m_130940_(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        if (!(livingEntity instanceof WaterAnimal)) {
            player.m_5661_((Component)Component.m_237115_((String)"item.animal_pen.water_animal_container.error.not_water_animal").m_130940_(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        WaterAnimal animal = (WaterAnimal)livingEntity;
        if (!this.matchEntity(itemStack, livingEntity)) {
            player.m_5661_((Component)Component.m_237115_((String)"item.animal_pen.water_animal_container.error.wrong").m_130940_(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        CompoundTag itemTag = itemStack.m_41784_();
        if (!itemTag.m_128441_(TAG_ENTITY_ID)) {
            animal.m_20223_(itemTag);
        }
        if (itemTag.m_128441_(TAG_AMOUNT)) {
            long maxCount = AnimalPen.CONFIG_MANAGER.getConfiguration().getMaximalAnimalCount();
            if (maxCount > 0L && itemTag.m_128454_(TAG_AMOUNT) + 1L > maxCount) {
                return InteractionResult.FAIL;
            }
            itemTag.m_128356_(TAG_AMOUNT, itemTag.m_128454_(TAG_AMOUNT) + 1L);
        }
        itemStack.m_41751_(itemTag);
        AnimalContainerItem.storeAnimalVariant(itemStack, (LivingEntity)animal, player);
        player.m_21008_(interactionHand, itemStack);
        livingEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext useOnContext) {
        AquariumTileEntity tileEntity;
        if (useOnContext.m_43725_().m_5776_()) {
            return super.m_6225_(useOnContext);
        }
        BlockEntity blockEntity = useOnContext.m_43725_().m_7702_(useOnContext.m_8083_());
        Player player = useOnContext.m_43723_();
        if (player != null && blockEntity instanceof AquariumTileEntity && (tileEntity = (AquariumTileEntity)blockEntity).processContainer(player, useOnContext.m_43724_())) {
            return InteractionResult.SUCCESS;
        }
        if (player != null && player.m_6047_() && useOnContext.m_43719_() == Direction.UP) {
            ItemStack itemInHand = useOnContext.m_43722_();
            CompoundTag itemTag = itemInHand.m_41784_().m_6426_();
            if (!itemTag.m_128441_(TAG_ENTITY_ID)) {
                return super.m_6225_(useOnContext);
            }
            ServerLevel level = (ServerLevel)useOnContext.m_43725_();
            ListTag pos = new ListTag();
            pos.add((Object)DoubleTag.m_128500_((double)((double)useOnContext.m_8083_().m_123341_() + 0.5)));
            pos.add((Object)DoubleTag.m_128500_((double)(useOnContext.m_8083_().m_123342_() + 1)));
            pos.add((Object)DoubleTag.m_128500_((double)((double)useOnContext.m_8083_().m_123343_() + 0.5)));
            itemTag.m_128365_("Pos", (Tag)pos);
            itemTag.m_128473_("UUID");
            itemTag.m_128473_(TAG_VARIANTS);
            itemTag.m_128473_(TAG_AMOUNT);
            EntityType.m_20642_((CompoundTag)itemTag, (Level)level).map(entity -> (WaterAnimal)entity).ifPresent(clone -> {
                level.m_7967_((Entity)clone);
                long amount = itemInHand.m_41784_().m_128454_(TAG_AMOUNT);
                itemInHand.m_41784_().m_128356_(TAG_AMOUNT, amount - 1L);
                if (amount - 1L <= 0L) {
                    itemInHand.m_41751_(new CompoundTag());
                }
                player.m_21008_(useOnContext.m_43724_(), itemInHand);
            });
        }
        return super.m_6225_(useOnContext);
    }

    private boolean matchEntity(ItemStack itemStack, LivingEntity entity) {
        CompoundTag itemTag = itemStack.m_41783_();
        if (itemTag == null || !itemTag.m_128441_(TAG_ENTITY_ID)) {
            return true;
        }
        String entityType = itemTag.m_128461_(TAG_ENTITY_ID);
        return new ResourceLocation(entityType).equals((Object)entity.m_6095_().arch$registryName());
    }

    private static Component getEntityTranslationName(String entityId) {
        EntityType entityType = EntityType.m_20632_((String)entityId).orElse(null);
        if (entityType != null) {
            return entityType.m_20676_();
        }
        return Component.m_237115_((String)entityId);
    }

    public static Optional<ListTag> getAnimalVariants(ItemStack itemStack) {
        if (itemStack.m_41784_().m_128441_(TAG_VARIANTS)) {
            return Optional.of(itemStack.m_41784_().m_128437_(TAG_VARIANTS, 10));
        }
        return Optional.empty();
    }

    public static boolean storeAnimalVariant(ItemStack itemStack, LivingEntity animal, @Nullable Player player) {
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getMaxStoredVariants() <= 0) {
            return false;
        }
        CompoundTag itemTag = itemStack.m_41784_();
        if (!itemTag.m_128441_(TAG_ENTITY_ID)) {
            return false;
        }
        ListTag variantList = itemTag.m_128437_(TAG_VARIANTS, 10);
        if (variantList.size() + 1 > AnimalPen.CONFIG_MANAGER.getConfiguration().getMaxStoredVariants()) {
            if (player != null) {
                player.m_5661_((Component)Component.m_237115_((String)"item.animal_pen.water_animal_container.error.too_many_variants").m_130940_(ChatFormatting.DARK_RED), true);
            }
            return false;
        }
        CompoundTag variant = new CompoundTag();
        animal.m_20223_(variant);
        variantList.add((Object)variant);
        itemTag.m_128365_(TAG_VARIANTS, (Tag)variantList);
        itemStack.m_41751_(itemTag);
        return true;
    }

    public static boolean canMergeAnimalVariants(ItemStack mainItem, ItemStack redundantItem, @Nullable Player player) {
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getMaxStoredVariants() <= 0) {
            return true;
        }
        CompoundTag itemTag = mainItem.m_41784_();
        CompoundTag redundantTag = redundantItem.m_41784_();
        if (!itemTag.m_128441_(TAG_ENTITY_ID) || !redundantTag.m_128441_(TAG_ENTITY_ID)) {
            return false;
        }
        ListTag variantList = itemTag.m_128437_(TAG_VARIANTS, 10);
        ListTag redundantList = redundantTag.m_128437_(TAG_VARIANTS, 10);
        if (variantList.size() + redundantList.size() > AnimalPen.CONFIG_MANAGER.getConfiguration().getMaxStoredVariants()) {
            if (player != null) {
                player.m_5661_((Component)Component.m_237115_((String)"item.animal_pen.water_animal_container.error.too_many_variants").m_130940_(ChatFormatting.DARK_RED), true);
            }
            return false;
        }
        return true;
    }

    public static void mergeAnimalVariants(ItemStack mainItem, ItemStack redundantItem, @Nullable Player player) {
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getMaxStoredVariants() <= 0) {
            return;
        }
        CompoundTag itemTag = mainItem.m_41784_();
        CompoundTag redundantTag = redundantItem.m_41784_();
        if (!itemTag.m_128441_(TAG_ENTITY_ID) || !redundantTag.m_128441_(TAG_ENTITY_ID)) {
            return;
        }
        ListTag variantList = itemTag.m_128437_(TAG_VARIANTS, 10);
        ListTag redundantList = redundantTag.m_128437_(TAG_VARIANTS, 10);
        for (Tag tag : redundantList) {
            if (variantList.size() + 1 > AnimalPen.CONFIG_MANAGER.getConfiguration().getMaxStoredVariants()) {
                if (player == null) break;
                player.m_5661_((Component)Component.m_237115_((String)"item.animal_pen.water_animal_container.error.too_many_variants").m_130940_(ChatFormatting.DARK_RED), true);
                break;
            }
            variantList.add((Object)tag);
        }
        itemTag.m_128365_(TAG_VARIANTS, (Tag)variantList);
        mainItem.m_41751_(itemTag);
    }
}

