/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import lv.id.bonne.animalpen.client.screens.VariantsConfigScreen;
import lv.id.bonne.animalpen.mixin.accessors.EntityAccessor;
import lv.id.bonne.animalpen.network.packets.RemoveDisplayAnimalData;
import lv.id.bonne.animalpen.network.packets.UpdateDisplayAnimalData;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1480;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4050;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import net.minecraft.class_898;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class VariantScreenSelection
extends class_437 {
    private final class_2338 position;
    private final int imageWidth;
    private final int cooldownWidth;
    private final int imageHeight;
    private final List<class_4185> buttons = new ArrayList<class_4185>();
    private final int buttonAreaHeight = 106;
    private final int sliderAreaWidth = 64;
    protected AnimalPenBlockInterface<?> blockEntityInterface;
    private int leftPos;
    private int topPos;
    private int bodyTopPos;
    private int sliderBarPos;
    private float currentVariantScroll;
    private boolean isScrollingVariants;
    private boolean isCooldownOpened;
    private int selectedButton = -1;
    private class_4185 deleteButton;
    private class_4185 applyButton;
    private class_4185 configureButton;
    private class_4185 cooldownButton;
    private class_1309 displayEntity;
    private float entityScale;
    private float entityOffset;
    private float entityRotation = -45.0f;
    private int currentXOnEntity;
    private boolean isSelectingEntity;
    private int needsUpdate;
    private static final class_2561 TITLE = new class_2588("gui.animal_pen.variant_selection_screen");
    private static final class_2561 APPLY = new class_2588("gui.animal_pen.variant_selection_screen.apply_tooltip");
    private static final class_2561 DELETE = new class_2588("gui.animal_pen.variant_selection_screen.delete_tooltip");
    private static final class_2561 SELECT_TO_DELETE = new class_2588("gui.animal_pen.variant_selection_screen.select_to_delete_tooltip");
    private static final class_2561 COOLDOWN_OPEN = new class_2588("gui.animal_pen.variant_selection_screen.cooldown_open_tooltip");
    private static final class_2561 COOLDOWN_CLOSE = new class_2588("gui.animal_pen.variant_selection_screen.cooldown_close_tooltip");
    private static final class_2561 CONFIGURE = new class_2588("gui.animal_pen.variant_selection_screen.configure_tooltip");
    private static final String BUTTON_TEXT = "gui.animal_pen.variant_selection_screen.select_variant";
    private static final String FIXED_TEXT = "gui.animal_pen.variant_selection_screen.fixed_size";
    private static final class_2960 TEXTURE = new class_2960("animal_pen", "textures/gui/animal_selection.png");
    private static final class_2960 COOLDOWN_TEXTURE = new class_2960("animal_pen", "textures/gui/cooldown_area.png");

    public VariantScreenSelection(class_2338 position) {
        super(TITLE);
        this.position = position;
        this.imageWidth = 176;
        this.imageHeight = 136;
        this.cooldownWidth = 149;
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        this.leftPos = this.isCooldownOpened ? (this.field_22789 - this.imageWidth + this.cooldownWidth) / 2 : (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        this.buttons.clear();
        this.bodyTopPos = this.topPos + 18;
        int buttonPos = this.leftPos + 24;
        int buttonWidth = 46;
        int buttonHeight = 20;
        if (this.field_22787 == null || this.field_22787.field_1687 == null) {
            return;
        }
        class_2586 blockEntity = this.field_22787.field_1687.method_8321(this.position);
        if (!(blockEntity instanceof AnimalPenBlockInterface)) {
            return;
        }
        AnimalPenBlockInterface animalPenEntity = (AnimalPenBlockInterface)blockEntity;
        this.blockEntityInterface = animalPenEntity;
        class_2499 entityList = this.blockEntityInterface.getEntityVariants();
        if (entityList == null) {
            entityList = new class_2499();
        }
        int i = 0;
        while (i < entityList.size()) {
            int y = this.bodyTopPos + i * buttonHeight;
            int index = i++;
            this.buttons.add((class_4185)this.method_25429((class_364)new class_4185(buttonPos, y, buttonWidth, buttonHeight, (class_2561)new class_2588(BUTTON_TEXT, new Object[]{index + 1}), button -> this.handleVariantButton(button, index))));
        }
        this.deleteButton = (class_4185)this.method_25429((class_364)new class_4185(this.leftPos + 157, this.topPos + 111, 11, 14, class_2585.field_24366, this::handleDeleteButton));
        this.deleteButton.field_22763 = this.blockEntityInterface.getOwner().map(uuid -> uuid.equals(this.field_22787.field_1724.method_5667())).orElse(true);
        this.applyButton = (class_4185)this.method_25429((class_364)new class_4185(this.leftPos + 73, this.topPos + 111, 14, 14, class_2585.field_24366, this::handleApplyButton));
        this.applyButton.field_22763 = false;
        this.sliderBarPos = this.leftPos + 89;
        this.configureButton = (class_4185)this.method_25429((class_364)new class_4185(this.leftPos + 160, this.topPos + 5, 10, 10, class_2585.field_24366, this::handleConfigureButton));
        class_2487 defaultAnimal = new class_2487();
        this.blockEntityInterface.getStoredAnimal().ifPresent(entity -> entity.method_5662(defaultAnimal));
        class_1299.method_5892((class_2487)defaultAnimal, (class_1937)this.field_22787.field_1687).map(entity -> (class_1309)entity).ifPresent(entity -> {
            this.displayEntity = entity;
            float width = this.displayEntity.method_17681();
            float height = this.displayEntity.method_17682();
            float entitySize = Math.max(1.0f, Math.max(width, height));
            this.entityScale = 60.0f / entitySize * 0.8f;
            this.entityOffset = Math.max(height, entitySize) * 0.5f;
        });
        this.cooldownButton = (class_4185)this.method_25429((class_364)new class_4185(this.leftPos - 12, this.topPos + (this.imageHeight - 18) / 2, 11, 18, (class_2561)new class_2585(""), this::handleCooldownButton));
    }

    public class_2338 getPosition() {
        return this.position;
    }

    public void update() {
        this.needsUpdate = 5;
    }

    public void method_25393() {
        super.method_25393();
        if (this.displayEntity != null) {
            ++this.displayEntity.field_6012;
        }
        if (!(this.field_22787.field_1687.method_8321(this.position) instanceof AnimalPenBlockInterface) || this.blockEntityInterface.getStoredAnimal().isEmpty()) {
            this.field_22787.method_1507(null);
            return;
        }
        if (this.needsUpdate > 0 && --this.needsUpdate == 0) {
            this.method_25426();
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(@NotNull class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(poseStack);
        this.updateButtonPositions();
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
        float f = (float)(this.leftPos + 88) - (float)this.field_22793.method_27525((class_5348)this.field_22785) / 2.0f;
        float f2 = this.topPos + 3 + 7;
        Objects.requireNonNull(this.field_22793);
        this.field_22793.method_30883(poseStack, this.field_22785, f, f2 - 9.0f / 2.0f, 0x404040);
        this.renderVariantButtons(poseStack, mouseX, mouseY, partialTicks);
        this.renderOtherButtons(poseStack, mouseX, mouseY);
        this.renderScrollBar(poseStack, mouseX, mouseY);
        this.renderTextBar(poseStack, mouseX, mouseY, partialTicks);
        this.renderEntity(poseStack, partialTicks);
        this.renderCooldown(poseStack, mouseX, mouseY, partialTicks);
        this.renderTooltips(poseStack, mouseX, mouseY, partialTicks);
    }

    public void method_25420(class_4587 poseStack) {
        super.method_25420(poseStack);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        int offsetX = this.leftPos;
        int offsetY = this.topPos;
        this.method_25302(poseStack, offsetX, offsetY, 0, 0, this.imageWidth, this.imageHeight);
    }

    private void renderVariantButtons(@NotNull class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.enableScissor(10, this.bodyTopPos, this.field_22789 - 10, this.bodyTopPos + this.buttonAreaHeight);
        for (int i = 0; i < this.buttons.size(); ++i) {
            class_4185 button = this.buttons.get(i);
            button.method_25394(poseStack, mouseX, mouseY, partialTicks);
            if (i != this.selectedButton) continue;
            this.renderButtonBorder(poseStack, button, -2147418368);
        }
        this.disableScissor();
    }

    private void renderButtonBorder(class_4587 poseStack, class_4185 button, int color) {
        int width = button.method_25368();
        int height = button.method_25364();
        VariantScreenSelection.method_25294((class_4587)poseStack, (int)button.field_22760, (int)button.field_22761, (int)(button.field_22760 + width), (int)(button.field_22761 + 1), (int)color);
        VariantScreenSelection.method_25294((class_4587)poseStack, (int)button.field_22760, (int)(button.field_22761 + height - 1), (int)(button.field_22760 + width), (int)(button.field_22761 + height), (int)color);
        VariantScreenSelection.method_25294((class_4587)poseStack, (int)button.field_22760, (int)button.field_22761, (int)(button.field_22760 + 1), (int)(button.field_22761 + height), (int)color);
        VariantScreenSelection.method_25294((class_4587)poseStack, (int)(button.field_22760 + width - 1), (int)button.field_22761, (int)(button.field_22760 + width), (int)(button.field_22761 + height), (int)color);
    }

    private void renderOtherButtons(@NotNull class_4587 poseStack, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        if (this.blockEntityInterface.getOwner().map(uuid -> uuid.equals(this.field_22787.field_1724.method_5667())).orElse(true).booleanValue()) {
            this.method_25302(poseStack, this.deleteButton.field_22760 + 1, this.deleteButton.field_22761 + 1, 176 + (this.selectedButton != -1 ? 0 : 9), 39, 9, 12);
            this.method_25302(poseStack, this.applyButton.field_22760 + 1, this.applyButton.field_22761 + 1, 176 + (this.selectedButton != -1 ? 0 : 12), 51, 12, 12);
        }
        this.method_25302(poseStack, this.configureButton.field_22760, this.configureButton.field_22761, 176, 63, 10, 10);
    }

    private void renderScrollBar(@NotNull class_4587 poseStack, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        int scrollThumbHeight = 15;
        int scrollPosition = this.needsScrollBars() ? this.bodyTopPos + (int)((float)(this.buttonAreaHeight - scrollThumbHeight) * this.currentVariantScroll) : this.bodyTopPos;
        this.method_25302(poseStack, this.leftPos + 9, scrollPosition, 176 + (this.needsScrollBars() ? 0 : 12), 0, 12, scrollThumbHeight);
    }

    private void renderTextBar(@NotNull class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        float f;
        class_2588 text = new class_2588(FIXED_TEXT, new Object[]{this.blockEntityInterface.getAnimalCount()});
        poseStack.method_22903();
        float textWidth = this.field_22793.method_27525((class_5348)text);
        Objects.requireNonNull(this);
        float scale = Math.min(1.0f, 64.0f / textWidth);
        double d = this.sliderBarPos;
        float f2 = this.topPos + 112 + 7;
        Objects.requireNonNull(this.field_22793);
        poseStack.method_22904(d, (double)(f2 - 9.0f * scale / 2.0f), 0.0);
        poseStack.method_22905(scale, scale, 1.0f);
        if (scale < 1.0f) {
            f = 0.0f;
        } else {
            Objects.requireNonNull(this);
            f = (64.0f - textWidth) / 2.0f;
        }
        this.field_22793.method_30883(poseStack, (class_2561)text, f, 0.0f, 0xFFFFFF);
        poseStack.method_22909();
    }

    private void renderEntity(@NotNull class_4587 poseStack, float partialTicks) {
        float x = this.leftPos + 73 + 48;
        float y = this.bodyTopPos + 46;
        this.displayEntity.field_6283 = 0.0f;
        this.displayEntity.method_36456(0.0f);
        this.displayEntity.field_6241 = 0.0f;
        this.displayEntity.field_6259 = 0.0f;
        class_1309 class_13092 = this.displayEntity;
        if (class_13092 instanceof class_1480) {
            class_1480 animal = (class_1480)class_13092;
            animal.method_18380(class_4050.field_18079);
            animal.method_5796(true);
            ((EntityAccessor)animal).setWasTouchingWater(true);
            y -= 10.0f;
        }
        poseStack.method_22903();
        poseStack.method_22904((double)x, (double)y, 50.0);
        poseStack.method_22905(this.entityScale, this.entityScale, this.entityScale);
        poseStack.method_22904(0.0, (double)this.entityOffset, 0.0);
        poseStack.method_22907(class_1160.field_20707.method_23214(180.0f));
        poseStack.method_22907(class_1160.field_20705.method_23214(this.entityRotation));
        class_898 erd = class_310.method_1551().method_1561();
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        erd.method_3948(false);
        erd.method_3954((class_1297)this.displayEntity, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, (class_4597)immediate, 0xF000F0);
        erd.method_3948(true);
        immediate.method_22993();
        poseStack.method_22909();
    }

    private void renderCooldown(@NotNull class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderTexture((int)0, (class_2960)COOLDOWN_TEXTURE);
        this.method_25302(poseStack, this.leftPos - 12, this.topPos + (this.imageHeight - 18) / 2, 149 + (this.isCooldownOpened ? 0 : 11), this.cooldownButton.method_25405((double)mouseX, (double)mouseY) ? 18 : 1, 11, 18);
        if (this.isCooldownOpened) {
            this.method_25302(poseStack, this.leftPos - 12 - this.cooldownWidth, this.topPos, 0, 1, this.cooldownWidth, this.imageHeight + 1);
            List<Pair<class_1799[], class_2561>> textList = this.blockEntityInterface.getCooldownLines(false);
            if (!textList.isEmpty()) {
                int leftOffset = this.leftPos - this.cooldownWidth;
                Objects.requireNonNull(this.field_22793);
                int top = this.topPos + 9;
                for (int i = 0; i < textList.size(); ++i) {
                    this.renderTextLine(poseStack, textList.get(i), leftOffset, top + i * 16, mouseX, mouseY);
                }
            }
        }
    }

    private void renderTextLine(@NotNull class_4587 poseStack, Pair<class_1799[], class_2561> componentPair, int leftOffset, int y, int mouseX, int mouseY) {
        class_2561 text = (class_2561)componentPair.getRight();
        class_1799 first = ((class_1799[])componentPair.getLeft()).length > 0 ? ((class_1799[])componentPair.getLeft())[0] : null;
        class_1799 second = ((class_1799[])componentPair.getLeft()).length > 1 ? ((class_1799[])componentPair.getLeft())[1] : null;
        ArrayList<Pair> itemPositions = new ArrayList<Pair>();
        int whiteSpace = this.field_22793.method_1727(" ");
        boolean isFirst = true;
        for (class_2561 part : text.method_36136(class_2583.field_24360)) {
            String content = part.getString();
            if (content.equals("\ue000")) {
                if (first == null) continue;
                if (!isFirst) {
                    leftOffset -= whiteSpace;
                }
                this.field_22788.method_4010(first, leftOffset, y);
                itemPositions.add(Pair.of((Object)first, (Object)new class_768(leftOffset, y, 16, 16)));
                leftOffset += 16 - whiteSpace;
            } else if (content.equals("\ue001")) {
                if (second == null) continue;
                if (!isFirst) {
                    leftOffset -= whiteSpace;
                }
                this.field_22788.method_4010(second, leftOffset, y);
                itemPositions.add(Pair.of((Object)second, (Object)new class_768(leftOffset, y, 16, 16)));
                leftOffset += 16 - whiteSpace;
            } else {
                float f = leftOffset;
                float f2 = y;
                Objects.requireNonNull(this.field_22793);
                this.field_22793.method_30883(poseStack, part, f, f2 + 9.0f / 2.0f + 2.0f, 0xFFFFFF);
                leftOffset += this.field_22793.method_27525((class_5348)part);
            }
            isFirst = false;
        }
        for (Pair itemPos : itemPositions) {
            class_768 rect = (class_768)itemPos.getRight();
            if (mouseX < rect.method_3321() || mouseX > rect.method_3321() + rect.method_3319() || mouseY < rect.method_3322() || mouseY > rect.method_3322() + rect.method_3320()) continue;
            this.method_25409(poseStack, (class_1799)itemPos.getLeft(), mouseX, mouseY);
            break;
        }
    }

    private void renderTooltips(@NotNull class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.applyButton.method_25405((double)mouseX, (double)mouseY)) {
            this.method_25424(poseStack, APPLY, mouseX, mouseY);
        }
        if (this.deleteButton.method_25405((double)mouseX, (double)mouseY)) {
            this.method_25424(poseStack, this.selectedButton != -1 ? DELETE : SELECT_TO_DELETE, mouseX, mouseY);
        }
        if (this.cooldownButton.method_25405((double)mouseX, (double)mouseY)) {
            this.method_25424(poseStack, this.isCooldownOpened ? COOLDOWN_CLOSE : COOLDOWN_OPEN, mouseX, mouseY);
        }
        if (this.configureButton.method_25405((double)mouseX, (double)mouseY)) {
            this.method_25424(poseStack, CONFIGURE, mouseX, mouseY);
        }
    }

    private void enableScissor(int x1, int y1, int x2, int y2) {
        double scale = this.field_22787.method_22683().method_4495();
        RenderSystem.enableScissor((int)((int)((double)x1 * scale)), (int)((int)((double)this.field_22787.method_22683().method_4506() - (double)y2 * scale)), (int)((int)((double)(x2 - x1) * scale)), (int)((int)((double)(y2 - y1) * scale)));
    }

    private void disableScissor() {
        RenderSystem.disableScissor();
    }

    private boolean needsScrollBars() {
        return this.buttons.size() > 5;
    }

    private void handleDeleteButton(class_4185 button) {
        if (this.selectedButton == -1) {
            return;
        }
        NetworkManager.sendToServer((class_2960)RemoveDisplayAnimalData.ID, (class_2540)RemoveDisplayAnimalData.encode(this.position, this.selectedButton));
        this.selectedButton = -1;
        this.applyButton.field_22763 = false;
        this.method_25426();
    }

    private void handleApplyButton(class_4185 button) {
        NetworkManager.sendToServer((class_2960)UpdateDisplayAnimalData.ID, (class_2540)UpdateDisplayAnimalData.encode(this.position, this.blockEntityInterface.getEntityVariants().method_10602(this.selectedButton)));
        this.displayEntity.method_5651(this.blockEntityInterface.getEntityVariants().method_10602(this.selectedButton));
        this.selectedButton = -1;
    }

    private void handleVariantButton(class_4185 button, int index) {
        class_2487 tag;
        if (button.field_22761 + button.method_25364() < this.bodyTopPos || button.field_22761 > this.bodyTopPos + this.buttonAreaHeight) {
            return;
        }
        if (this.selectedButton == index) {
            this.selectedButton = -1;
            this.applyButton.field_22763 = false;
        } else {
            this.selectedButton = index;
            boolean bl = this.applyButton.field_22763 = !this.buttons.isEmpty() && this.blockEntityInterface.getOwner().map(uuid -> uuid.equals(this.field_22787.field_1724.method_5667())).orElse(true) != false;
        }
        if (this.selectedButton != -1) {
            tag = (class_2487)this.blockEntityInterface.getEntityVariants().method_10534(index);
        } else {
            tag = new class_2487();
            this.blockEntityInterface.getStoredAnimal().ifPresent(entity -> entity.method_5662(tag));
        }
        this.displayEntity.method_5651(tag);
        this.currentXOnEntity = 0;
    }

    private void handleConfigureButton(class_4185 button) {
        this.field_22787.method_1507((class_437)new VariantsConfigScreen(this));
    }

    private void handleCooldownButton(class_4185 button) {
        this.isCooldownOpened = !this.isCooldownOpened;
        this.method_25426();
    }

    private boolean scrollBarClicked(double mouseX, double mouseY) {
        int scrollLeft = this.leftPos + 9;
        int scrollRight = scrollLeft + 12;
        int scrollBottom = this.bodyTopPos + this.buttonAreaHeight;
        return mouseX >= (double)scrollLeft && mouseY >= (double)this.bodyTopPos && mouseX < (double)scrollRight && mouseY < (double)scrollBottom;
    }

    private boolean entityAreaClicked(double mouseX, double mouseY) {
        int left = this.leftPos + 73;
        int top = this.bodyTopPos;
        int right = left + 96;
        int bottom = top + 92;
        return mouseX >= (double)left && mouseX < (double)right && mouseY >= (double)top && mouseY < (double)bottom;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.scrollBarClicked(mouseX, mouseY)) {
            this.isScrollingVariants = true;
            this.method_25403(mouseX, mouseY, button, 0.0, 0.0);
            return true;
        }
        if (this.entityAreaClicked(mouseX, mouseY)) {
            this.currentXOnEntity = (int)mouseX;
            this.isSelectingEntity = true;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isSelectingEntity = false;
        this.isScrollingVariants = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!this.needsScrollBars()) {
            return false;
        }
        this.currentVariantScroll = (float)((double)this.currentVariantScroll - amount / 10.0);
        this.currentVariantScroll = class_3532.method_15363((float)this.currentVariantScroll, (float)0.0f, (float)1.0f);
        this.updateButtonPositions();
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrollingVariants && this.needsScrollBars()) {
            int scrollBottom = this.bodyTopPos + this.buttonAreaHeight;
            this.currentVariantScroll = ((float)mouseY - (float)this.bodyTopPos) / (float)(scrollBottom - this.bodyTopPos);
            this.currentVariantScroll = class_3532.method_15363((float)this.currentVariantScroll, (float)0.0f, (float)1.0f);
            this.updateButtonPositions();
            return true;
        }
        if (this.isSelectingEntity) {
            int deltaX = (int)mouseX - this.currentXOnEntity;
            this.entityRotation -= (float)deltaX;
            while (this.entityRotation < 0.0f) {
                this.entityRotation += 360.0f;
            }
            while (this.entityRotation >= 360.0f) {
                this.entityRotation -= 360.0f;
            }
            this.currentXOnEntity = (int)mouseX;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 265 || keyCode == 264) && this.buttons.size() > 1) {
            int button = keyCode == 264 ? Math.min(this.selectedButton + 1, this.buttons.size() - 1) : Math.max(this.selectedButton - 1, 0);
            if (button != this.selectedButton) {
                this.ensureButtonVisible(button);
                this.handleVariantButton(this.buttons.get(button), button);
            }
            return true;
        }
        if (keyCode == 257) {
            if (this.selectedButton >= 0 && this.selectedButton < this.buttons.size() && this.applyButton.method_37303()) {
                this.handleApplyButton(null);
                return true;
            }
        } else if (keyCode == 261 && this.selectedButton >= 0 && this.selectedButton < this.buttons.size()) {
            this.handleDeleteButton(null);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    private void updateButtonPositions() {
        int buttonHeight = 20;
        int totalButtonsHeight = this.buttons.size() * buttonHeight;
        int maxScrollPixels = Math.max(0, totalButtonsHeight - this.buttonAreaHeight);
        int scrollOffset = (int)((float)maxScrollPixels * this.currentVariantScroll);
        for (int i = 0; i < this.buttons.size(); ++i) {
            class_4185 button = this.buttons.get(i);
            button.field_22761 = this.bodyTopPos + i * buttonHeight - scrollOffset;
        }
    }

    private void ensureButtonVisible(int buttonIndex) {
        if (buttonIndex < 0 || buttonIndex >= this.buttons.size()) {
            return;
        }
        class_4185 targetButton = this.buttons.get(buttonIndex);
        int buttonTop = targetButton.field_22761;
        int buttonBottom = buttonTop + targetButton.method_25364();
        float areaDifference = this.buttons.size() * targetButton.method_25364() - this.buttonAreaHeight;
        if (buttonTop < this.bodyTopPos) {
            float newScrollPos = (float)(this.bodyTopPos - buttonTop) / areaDifference;
            this.currentVariantScroll = class_3532.method_15363((float)(this.currentVariantScroll - newScrollPos), (float)0.0f, (float)1.0f);
            this.updateButtonPositions();
        } else if (buttonBottom > this.bodyTopPos + this.buttonAreaHeight) {
            float newScrollPos = (float)(buttonBottom - this.bodyTopPos - 106) / areaDifference;
            this.currentVariantScroll = class_3532.method_15363((float)(this.currentVariantScroll + newScrollPos), (float)0.0f, (float)1.0f);
            this.updateButtonPositions();
        }
    }
}

