/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.client.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.networking.NetworkManager;
import lv.id.bonne.animalpen.client.screens.VariantScreenSelection;
import lv.id.bonne.animalpen.network.packets.UpdateConfigurationData;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class VariantsConfigScreen
extends Screen {
    private final VariantScreenSelection parent;
    private final long maxAnimalAmount;
    private long displayAnimalAmount;
    private long minimalAnimalCount;
    private boolean enableProtection;
    private DisplayAnimalAmountSlider displayAnimalAmountSlider;
    private EditBox minimalAnimalCountField;
    private Checkbox protectionCheckbox;
    public static final TranslatableComponent TITLE = new TranslatableComponent("gui.animal_pen.variant_selection_screen.configure.title");
    public static final TranslatableComponent MINIMAL_ANIMAL_COUNT = new TranslatableComponent("gui.animal_pen.variant_selection_screen.configure.minimal_animal_count");
    public static final TranslatableComponent PROTECTION = new TranslatableComponent("gui.animal_pen.variant_selection_screen.configure.enable_protection");
    public static final TranslatableComponent SAVE = new TranslatableComponent("gui.animal_pen.variant_selection_screen.configure.save");
    public static final TranslatableComponent CANCEL = new TranslatableComponent("gui.animal_pen.variant_selection_screen.configure.cancel");

    public VariantsConfigScreen(VariantScreenSelection parent) {
        super((Component)TITLE);
        this.parent = parent;
        this.maxAnimalAmount = this.parent.blockEntityInterface.getAnimalCount();
        this.displayAnimalAmount = this.parent.blockEntityInterface.getAnimalDisplaySize();
        if (!this.parent.blockEntityInterface.canGrowEntity()) {
            this.displayAnimalAmount = this.maxAnimalAmount;
        }
        this.minimalAnimalCount = this.parent.blockEntityInterface.getProtectedAmount();
        this.enableProtection = this.parent.blockEntityInterface.getOwner().isPresent();
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int startY = this.f_96544_ / 2 - 60;
        boolean canEdit = this.parent.blockEntityInterface.getOwner().isEmpty() || this.parent.blockEntityInterface.getOwner().map(owner -> owner.equals(this.f_96541_.f_91074_.m_142081_())).orElse(false) != false;
        this.displayAnimalAmountSlider = new DisplayAnimalAmountSlider(centerX - 100, startY, 200, 20, (int)this.displayAnimalAmount, (int)this.maxAnimalAmount);
        this.m_142416_((GuiEventListener)this.displayAnimalAmountSlider);
        this.displayAnimalAmountSlider.f_93623_ = canEdit;
        if (!this.parent.blockEntityInterface.canGrowEntity()) {
            this.displayAnimalAmountSlider.f_93623_ = false;
        }
        this.minimalAnimalCountField = new EditBox(this.f_96547_, centerX - 100, startY + 40, 200, 20, (Component)MINIMAL_ANIMAL_COUNT);
        this.minimalAnimalCountField.m_94144_(String.valueOf(this.minimalAnimalCount));
        this.minimalAnimalCountField.m_94153_(this::isValidNumber);
        this.minimalAnimalCountField.m_94199_(3);
        this.m_142416_((GuiEventListener)this.minimalAnimalCountField);
        this.minimalAnimalCountField.m_94186_(canEdit);
        this.protectionCheckbox = new Checkbox(centerX - 100, startY + 80, 200, 20, (Component)PROTECTION, this.enableProtection);
        this.m_142416_((GuiEventListener)this.protectionCheckbox);
        this.protectionCheckbox.f_93623_ = canEdit;
        this.m_142416_((GuiEventListener)new Button(centerX - 102, startY + 120, 100, 20, (Component)SAVE, this::onSave));
        this.m_142416_((GuiEventListener)new Button(centerX + 2, startY + 120, 100, 20, (Component)CANCEL, this::onCancel));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        VariantsConfigScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        int centerX = this.f_96543_ / 2;
        int startY = this.f_96544_ / 2 - 60;
        TranslatableComponent size = new TranslatableComponent("gui.animal_pen.variant_selection_screen.configure.entity_size", new Object[]{this.displayAnimalAmountSlider.getIntValue(), this.maxAnimalAmount});
        VariantsConfigScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)size, (int)(centerX - 100), (int)(startY - 12), (int)0xFFFFFF);
        VariantsConfigScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)MINIMAL_ANIMAL_COUNT, (int)(centerX - 100), (int)(startY + 28), (int)0xFFFFFF);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void onSave(Button button) {
        this.displayAnimalAmount = this.displayAnimalAmountSlider.getIntValue();
        try {
            int inputValue = Integer.parseInt(this.minimalAnimalCountField.m_94155_());
            if (inputValue < 0) {
                this.minimalAnimalCount = 0L;
                this.minimalAnimalCountField.m_94144_("0");
            } else {
                this.minimalAnimalCount = inputValue;
            }
        }
        catch (NumberFormatException e) {
            this.minimalAnimalCountField.m_94144_(String.valueOf(this.minimalAnimalCount));
        }
        this.enableProtection = this.protectionCheckbox.m_93840_();
        if (this.parent.blockEntityInterface.getOwner().isEmpty() || this.parent.blockEntityInterface.getOwner().map(owner -> owner.equals(this.f_96541_.f_91074_.m_142081_())).orElse(false).booleanValue()) {
            this.saveConfiguration();
        }
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    private void onCancel(Button button) {
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    private void saveConfiguration() {
        NetworkManager.sendToServer((ResourceLocation)UpdateConfigurationData.ID, (FriendlyByteBuf)UpdateConfigurationData.encode(this.parent.getPosition(), this.displayAnimalAmount, this.minimalAnimalCount, this.enableProtection ? this.f_96541_.f_91074_.m_142081_() : null));
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    private boolean isValidNumber(String input) {
        if (input.isEmpty()) {
            return true;
        }
        try {
            int value = Integer.parseInt(input);
            return value >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static class DisplayAnimalAmountSlider
    extends AbstractSliderButton {
        private final int maxValue;

        public DisplayAnimalAmountSlider(int x, int y, int width, int height, int initialValue, int maxValue) {
            super(x, y, width, height, TextComponent.f_131282_, (double)(initialValue - 1) / (double)Math.max(1, maxValue - 1));
            this.maxValue = maxValue;
            this.m_5695_();
        }

        protected void m_5695_() {
            this.m_93666_((Component)new TextComponent(String.valueOf(this.getIntValue())));
        }

        protected void m_5697_() {
        }

        public int getIntValue() {
            if (this.maxValue == 1) {
                return 1;
            }
            int minValue = 1;
            return minValue + (int)((double)(this.maxValue - minValue) * this.f_93577_);
        }
    }
}

