/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.network.packets;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class UpdateConfigurationData {
    public static final ResourceLocation ID = new ResourceLocation("animal_pen", "update_configuration");

    public static FriendlyByteBuf encode(BlockPos position, long displaySize, long protectedAmount, @Nullable UUID owner) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130064_(position);
        buffer.writeLong(displaySize);
        buffer.writeLong(protectedAmount);
        if (owner != null) {
            buffer.writeBoolean(true);
            buffer.m_130077_(owner);
        } else {
            buffer.writeBoolean(false);
        }
        return buffer;
    }

    public static void handle(FriendlyByteBuf friendlyByteBuf, NetworkManager.PacketContext packetContext) {
        BlockPos blockPos = friendlyByteBuf.m_130135_();
        long displaySize = friendlyByteBuf.readLong();
        long protectedAmount = friendlyByteBuf.readLong();
        boolean hasUUID = friendlyByteBuf.readBoolean();
        UUID owner = hasUUID ? friendlyByteBuf.m_130259_() : null;
        packetContext.queue(() -> {
            Level level = packetContext.getPlayer().m_183503_();
            BlockEntity patt0$temp = level.m_7702_(blockPos);
            if (patt0$temp instanceof AnimalPenBlockInterface) {
                AnimalPenBlockInterface animalPen = (AnimalPenBlockInterface)patt0$temp;
                animalPen.setAnimalDisplaySize(displaySize);
                animalPen.setProtectedAmount(protectedAmount);
                animalPen.setOwner(owner);
            } else {
                AnimalPen.LOGGER.error("Block entity not found at the position!");
            }
        });
    }
}

