/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.platform.Platform;
import java.util.Map;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.registries.AnimalPenFoodRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Ingredient;

public class AnimalFoodReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();
    private static final String FOLDER = "animal_foods";

    public AnimalFoodReloadListener() {
        super(GSON, FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        AnimalPenFoodRegistry.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonMap.entrySet()) {
            ResourceLocation id = entry.getKey();
            try {
                Ingredient ingredient;
                String modId;
                JsonPrimitive primitive;
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) {
                    AnimalPen.LOGGER.error("Invalid JSON format for " + String.valueOf(id) + ": Expected a JSON object.");
                    continue;
                }
                JsonObject json = element.getAsJsonObject();
                if (json.has("condition") && json.get("condition").isJsonPrimitive() && (primitive = json.getAsJsonPrimitive("condition")).isString() && primitive.getAsString().startsWith("mod:") && !(modId = primitive.getAsString().substring(4)).isBlank() && !Platform.isModLoaded((String)modId)) continue;
                JsonArray ingredientsArray = json.has("food_items") && json.get("food_items").isJsonArray() ? json.getAsJsonArray("food_items") : new JsonArray();
                try {
                    ingredient = (Ingredient)Ingredient.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)ingredientsArray).getOrThrow(text -> {
                        AnimalPen.LOGGER.error("Error parsing ingredient in " + String.valueOf(id) + ": " + text);
                        return new IllegalArgumentException((String)text);
                    });
                }
                catch (Exception e) {
                    continue;
                }
                AnimalPenFoodRegistry.AnimalFoodData data = new AnimalPenFoodRegistry.AnimalFoodData(ingredient);
                AnimalPenFoodRegistry.register(id, data);
            }
            catch (JsonSyntaxException e) {
                AnimalPen.LOGGER.error("JSON syntax error in " + String.valueOf(id) + ": " + e.getMessage());
            }
            catch (Exception e) {
                AnimalPen.LOGGER.error("Error processing file " + String.valueOf(id) + ": " + e.getMessage());
            }
        }
        AnimalPen.LOGGER.info("Loaded " + AnimalPenFoodRegistry.getAll().size() + " animal food entries.");
    }
}

