/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.time.LocalTime;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Frog.class})
public abstract class AnimalPenFrog
extends AnimalPenAnimal {
    @Unique
    private int animalPen$frogLightCooldown;

    protected AnimalPenFrog(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract Holder<FrogVariant> getVariant();

    @Override
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$frogLightCooldown > 0) {
            --this.animalPen$frogLightCooldown;
            return true;
        }
        return value;
    }

    @Override
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.putInt("frog_light_cooldown", this.animalPen$frogLightCooldown);
    }

    @Override
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$frogLightCooldown = tag.getInt("frog_light_cooldown");
    }

    @Override
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.MAGMA_BLOCK)) {
            Item frogLightItem;
            if (this.animalPen$frogLightCooldown > 0) {
                AnimalPen.sendDebug("Under cooldown for " + this.animalPen$frogLightCooldown);
                return false;
            }
            if (player.level().isClientSide()) {
                return true;
            }
            int froglightCount = (int)Math.min(this.animalPen$animalCount, (long)itemStack.getCount());
            int dropLimits = AnimalPen.config().getDropLimits(Items.PEARLESCENT_FROGLIGHT);
            if (dropLimits > 0) {
                froglightCount = Math.min(froglightCount, dropLimits);
            }
            if ((frogLightItem = this.pen$getFrogLightItem()) == null) {
                return false;
            }
            itemStack.shrink(froglightCount);
            if (itemStack.getCount() <= 0) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            } else {
                player.setItemInHand(hand, itemStack);
            }
            while (froglightCount > 0) {
                ItemStack frogLight = new ItemStack((ItemLike)frogLightItem);
                if (froglightCount > 64) {
                    frogLight.setCount(64);
                    froglightCount -= 64;
                } else {
                    frogLight.setCount(froglightCount);
                    froglightCount = 0;
                }
                Block.popResource((Level)player.level(), (BlockPos)position.above(), (ItemStack)frogLight);
            }
            player.level().playSound(null, position, SoundEvents.FROG_EAT, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$frogLightCooldown = AnimalPen.config().getEntityCooldown(this.getType(), Items.MAGMA_BLOCK, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        List<Pair<ItemStack[], Component>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (!AnimalPen.config().isShowAllInteractions() && shortLine && AnimalPen.config().getEntityCooldown(this.getType(), Items.MAGMA_BLOCK, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = this.animalPen$frogLightCooldown == 0 ? Component.translatable((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.full_ready"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001")}).withStyle(ChatFormatting.GREEN) : Component.translatable((String)(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.frog_light_cooldown"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$frogLightCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
        Item frogLightItem = this.pen$getFrogLightItem();
        if (frogLightItem != null) {
            lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.MAGMA_BLOCK.getDefaultInstance(), frogLightItem.getDefaultInstance()}, (Object)component));
        }
        return lines;
    }

    @Override
    @Intrinsic
    public int animalPen$getRedStoneSignal() {
        if (this.animalPen$frogLightCooldown > 0) {
            return super.animalPen$getRedStoneSignal();
        }
        return super.animalPen$getRedStoneSignal() | 4;
    }

    @Unique
    @Nullable
    private Item pen$getFrogLightItem() {
        Holder<FrogVariant> variant = this.getVariant();
        Object frogLightItem = variant.is(FrogVariant.WARM) ? Items.PEARLESCENT_FROGLIGHT : (variant.is(FrogVariant.COLD) ? Items.VERDANT_FROGLIGHT : (variant.is(FrogVariant.TEMPERATE) ? Items.OCHRE_FROGLIGHT : null));
        return frogLightItem;
    }
}

