/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.registries;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class AnimalPenFoodRegistry {
    private static final Map<ResourceLocation, AnimalFoodData> DATA = new HashMap<ResourceLocation, AnimalFoodData>();
    private static final AnimalFoodData EMPTY = new AnimalFoodData(Ingredient.EMPTY);

    public static void setSyncedData(Map<ResourceLocation, AnimalFoodData> newData) {
        DATA.clear();
        DATA.putAll(newData);
    }

    public static void clear() {
        DATA.clear();
    }

    public static void register(ResourceLocation id, AnimalFoodData data) {
        DATA.put(id, data);
    }

    public static AnimalFoodData get(ResourceLocation id) {
        return DATA.get(id);
    }

    public static Map<ResourceLocation, AnimalFoodData> getAll() {
        return Collections.unmodifiableMap(DATA);
    }

    public static boolean isFood(ResourceLocation entity, ItemStack stack) {
        return DATA.getOrDefault(entity, EMPTY).matches(stack);
    }

    @Nullable
    public static ItemStack[] getFood(ResourceLocation entity) {
        if (!DATA.containsKey(entity)) {
            return null;
        }
        if (DATA.get(entity).ingredient().isEmpty()) {
            return null;
        }
        return DATA.get(entity).ingredient().getItems();
    }

    public record AnimalFoodData(Ingredient ingredient) {
        public static final StreamCodec<RegistryFriendlyByteBuf, AnimalFoodData> STREAM_CODEC = Ingredient.CONTENTS_STREAM_CODEC.map(AnimalFoodData::new, AnimalFoodData::ingredient);

        public boolean matches(ItemStack stack) {
            return this.ingredient.test(stack);
        }
    }
}

