/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import lv.id.bonne.animalpen.registries.AnimalPenTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Sheep.class})
public abstract class AnimalPenSheep
extends AnimalPenAnimal {
    @Unique
    private int animalPen$woolCooldown;

    protected AnimalPenSheep(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract void setColor(DyeColor var1);

    @Shadow
    public abstract void setSheared(boolean var1);

    @Shadow
    public abstract boolean isSheared();

    @Shadow
    public abstract DyeColor getColor();

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$woolCooldown > 0) {
            --this.animalPen$woolCooldown;
            return true;
        }
        if (this.isSheared()) {
            this.setSheared(false);
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.putInt("wool_cooldown", this.animalPen$woolCooldown);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$woolCooldown = tag.getIntOr("wool_cooldown", 0);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.SHEARS) || itemStack.is(AnimalPenTags.COMMON_SHEARS)) {
            ObjectArrayList randomItems;
            if (this.animalPen$woolCooldown > 0) {
                AnimalPen.sendDebug("Under cooldown for " + this.animalPen$woolCooldown);
                return false;
            }
            Level level = player.level();
            if (!(level instanceof ServerLevel)) {
                return true;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            this.setSheared(true);
            AnimalPenInterface.triggerItemUse((Entity)this, (ServerPlayer)player, itemStack, 1);
            itemStack.hurtAndBreak(1, (LivingEntity)player, AnimalPenSheep.getSlotForHand((InteractionHand)hand));
            LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.SHEAR_SHEEP);
            LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)position.getCenter()).withParameter(LootContextParams.THIS_ENTITY, (Object)((Sheep)this)).withParameter(LootContextParams.TOOL, (Object)itemStack).create(LootContextParamSets.SHEARING);
            int dropLimits = AnimalPen.config().getDropLimits(Items.WHITE_WOOL);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            ArrayList itemStackList = new ArrayList();
            int animalCounter = 0;
            for (int woolCount = 0; woolCount <= dropLimits && (long)animalCounter++ < this.animalPen$animalCount && !(randomItems = lootTable.getRandomItems(lootParams)).isEmpty(); woolCount += randomItems.stream().mapToInt(ItemStack::getCount).sum()) {
                randomItems.forEach(item -> {
                    boolean added = false;
                    for (ItemStack stack : itemStackList) {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)stack) || stack.getCount() >= stack.getMaxStackSize()) continue;
                        stack.grow(item.getCount());
                        added = true;
                        break;
                    }
                    if (!added) {
                        itemStackList.add(item);
                    }
                });
            }
            itemStackList.forEach(seedStack -> Block.popResource((Level)player.level(), (BlockPos)position.above(), (ItemStack)seedStack));
            this.setSheared(true);
            player.level().playSound(null, position, SoundEvents.SHEEP_SHEAR, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$woolCooldown = AnimalPen.config().getEntityCooldown(this.getType(), Items.SHEARS, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return true;
        }
        Item item2 = itemStack.getItem();
        if (item2 instanceof DyeItem) {
            DyeItem dye = (DyeItem)item2;
            if (player.level().isClientSide()) {
                return true;
            }
            this.setColor(dye.getDyeColor());
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
                player.setItemInHand(hand, itemStack);
            }
            player.level().playSound(null, position, SoundEvents.DYE_USE, SoundSource.NEUTRAL, 1.0f, 1.0f);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public ItemStack animalPen$animalPenInteract(ServerLevel level, ItemStack itemStack, BlockPos position) {
        if (itemStack.is(Items.SHEARS) || itemStack.is(AnimalPenTags.COMMON_SHEARS)) {
            if (this.animalPen$woolCooldown > 0) {
                AnimalPen.sendDebug("Under cooldown for " + this.animalPen$woolCooldown);
                return ItemStack.EMPTY;
            }
            this.setSheared(true);
            itemStack.hurtAndBreak(1, level, null, item -> {});
            Item itemLike = this.pen$getWoolItem(this.getColor());
            int dropLimits = AnimalPen.config().getDropLimits(Items.WHITE_WOOL);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
            int woolCount = 0;
            int animalCounter = 0;
            while (woolCount <= dropLimits && (long)animalCounter++ < this.animalPen$animalCount) {
                ItemStack woolStack = new ItemStack((ItemLike)itemLike, level.random.nextInt(1, 4));
                woolCount += woolStack.getCount();
                boolean added = false;
                for (ItemStack stack : itemStackList) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)woolStack, (ItemStack)stack) || stack.getCount() >= stack.getMaxStackSize()) continue;
                    stack.grow(woolStack.getCount());
                    added = true;
                    break;
                }
                if (added) continue;
                itemStackList.add(woolStack);
            }
            itemStackList.forEach(seedStack -> Block.popResource((Level)level, (BlockPos)position.above(), (ItemStack)seedStack));
            this.setSheared(true);
            level.playSound(null, position, SoundEvents.SHEEP_SHEAR, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$woolCooldown = AnimalPen.config().getEntityCooldown(this.getType(), Items.SHEARS, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return ItemStack.EMPTY;
        }
        return super.animalPen$animalPenInteract(level, itemStack, position);
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        List<Pair<ItemStack[], Component>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (shortLine && AnimalPen.config().getEntityCooldown(this.getType(), Items.SHEARS, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = this.animalPen$woolCooldown == 0 ? Component.translatable((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.full_ready"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001")}).withStyle(ChatFormatting.GREEN) : Component.translatable((String)(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.wool_cooldown"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$woolCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
        Item itemLike = this.pen$getWoolItem(this.getColor());
        lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.SHEARS.getDefaultInstance(), itemLike.asItem().getDefaultInstance()}, (Object)component));
        return lines;
    }

    @Override
    @Intrinsic
    public int animalPen$getRedStoneSignal() {
        if (this.animalPen$woolCooldown > 0) {
            return super.animalPen$getRedStoneSignal();
        }
        return super.animalPen$getRedStoneSignal() | 4;
    }

    @Unique
    public Item pen$getWoolItem(DyeColor color) {
        String colorName = color.getName();
        ResourceLocation woolId = ResourceLocation.withDefaultNamespace((String)(colorName + "_wool"));
        return (Item)BuiltInRegistries.ITEM.getValue(woolId);
    }
}

