/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.time.LocalTime;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import lv.id.bonne.animalpen.registries.AnimalPenFoodRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Turtle.class})
public abstract class AnimalPenTurtle
extends AnimalPenAnimal {
    @Unique
    private int animalPen$eggCooldown;
    @Unique
    private int animalPen$scuteCount;

    protected AnimalPenTurtle(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        this.animalPen$processScute(blockEntity.getLevel(), blockEntity.getBlockPos());
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$eggCooldown > 0) {
            --this.animalPen$eggCooldown;
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.putInt("egg_cooldown", this.animalPen$eggCooldown);
        tag.putInt("scute_count", this.animalPen$scuteCount);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$eggCooldown = tag.getIntOr("egg_cooldown", 0);
        this.animalPen$scuteCount = tag.getIntOr("scute_count", 0);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        this.animal$preProcesScute(player, hand, position);
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.BUCKET)) {
            if (this.animalPen$eggCooldown > 0) {
                AnimalPen.sendDebug("Under cooldown for " + this.animalPen$eggCooldown);
                return false;
            }
            if (player.level().isClientSide()) {
                return true;
            }
            int dropLimits = AnimalPen.config().getDropLimits(Items.TURTLE_EGG);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int eggCount = (int)Math.min(this.animalPen$animalCount, (long)dropLimits);
            while (eggCount > 0) {
                ItemStack eggStack = new ItemStack((ItemLike)Items.TURTLE_EGG);
                if (eggCount > 64) {
                    eggStack.setCount(64);
                    eggCount -= 64;
                } else {
                    eggStack.setCount(eggCount);
                    eggCount = 0;
                }
                Block.popResource((Level)player.level(), (BlockPos)position.above(), (ItemStack)eggStack);
            }
            player.level().playSound(null, position, SoundEvents.TURTLE_LAY_EGG, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$eggCooldown = AnimalPen.config().getEntityCooldown(this.getType(), Items.BUCKET, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public ItemStack animalPen$animalPenInteract(ServerLevel level, ItemStack itemStack, BlockPos position) {
        if (this.animalPen$eggCooldown > 0) {
            AnimalPen.sendDebug("Under cooldown for " + this.animalPen$eggCooldown);
            return ItemStack.EMPTY;
        }
        if (itemStack.is(Items.BUCKET)) {
            int dropLimits = AnimalPen.config().getDropLimits(Items.TURTLE_EGG);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int eggCount = (int)Math.min(this.animalPen$animalCount, (long)dropLimits);
            while (eggCount > 0) {
                ItemStack eggStack = new ItemStack((ItemLike)Items.TURTLE_EGG);
                if (eggCount > 64) {
                    eggStack.setCount(64);
                    eggCount -= 64;
                } else {
                    eggStack.setCount(eggCount);
                    eggCount = 0;
                }
                Block.popResource((Level)level, (BlockPos)position.above(), (ItemStack)eggStack);
            }
            level.playSound(null, position, SoundEvents.TURTLE_LAY_EGG, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$eggCooldown = AnimalPen.config().getEntityCooldown(this.getType(), Items.BUCKET, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return ItemStack.EMPTY;
        }
        return super.animalPen$animalPenInteract(level, itemStack, position);
    }

    @Unique
    private void animalPen$processScute(Level level, BlockPos position) {
        if (this.animalPen$scuteCount <= 0) {
            return;
        }
        if (level.isClientSide()) {
            return;
        }
        boolean dropScuteAtStart = AnimalPen.config().isDropScuteAtStart();
        if (!dropScuteAtStart && this.animalPen$foodCooldown != 0) {
            return;
        }
        int dropLimits = AnimalPen.config().getDropLimits(Items.TURTLE_SCUTE);
        if (dropLimits <= 0) {
            dropLimits = Integer.MAX_VALUE;
        }
        int scuteCount = Math.min(this.animalPen$scuteCount, dropLimits);
        while (scuteCount > 0) {
            ItemStack scuteStack = new ItemStack((ItemLike)Items.TURTLE_SCUTE);
            if (scuteCount > 64) {
                scuteStack.setCount(64);
                scuteCount -= 64;
            } else {
                scuteStack.setCount(scuteCount);
                scuteCount = 0;
            }
            Block.popResource((Level)level, (BlockPos)position.above(), (ItemStack)scuteStack);
        }
        level.playSound(null, position, SoundEvents.TURTLE_SHAMBLE_BABY, SoundSource.NEUTRAL, 1.0f, 1.0f);
        this.animalPen$scuteCount = 0;
    }

    @Unique
    private void animal$preProcesScute(Player player, InteractionHand hand, BlockPos position) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (AnimalPenFoodRegistry.isFood(this.getType().arch$registryName(), itemStack)) {
            if (this.animalPen$foodCooldown > 0) {
                return;
            }
            long maxCount = AnimalPen.config().getMaximalAnimalCount();
            if (maxCount > 0L && this.animalPen$animalCount >= maxCount) {
                return;
            }
            int stackSize = itemStack.getCount();
            if ((stackSize = (int)Math.min(this.animalPen$animalCount, (long)stackSize)) < 2) {
                return;
            }
            if (player.level().isClientSide()) {
                return;
            }
            stackSize = (int)Math.min((maxCount - this.animalPen$animalCount) * 2L, (long)stackSize);
            this.animalPen$scuteCount += stackSize / 2;
        }
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        List<Pair<ItemStack[], Component>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (shortLine && AnimalPen.config().getEntityCooldown(this.getType(), Items.BUCKET, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = this.animalPen$eggCooldown == 0 ? Component.translatable((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.full_ready"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001")}).withStyle(ChatFormatting.GREEN) : Component.translatable((String)(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.egg_cooldown"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$eggCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
        lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.BUCKET.getDefaultInstance(), Items.TURTLE_EGG.getDefaultInstance()}, (Object)component));
        return lines;
    }

    @Override
    @Intrinsic
    public int animalPen$getRedStoneSignal() {
        if (this.animalPen$eggCooldown > 0) {
            return super.animalPen$getRedStoneSignal();
        }
        return super.animalPen$getRedStoneSignal() | 4;
    }
}

