/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.client;

import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import java.util.function.Supplier;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import lv.id.bonne.animalpen.blocks.renderer.AnimalPenRenderer;
import lv.id.bonne.animalpen.blocks.renderer.AquariumRenderer;
import lv.id.bonne.animalpen.client.WaterTankColor;
import lv.id.bonne.animalpen.client.screens.VariantScreenSelection;
import lv.id.bonne.animalpen.registries.AnimalPenBlockRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class AnimalPenClient {
    public static void init() {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)AnimalPenTileEntityRegistry.ANIMAL_PEN_TILE_ENTITY.get()), context -> new AnimalPenRenderer());
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)AnimalPenTileEntityRegistry.AQUARIUM_TILE_ENTITY.get()), context -> new AquariumRenderer());
        RenderTypeRegistry.register((RenderType)RenderType.translucent(), (Block[])new Block[]{(Block)AnimalPenBlockRegistry.AQUARIUM.get()});
        ColorHandlerRegistry.registerBlockColors((BlockColor)new WaterTankColor(), (Supplier[])new Supplier[]{AnimalPenBlockRegistry.AQUARIUM});
        InteractionEvent.RIGHT_CLICK_BLOCK.register((player, interactionHand, blockPos, direction) -> {
            BlockEntity patt0$temp = player.level().getBlockEntity(blockPos);
            if (!(patt0$temp instanceof AnimalPenBlockInterface)) {
                return InteractionResult.PASS;
            }
            AnimalPenBlockInterface blockEntity = (AnimalPenBlockInterface)patt0$temp;
            if (!player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() || player.isCrouching()) {
                return InteractionResult.PASS;
            }
            if (blockEntity.getStoredAnimal() == null) {
                return InteractionResult.PASS;
            }
            Minecraft.getInstance().execute(() -> Minecraft.getInstance().setScreen((Screen)new VariantScreenSelection(blockPos)));
            return InteractionResult.SUCCESS;
        });
    }
}

