/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.wateranimal;

import java.time.LocalTime;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={WaterAnimal.class})
@Implements(value={@Interface(iface=AnimalPenInterface.class, prefix="animalPen$", unique=true)})
public abstract class AnimalPenWaterAnimal
extends Mob {
    @Unique
    protected int animalPen$foodCooldown = 0;
    @Unique
    protected long animalPen$animalCount = 0L;

    protected AnimalPenWaterAnimal(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        this.animalPen$animalPenSaveTag(compoundTag);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.animalPen$animalPenLoadTag(compoundTag);
    }

    @Intrinsic
    public boolean animalPen$animalPenUpdateCount(long change) {
        if (change < 0L && this.animalPen$animalCount + change < 0L) {
            return false;
        }
        long maxCount = AnimalPen.CONFIG_MANAGER.getConfiguration().getMaximalAnimalCount();
        if (maxCount > 0L && this.animalPen$animalCount + change > maxCount) {
            return false;
        }
        this.animalPen$animalCount += change;
        return true;
    }

    @Intrinsic
    public long animalPen$animalPenGetCount() {
        return this.animalPen$animalCount;
    }

    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        if (this.animalPen$foodCooldown > 0) {
            --this.animalPen$foodCooldown;
            return true;
        }
        return false;
    }

    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        tag.putInt("food_cooldown", this.animalPen$foodCooldown);
        tag.putLong("animal_count", this.animalPen$animalCount);
    }

    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        this.animalPen$foodCooldown = tag.getInt("food_cooldown");
        this.animalPen$animalCount = tag.getLong("animal_count");
    }

    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.animal$isFood(itemStack)) {
            if (this.animalPen$foodCooldown > 0) {
                return false;
            }
            long maxCount = AnimalPen.CONFIG_MANAGER.getConfiguration().getMaximalAnimalCount();
            if (maxCount > 0L && this.animalPen$animalCount >= maxCount) {
                return false;
            }
            int stackSize = itemStack.getCount();
            if ((stackSize = (int)Math.min(this.animalPen$animalCount, (long)stackSize)) < 2) {
                return false;
            }
            if (player.level().isClientSide()) {
                return true;
            }
            stackSize = (int)Math.min((maxCount - this.animalPen$animalCount) * 2L, (long)stackSize);
            if (!player.getAbilities().instabuild) {
                if (stackSize % 2 == 1) {
                    itemStack.shrink(stackSize - 1);
                    player.setItemInHand(hand, itemStack);
                } else {
                    itemStack.shrink(stackSize);
                    player.setItemInHand(hand, itemStack);
                }
            }
            this.animalPen$animalCount += (long)(stackSize / 2);
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, (double)((float)position.getX() + 0.5f), (double)position.getY() + 1.5, (double)((float)position.getZ() + 0.5f), 5, 0.2, 0.2, 0.2, 0.05);
            }
            player.level().playSound(null, position, (SoundEvent)SoundEvents.GENERIC_EAT.value(), SoundSource.NEUTRAL, 1.0f, Mth.randomBetween((RandomSource)player.level().random, (float)0.8f, (float)1.2f));
            SoundEvent soundEvent = this.getAmbientSound();
            if (soundEvent != null) {
                player.level().playSound(null, position, soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            this.animalPen$foodCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.APPLE, stackSize);
            return true;
        }
        return false;
    }

    @Intrinsic
    public List<Pair<ItemStack, Component>> animalPen$animalPenGetLines(int tick) {
        ItemStack foodItem;
        LinkedList<Pair<ItemStack, Component>> lines = new LinkedList<Pair<ItemStack, Component>>();
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.APPLE, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = this.animalPen$foodCooldown == 0 ? Component.translatable((String)"display.animal_pen.food_ready").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"display.animal_pen.food_cooldown", (Object[])new Object[]{LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$foodCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
        List<ItemStack> food = this.animalPen$getFood();
        if (food.isEmpty()) {
            return lines;
        }
        if (food.size() == 1) {
            foodItem = food.get(0);
        } else {
            int size = food.size();
            int index = tick / 100 % size;
            foodItem = food.get(index);
        }
        lines.add((Pair<ItemStack, Component>)Pair.of((Object)foodItem, (Object)component));
        return lines;
    }

    @Unique
    public boolean animal$isFood(ItemStack itemStack) {
        return false;
    }

    @Intrinsic
    public List<ItemStack> animalPen$getFood() {
        return Collections.emptyList();
    }
}

