/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.entities;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.AquariumBlock;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.items.AnimalContainerItem;
import lv.id.bonne.animalpen.network.packets.UpdateVariantScreenData;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AquariumTileEntity
extends BlockEntity
implements AnimalPenBlockInterface<WaterAnimal> {
    private final SimpleContainer inventory = new SimpleContainer(1){

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return stack.is((Item)AnimalPensItemRegistry.ANIMAL_CONTAINER.get());
        }

        public void setChanged() {
            super.setChanged();
            AquariumTileEntity.this.triggerUpdate();
        }
    };
    private WaterAnimal storedAnimal;
    private long displaySize = -1L;
    private UUID ownerUUID;
    private long protectedAmount = 0L;
    private int tickCounter;
    private final List<Integer> deathTicker = new ArrayList<Integer>();
    public static final String TAG_INVENTORY = "inventory";
    public static final String TAG_DEATH_TICKER = "death_ticker";
    public static final String TAG_DISPLAY_SIZE = "display_size";
    public static final String TAG_OWNER_UUID = "owner_uuid";
    public static final String TAG_KEEP_AMOUNT = "keep_amount";

    public AquariumTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)AnimalPenTileEntityRegistry.AQUARIUM_TILE_ENTITY.get(), blockPos, blockState);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        CompoundTag inventory = ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), (NonNullList)this.getInventory().getItems(), (HolderLookup.Provider)provider);
        tag.put(TAG_INVENTORY, (Tag)inventory);
        tag.put(TAG_DEATH_TICKER, (Tag)new IntArrayTag(this.deathTicker));
        tag.putLong(TAG_DISPLAY_SIZE, this.displaySize);
        this.getOwner().ifPresent(owner -> tag.putUUID(TAG_OWNER_UUID, owner));
        tag.putLong(TAG_KEEP_AMOUNT, this.protectedAmount);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory.clearContent();
        this.deathTicker.clear();
        this.storedAnimal = null;
        this.ownerUUID = null;
        if (tag.contains(TAG_INVENTORY, 9)) {
            ListTag list = tag.getList(TAG_INVENTORY, 10);
            int i = 0;
            while (i < list.size()) {
                CompoundTag itemWithTag = list.getCompound(i);
                Dynamic dynamic = new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)itemWithTag);
                dynamic = DataFixers.getDataFixer().update(References.ITEM_STACK, dynamic, 3817, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                int index = i++;
                ItemStack.parse((HolderLookup.Provider)provider, (Tag)((Tag)dynamic.getValue())).ifPresent(item -> {
                    if (index < this.getInventory().getContainerSize()) {
                        this.inventory.setItem(index, item);
                    }
                });
            }
        }
        if (tag.contains(TAG_INVENTORY, 10)) {
            ContainerHelper.loadAllItems((CompoundTag)tag.getCompound(TAG_INVENTORY), (NonNullList)this.inventory.getItems(), (HolderLookup.Provider)provider);
        }
        if (tag.contains(TAG_DEATH_TICKER, 11)) {
            int[] intArray;
            for (int i : intArray = tag.getIntArray(TAG_DEATH_TICKER)) {
                this.deathTicker.add(i);
            }
        }
        this.displaySize = tag.contains(TAG_DISPLAY_SIZE, 4) ? tag.getLong(TAG_DISPLAY_SIZE) : -1L;
        if (tag.contains(TAG_OWNER_UUID)) {
            this.ownerUUID = tag.getUUID(TAG_OWNER_UUID);
        }
        this.protectedAmount = tag.getLong(TAG_KEEP_AMOUNT);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public Optional<WaterAnimal> getStoredAnimal() {
        if (this.storedAnimal == null && !this.getItemStack().isEmpty()) {
            CustomData customData = (CustomData)this.getItemStack().get(DataComponents.ENTITY_DATA);
            if (customData == null) {
                return Optional.ofNullable(this.storedAnimal);
            }
            CompoundTag tag = customData.copyTag();
            if (!tag.contains("id") || this.level == null) {
                return Optional.ofNullable(this.storedAnimal);
            }
            EntityType.create((CompoundTag)tag, (Level)this.level).map(entity -> (WaterAnimal)entity).ifPresent(animal -> {
                this.storedAnimal = animal;
            });
        } else if (this.storedAnimal != null && this.getItemStack().isEmpty()) {
            this.storedAnimal = null;
        }
        return Optional.ofNullable(this.storedAnimal);
    }

    public List<Integer> getDeathTicker() {
        return this.deathTicker;
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void tick() {
        ++this.tickCounter;
        if (this.getLevel() == null || this.getLevel().isClientSide()) {
            return;
        }
        boolean updated = this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).animalPenTick(this)).orElse(false);
        for (int i = 0; i < this.deathTicker.size(); ++i) {
            this.deathTicker.set(i, this.deathTicker.get(i) + 1);
            updated = true;
        }
        this.deathTicker.removeIf(integer -> integer > 20);
        if (updated) {
            this.triggerUpdate();
        }
    }

    public boolean processContainer(Player player, InteractionHand interactionHand) {
        if (this.getOwner().isPresent() && !this.getOwner().get().equals(player.getUUID())) {
            AnimalPen.sendDebug("Protection is enabled");
            return false;
        }
        if (this.inventory.isEmpty()) {
            ItemStack itemInHand = player.getItemInHand(interactionHand);
            if (!itemInHand.has(DataComponents.ENTITY_DATA)) {
                return false;
            }
            if (!player.level().isClientSide()) {
                this.inventory.addItem(itemInHand);
                player.setItemInHand(interactionHand, ItemStack.EMPTY);
                if (this.level != null && !this.level.isClientSide()) {
                    NetworkManager.sendToPlayers(((ServerLevel)this.level).players().stream().filter(other -> other.distanceToSqr((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()) < 50.0).toList(), (CustomPacketPayload)new UpdateVariantScreenData(this.getBlockPos()));
                }
                AnimalPen.sendDebug("Deposit animal cage into pen");
            }
            return true;
        }
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (!itemInHand.has(DataComponents.ENTITY_DATA)) {
            if (!player.isCrouching()) {
                return false;
            }
            if (player.level().isClientSide()) {
                return true;
            }
            WaterAnimal animal = this.getStoredAnimal().orElse(null);
            if (animal == null) {
                return false;
            }
            long currentCount = ((AnimalPenInterface)animal).animalPenGetCount();
            if (currentCount < 2L) {
                AnimalPen.sendDebug("Cannot split 1");
                return false;
            }
            long newCount = Math.min(currentCount - this.protectedAmount, currentCount / 2L);
            if (newCount <= 0L) {
                AnimalPen.sendDebug("Protected amount prevents from splitting");
                return false;
            }
            if (!((AnimalPenInterface)animal).animalPenUpdateCount(-newCount)) {
                AnimalPen.sendDebug("Fail to reduce animal count");
                return false;
            }
            CompoundTag tag = new CompoundTag();
            animal.save(tag);
            tag.putLong("animal_count", newCount);
            itemInHand.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            player.setItemInHand(interactionHand, itemInHand);
            this.inventory.setChanged();
            AnimalPen.sendDebug("Half the amount of animals in pen");
            return true;
        }
        WaterAnimal animal = this.getStoredAnimal().orElse(null);
        CompoundTag itemInHandTag = ((CustomData)itemInHand.get(DataComponents.ENTITY_DATA)).copyTag();
        if (animal == null || !itemInHandTag.getString("id").equals(animal.getType().arch$registryName().toString())) {
            AnimalPen.sendDebug("Different animals");
            return false;
        }
        if (player.level().isClientSide()) {
            return true;
        }
        long newCount = itemInHandTag.getLong("animal_count");
        if (newCount <= 0L || !((AnimalPenInterface)animal).animalPenUpdateCount(newCount)) {
            AnimalPen.sendDebug("Failed to deposit animal");
            return false;
        }
        if (newCount > 1L && !AnimalContainerItem.canMergeAnimalVariants(this.getItemStack(), itemInHand, player)) {
            AnimalPen.sendDebug("Variants could not be merged");
            ((AnimalPenInterface)animal).animalPenUpdateCount(-1L);
            itemInHandTag.putLong("animal_count", 1L);
            itemInHand.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)itemInHandTag));
        } else {
            AnimalContainerItem.mergeAnimalVariants(this.getItemStack(), itemInHand, player);
            itemInHand.remove(DataComponents.ENTITY_DATA);
            itemInHand.remove((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
            if (this.level != null && !this.level.isClientSide()) {
                NetworkManager.sendToPlayers(((ServerLevel)this.level).players().stream().filter(other -> other.distanceToSqr((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()) < 50.0).toList(), (CustomPacketPayload)new UpdateVariantScreenData(this.getBlockPos()));
            }
        }
        player.setItemInHand(interactionHand, itemInHand);
        this.inventory.setChanged();
        AnimalPen.sendDebug("Cage merged into pen");
        return true;
    }

    public boolean interactWithPen(Player player, InteractionHand interactionHand) {
        if (this.getOwner().isPresent() && !this.getOwner().get().equals(player.getUUID())) {
            AnimalPen.sendDebug("Protection is enabled");
            return false;
        }
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (itemInHand.isEmpty() && !this.inventory.isEmpty()) {
            if (player.isCrouching() && !player.level().isClientSide()) {
                ItemStack item = this.getItemStack();
                player.setItemInHand(interactionHand, item);
                this.inventory.setItem(0, ItemStack.EMPTY);
                this.inventory.setChanged();
                AnimalPen.sendDebug("Taking out animal cage");
            }
            return true;
        }
        WaterAnimal animal = this.getStoredAnimal().orElse(null);
        if (animal == null) {
            AnimalPen.sendDebug("Animal is not set");
            return false;
        }
        if (((AnimalPenInterface)animal).animalPenInteract(player, interactionHand, this.getBlockPos())) {
            AnimalPen.sendDebug("Animal Interaction finished");
            ItemStack item = this.getItemStack();
            CompoundTag tag = new CompoundTag();
            animal.save(tag);
            item.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            this.inventory.setChanged();
            return true;
        }
        return false;
    }

    public void attackThePen(Player player, Level level) {
        if (this.getOwner().isPresent() && !this.getOwner().get().equals(player.getUUID())) {
            AnimalPen.sendDebug("Protection is enabled");
            return;
        }
        ItemStack weapon = player.getItemInHand(InteractionHand.MAIN_HAND);
        WaterAnimal animal = this.getStoredAnimal().orElse(null);
        if (animal == null) {
            AnimalPen.sendDebug("Animal Pen is empty");
            return;
        }
        long amount = ((AnimalPenInterface)animal).animalPenGetCount();
        if (amount <= this.protectedAmount) {
            AnimalPen.sendDebug("Protected amount reached");
            return;
        }
        if (!((AnimalPenInterface)animal).animalPenUpdateCount(-1L)) {
            AnimalPen.sendDebug("Failed to update animal count");
            return;
        }
        EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)((ServerLevel)level), (Entity)animal, (DamageSource)level.damageSources().playerAttack(player), (ItemStack)weapon);
        if (AnimalPen.config().isIncreaseStatistics()) {
            player.awardStat(Stats.ITEM_USED.get((Object)weapon.getItem()));
        }
        weapon.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        this.deathTicker.add(0);
        if (((AnimalPenInterface)animal).animalPenGetCount() <= 0L) {
            ItemStack item = this.getItemStack();
            item.remove(DataComponents.ENTITY_DATA);
            item.remove((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
            Block.popResource((Level)level, (BlockPos)this.getBlockPos().above(), (ItemStack)item);
            this.inventory.setItem(0, ItemStack.EMPTY);
            AnimalPen.sendDebug("Dropping empty cage");
        }
        this.triggerUpdate();
        Vec3 position = new Vec3((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ());
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(animal.getLootTable());
        LootParams.Builder paramsBuilder = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)position).withParameter(LootContextParams.THIS_ENTITY, (Object)animal).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)level.damageSources().playerAttack(player)).withLuck(player.getLuck());
        lootTable.getRandomItems(paramsBuilder.create(LootContextParamSets.ENTITY), level.getRandom().nextLong()).forEach(itemStack -> Block.popResource((Level)level, (BlockPos)this.getBlockPos().above(), (ItemStack)itemStack));
        animal.clearFire();
        int reward = animal.getExperienceReward((ServerLevel)level, (Entity)player);
        ExperienceOrb.award((ServerLevel)((ServerLevel)this.level), (Vec3)position.add(0.5, 1.5, 0.5), (int)reward);
        if (AnimalPen.config().isTriggerAdvancements()) {
            CriteriaTriggers.PLAYER_KILLED_ENTITY.trigger((ServerPlayer)player, (Entity)animal, level.damageSources().playerAttack(player));
        }
        if (AnimalPen.config().isIncreaseStatistics()) {
            player.awardStat(Stats.MOB_KILLS);
            player.awardStat(Stats.ENTITY_KILLED.get((Object)animal.getType()));
        }
        AnimalPen.sendDebug("Animal Kill process finished");
    }

    public int getRedStoneSignal() {
        return this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).getRedStoneSignal()).orElse(0);
    }

    @Override
    public void triggerUpdate() {
        this.setChanged();
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        this.getStoredAnimal().ifPresent(animal -> {
            CompoundTag tag = new CompoundTag();
            animal.save(tag);
            this.getItemStack().set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
        });
        BlockState oldState = this.getBlockState();
        BlockState newState = this.getBlockState();
        if (((Boolean)oldState.getValue((Property)AquariumBlock.FILLED)).booleanValue() == this.inventory.isEmpty()) {
            newState = (BlockState)oldState.setValue((Property)AquariumBlock.FILLED, (Comparable)Boolean.valueOf(!this.inventory.isEmpty()));
            this.level.setBlock(this.getBlockPos(), newState, 2);
            this.setChanged();
        }
        this.level.sendBlockUpdated(this.getBlockPos(), oldState, newState, 2);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    private ItemStack getItemStack() {
        return this.inventory.getItem(0);
    }

    @Override
    public ListTag getEntityVariants() {
        return this.getStoredAnimal().map(animal -> AnimalContainerItem.getAnimalVariants(this.getItemStack()).orElseGet(ListTag::new)).orElseGet(ListTag::new);
    }

    @Override
    public long getAnimalDisplaySize() {
        return this.displaySize < 1L ? this.getAnimalCount() : Math.min(this.displaySize, this.getAnimalCount());
    }

    @Override
    public void setAnimalDisplaySize(long size) {
        this.displaySize = size;
        this.triggerUpdate();
    }

    @Override
    public void updateAnimalVariant(CompoundTag animalVariant) {
        if (animalVariant == null || animalVariant.isEmpty()) {
            return;
        }
        this.getStoredAnimal().ifPresent(animal -> {
            AnimalPen.sendDebug("Animal Variant changed");
            CompoundTag extraData = new CompoundTag();
            ((AnimalPenInterface)animal).animalPenSaveTag(extraData);
            animal.load(animalVariant);
            ((AnimalPenInterface)animal).animalPenLoadTag(extraData);
            this.triggerUpdate();
            if (this.level != null && !this.level.isClientSide()) {
                NetworkManager.sendToPlayers(((ServerLevel)this.level).players().stream().filter(other -> other.distanceToSqr((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()) < 50.0).toList(), (CustomPacketPayload)new UpdateVariantScreenData(this.getBlockPos()));
            }
        });
    }

    @Override
    public void removeAnimalVariant(int index) {
        if (this.getStoredAnimal().isEmpty() || this.getEntityVariants().size() <= index) {
            return;
        }
        CustomData customData = (CustomData)this.getItemStack().get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        if (customData == null) {
            return;
        }
        this.getItemStack().set((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get(), (Object)customData.update(tag -> {
            ListTag list = tag.getList("animal_variants", 10);
            list.remove(index);
        }));
        this.inventory.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            NetworkManager.sendToPlayers(((ServerLevel)this.level).players().stream().filter(other -> other.distanceToSqr((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()) < 50.0).toList(), (CustomPacketPayload)new UpdateVariantScreenData(this.getBlockPos()));
            AnimalPen.sendDebug("Animal variant removed");
        }
    }

    @Override
    public long getAnimalCount() {
        return this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).animalPenGetCount()).orElse(0L);
    }

    @Override
    public boolean canGrowEntity() {
        return AnimalPen.config().isGrowWaterAnimals();
    }

    @Override
    public List<Pair<ItemStack[], Component>> getCooldownLines(boolean shortText) {
        return this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).animalPenGetLines(this.getTickCounter(), shortText)).orElse(Collections.emptyList());
    }

    @Override
    public long getProtectedAmount() {
        return this.protectedAmount;
    }

    @Override
    public void setProtectedAmount(long amount) {
        this.protectedAmount = amount;
        this.triggerUpdate();
    }

    @Override
    public Optional<UUID> getOwner() {
        return Optional.ofNullable(this.ownerUUID);
    }

    @Override
    public void setOwner(@Nullable UUID owner) {
        this.ownerUUID = owner;
        this.triggerUpdate();
    }
}

