/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import lv.id.bonne.animalpen.registries.AnimalPenTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Sheep.class})
public abstract class AnimalPenSheep
extends AnimalPenAnimal {
    @Shadow
    @Final
    private static Map<DyeColor, ItemLike> ITEM_BY_DYE;
    @Unique
    private int animalPen$woolCooldown;
    @Unique
    private static final List<ItemStack> animal_pen$DYE;

    protected AnimalPenSheep(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract DyeColor getColor();

    @Shadow
    public abstract void setColor(DyeColor var1);

    @Shadow
    public abstract void setSheared(boolean var1);

    @Shadow
    public abstract boolean isSheared();

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$woolCooldown > 0) {
            --this.animalPen$woolCooldown;
            return true;
        }
        if (this.isSheared()) {
            this.setSheared(false);
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.putInt("wool_cooldown", this.animalPen$woolCooldown);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$woolCooldown = tag.getInt("wool_cooldown");
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.SHEARS) || itemStack.is(AnimalPenTags.COMMON_SHEARS)) {
            if (this.animalPen$woolCooldown > 0) {
                AnimalPen.sendDebug("Under cooldown for " + this.animalPen$woolCooldown);
                return false;
            }
            if (player.level().isClientSide()) {
                return true;
            }
            this.setSheared(true);
            AnimalPenInterface.triggerItemUse((Entity)this, (ServerPlayer)player, itemStack, 1);
            itemStack.hurtAndBreak(1, (LivingEntity)player, AnimalPenSheep.getSlotForHand((InteractionHand)hand));
            ItemLike itemLike = ITEM_BY_DYE.get(this.getColor());
            int woolCount = 1;
            int dropLimits = AnimalPen.config().getDropLimits(Items.WHITE_WOOL);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int i = 0;
            while ((long)i < this.animalPen$animalCount && woolCount < dropLimits) {
                woolCount += player.level().getRandom().nextInt(3);
                ++i;
            }
            while (woolCount > 0) {
                ItemStack woolStack = new ItemStack(itemLike);
                if (woolCount > 64) {
                    woolStack.setCount(64);
                    woolCount -= 64;
                } else {
                    woolStack.setCount(woolCount);
                    woolCount = 0;
                }
                Block.popResource((Level)player.level(), (BlockPos)position.above(), (ItemStack)woolStack);
            }
            player.level().playSound(null, position, SoundEvents.SHEEP_SHEAR, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$woolCooldown = AnimalPen.config().getEntityCooldown(this.getType(), Items.SHEARS, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return true;
        }
        Item item = itemStack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            if (player.level().isClientSide()) {
                return true;
            }
            this.setColor(dye.getDyeColor());
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
                player.setItemInHand(hand, itemStack);
            }
            player.level().playSound(null, position, SoundEvents.DYE_USE, SoundSource.NEUTRAL, 1.0f, 1.0f);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public ItemStack animalPen$animalPenInteract(ServerLevel level, ItemStack itemStack, BlockPos position) {
        if (itemStack.is(Items.SHEARS) || itemStack.is(AnimalPenTags.COMMON_SHEARS)) {
            if (this.animalPen$woolCooldown > 0) {
                AnimalPen.sendDebug("Under cooldown for " + this.animalPen$woolCooldown);
                return ItemStack.EMPTY;
            }
            this.setSheared(true);
            itemStack.hurtAndBreak(1, level, null, item -> {});
            ItemLike itemLike = ITEM_BY_DYE.get(this.getColor());
            int woolCount = 1;
            int dropLimits = AnimalPen.config().getDropLimits(Items.WHITE_WOOL);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int i = 0;
            while ((long)i < this.animalPen$animalCount && woolCount < dropLimits) {
                woolCount += level.getRandom().nextInt(3);
                ++i;
            }
            while (woolCount > 0) {
                ItemStack woolStack = new ItemStack(itemLike);
                if (woolCount > 64) {
                    woolStack.setCount(64);
                    woolCount -= 64;
                } else {
                    woolStack.setCount(woolCount);
                    woolCount = 0;
                }
                Block.popResource((Level)level, (BlockPos)position.above(), (ItemStack)woolStack);
            }
            level.playSound(null, position, SoundEvents.SHEEP_SHEAR, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$woolCooldown = AnimalPen.config().getEntityCooldown(this.getType(), Items.SHEARS, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return ItemStack.EMPTY;
        }
        return super.animalPen$animalPenInteract(level, itemStack, position);
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        ItemStack dyeItem;
        List<Pair<ItemStack[], Component>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (!AnimalPen.config().isShowAllInteractions() && shortLine && AnimalPen.config().getEntityCooldown(this.getType(), Items.SHEARS, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = this.animalPen$woolCooldown == 0 ? Component.translatable((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.full_ready"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001")}).withStyle(ChatFormatting.GREEN) : Component.translatable((String)(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.wool_cooldown"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$woolCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
        ItemLike itemLike = ITEM_BY_DYE.get(this.getColor());
        lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.SHEARS.getDefaultInstance(), itemLike.asItem().getDefaultInstance()}, (Object)component));
        if (!AnimalPen.config().isShowAllInteractions() && shortLine) {
            return lines;
        }
        MutableComponent text = Component.translatable((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.color_ready"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001")}).withStyle(ChatFormatting.GREEN);
        if (animal_pen$DYE.isEmpty()) {
            return lines;
        }
        if (animal_pen$DYE.size() == 1) {
            dyeItem = animal_pen$DYE.get(0);
        } else {
            int size = animal_pen$DYE.size();
            int index = tick / 100 % size;
            dyeItem = animal_pen$DYE.get(index);
        }
        ItemStack woolItem = ITEM_BY_DYE.get(((DyeItem)dyeItem.getItem()).getDyeColor()).asItem().getDefaultInstance();
        lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{dyeItem, woolItem}, (Object)text));
        return lines;
    }

    @Override
    @Intrinsic
    public int animalPen$getRedStoneSignal() {
        if (this.animalPen$woolCooldown > 0) {
            return super.animalPen$getRedStoneSignal();
        }
        return super.animalPen$getRedStoneSignal() | 4;
    }

    static {
        animal_pen$DYE = BuiltInRegistries.ITEM.stream().filter(item -> item instanceof DyeItem).map(Item::getDefaultInstance).toList();
    }
}

