/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.platform.Platform;
import java.util.Map;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.registries.AnimalPenFoodRegistry;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class AnimalFoodReloadListener
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).create();
    private static final String FOLDER = "animal_foods";

    public AnimalFoodReloadListener() {
        super(GSON, FOLDER);
    }

    protected void apply(Map<class_2960, JsonElement> jsonMap, class_3300 resourceManager, class_3695 profiler) {
        AnimalPenFoodRegistry.clear();
        for (Map.Entry<class_2960, JsonElement> entry : jsonMap.entrySet()) {
            class_2960 id = entry.getKey();
            try {
                class_1856 ingredient;
                String modId;
                JsonPrimitive primitive;
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) {
                    AnimalPen.LOGGER.error("Invalid JSON format for " + String.valueOf(id) + ": Expected a JSON object.");
                    continue;
                }
                JsonObject json = element.getAsJsonObject();
                if (json.has("condition") && json.get("condition").isJsonPrimitive() && (primitive = json.getAsJsonPrimitive("condition")).isString() && primitive.getAsString().startsWith("mod:") && !(modId = primitive.getAsString().substring(4)).isBlank() && !Platform.isModLoaded((String)modId)) continue;
                JsonArray ingredientsArray = json.has("food_items") && json.get("food_items").isJsonArray() ? json.getAsJsonArray("food_items") : new JsonArray();
                try {
                    ingredient = (class_1856)class_1856.field_46095.parse((DynamicOps)JsonOps.INSTANCE, (Object)ingredientsArray).getOrThrow(text -> {
                        AnimalPen.LOGGER.error("Error parsing ingredient in " + String.valueOf(id) + ": " + text);
                        return new IllegalArgumentException((String)text);
                    });
                }
                catch (Exception e) {
                    continue;
                }
                AnimalPenFoodRegistry.AnimalFoodData data = new AnimalPenFoodRegistry.AnimalFoodData(ingredient);
                AnimalPenFoodRegistry.register(id, data);
            }
            catch (JsonSyntaxException e) {
                AnimalPen.LOGGER.error("JSON syntax error in " + String.valueOf(id) + ": " + e.getMessage());
            }
            catch (Exception e) {
                AnimalPen.LOGGER.error("Error processing file " + String.valueOf(id) + ": " + e.getMessage());
            }
        }
        AnimalPen.LOGGER.info("Loaded " + AnimalPenFoodRegistry.getAll().size() + " animal food entries.");
    }
}

