/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import lv.id.bonne.animalpen.client.screens.VariantsConfigScreen;
import lv.id.bonne.animalpen.mixin.accessors.EntityAccessor;
import lv.id.bonne.animalpen.network.packets.RemoveDisplayAnimalData;
import lv.id.bonne.animalpen.network.packets.UpdateDisplayAnimalData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class VariantScreenSelection
extends Screen {
    private final BlockPos position;
    private final int imageWidth;
    private final int cooldownWidth;
    private final int imageHeight;
    private final List<Button> buttons = new ArrayList<Button>();
    private final int buttonAreaHeight = 106;
    private final int sliderAreaWidth = 64;
    protected AnimalPenBlockInterface<?> blockEntityInterface;
    private int leftPos;
    private int topPos;
    private int bodyTopPos;
    private int sliderBarPos;
    private float currentVariantScroll;
    private boolean isScrollingVariants;
    private boolean isCooldownOpened;
    private int selectedButton = -1;
    private Button deleteButton;
    private Button applyButton;
    private Button configureButton;
    private Button cooldownButton;
    private LivingEntity displayEntity;
    private float entityScale;
    private float entityOffset;
    private float entityRotation = -45.0f;
    private int currentXOnEntity;
    private boolean isSelectingEntity;
    private int needsUpdate;
    private static final Component TITLE = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen");
    private static final Component APPLY = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.apply_tooltip");
    private static final Component DELETE = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.delete_tooltip");
    private static final Component SELECT_TO_DELETE = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.select_to_delete_tooltip");
    private static final Component COOLDOWN_OPEN = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.cooldown_open_tooltip");
    private static final Component COOLDOWN_CLOSE = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.cooldown_close_tooltip");
    private static final Component CONFIGURE = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.configure_tooltip");
    private static final String BUTTON_TEXT = "gui.animal_pen.variant_selection_screen.select_variant";
    private static final String FIXED_TEXT = "gui.animal_pen.variant_selection_screen.fixed_size";
    private static final ResourceLocation TEXTURE = new ResourceLocation("animal_pen", "textures/gui/animal_selection.png");
    private static final ResourceLocation COOLDOWN_TEXTURE = new ResourceLocation("animal_pen", "textures/gui/cooldown_area.png");

    public VariantScreenSelection(BlockPos position) {
        super(TITLE);
        this.position = position;
        this.imageWidth = 176;
        this.imageHeight = 136;
        this.cooldownWidth = 149;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.leftPos = this.isCooldownOpened ? (this.f_96543_ - this.imageWidth + this.cooldownWidth) / 2 : (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.buttons.clear();
        this.bodyTopPos = this.topPos + 18;
        int buttonPos = this.leftPos + 24;
        int buttonWidth = 46;
        int buttonHeight = 20;
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        BlockEntity blockEntity = this.f_96541_.f_91073_.m_7702_(this.position);
        if (!(blockEntity instanceof AnimalPenBlockInterface)) {
            return;
        }
        AnimalPenBlockInterface animalPenEntity = (AnimalPenBlockInterface)blockEntity;
        this.blockEntityInterface = animalPenEntity;
        ListTag entityList = this.blockEntityInterface.getEntityVariants();
        if (entityList == null) {
            entityList = new ListTag();
        }
        int i = 0;
        while (i < entityList.size()) {
            int y = this.bodyTopPos + i * buttonHeight;
            int index = i++;
            this.buttons.add((Button)this.m_7787_((GuiEventListener)new Button(buttonPos, y, buttonWidth, buttonHeight, (Component)Component.m_237110_((String)BUTTON_TEXT, (Object[])new Object[]{index + 1}), button -> this.handleVariantButton(button, index))));
        }
        this.deleteButton = (Button)this.m_7787_((GuiEventListener)new Button(this.leftPos + 157, this.topPos + 111, 11, 14, (Component)Component.m_237119_(), this::handleDeleteButton));
        this.deleteButton.f_93623_ = this.blockEntityInterface.getOwner().map(uuid -> uuid.equals(this.f_96541_.f_91074_.m_20148_())).orElse(true);
        this.applyButton = (Button)this.m_7787_((GuiEventListener)new Button(this.leftPos + 73, this.topPos + 111, 14, 14, (Component)Component.m_237119_(), this::handleApplyButton));
        this.applyButton.f_93623_ = false;
        this.sliderBarPos = this.leftPos + 89;
        this.configureButton = (Button)this.m_7787_((GuiEventListener)new Button(this.leftPos + 160, this.topPos + 5, 10, 10, (Component)Component.m_237119_(), this::handleConfigureButton));
        CompoundTag defaultAnimal = new CompoundTag();
        this.blockEntityInterface.getStoredAnimal().ifPresent(entity -> entity.m_20223_(defaultAnimal));
        EntityType.m_20642_((CompoundTag)defaultAnimal, (Level)this.f_96541_.f_91073_).map(entity -> (LivingEntity)entity).ifPresent(entity -> {
            this.displayEntity = entity;
            float width = this.displayEntity.m_20205_();
            float height = this.displayEntity.m_20206_();
            float entitySize = Math.max(1.0f, Math.max(width, height));
            this.entityScale = 60.0f / entitySize * 0.8f;
            this.entityOffset = Math.max(height, entitySize) * 0.5f;
        });
        this.cooldownButton = (Button)this.m_7787_((GuiEventListener)new Button(this.leftPos - 12, this.topPos + (this.imageHeight - 18) / 2, 11, 18, (Component)Component.m_237119_(), this::handleCooldownButton));
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public void update() {
        this.needsUpdate = 5;
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.displayEntity != null) {
            ++this.displayEntity.f_19797_;
        }
        if (!(this.f_96541_.f_91073_.m_7702_(this.position) instanceof AnimalPenBlockInterface) || this.blockEntityInterface.getStoredAnimal().isEmpty()) {
            this.f_96541_.m_91152_(null);
            return;
        }
        if (this.needsUpdate > 0 && --this.needsUpdate == 0) {
            this.m_7856_();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        this.updateButtonPositions();
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        float f = (float)(this.leftPos + 88) - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f;
        float f2 = this.topPos + 3 + 7;
        Objects.requireNonNull(this.f_96547_);
        this.f_96547_.m_92889_(poseStack, this.f_96539_, f, f2 - 9.0f / 2.0f, 0x404040);
        this.renderVariantButtons(poseStack, mouseX, mouseY, partialTicks);
        this.renderOtherButtons(poseStack, mouseX, mouseY);
        this.renderScrollBar(poseStack, mouseX, mouseY);
        this.renderTextBar(poseStack, mouseX, mouseY, partialTicks);
        this.renderEntity(poseStack, partialTicks);
        this.renderCooldown(poseStack, mouseX, mouseY, partialTicks);
        this.renderTooltips(poseStack, mouseX, mouseY, partialTicks);
    }

    public void m_7333_(PoseStack poseStack) {
        super.m_7333_(poseStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int offsetX = this.leftPos;
        int offsetY = this.topPos;
        this.m_93228_(poseStack, offsetX, offsetY, 0, 0, this.imageWidth, this.imageHeight);
    }

    private void renderVariantButtons(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        VariantScreenSelection.m_239260_((int)10, (int)this.bodyTopPos, (int)(this.f_96543_ - 10), (int)(this.bodyTopPos + this.buttonAreaHeight));
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button button = this.buttons.get(i);
            button.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            if (i != this.selectedButton) continue;
            this.renderButtonBorder(poseStack, button, -2147418368);
        }
        VariantScreenSelection.m_240060_();
    }

    private void renderButtonBorder(PoseStack poseStack, Button button, int color) {
        int width = button.m_5711_();
        int height = button.m_93694_();
        VariantScreenSelection.m_93172_((PoseStack)poseStack, (int)button.f_93620_, (int)button.f_93621_, (int)(button.f_93620_ + width), (int)(button.f_93621_ + 1), (int)color);
        VariantScreenSelection.m_93172_((PoseStack)poseStack, (int)button.f_93620_, (int)(button.f_93621_ + height - 1), (int)(button.f_93620_ + width), (int)(button.f_93621_ + height), (int)color);
        VariantScreenSelection.m_93172_((PoseStack)poseStack, (int)button.f_93620_, (int)button.f_93621_, (int)(button.f_93620_ + 1), (int)(button.f_93621_ + height), (int)color);
        VariantScreenSelection.m_93172_((PoseStack)poseStack, (int)(button.f_93620_ + width - 1), (int)button.f_93621_, (int)(button.f_93620_ + width), (int)(button.f_93621_ + height), (int)color);
    }

    private void renderOtherButtons(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        if (this.blockEntityInterface.getOwner().map(uuid -> uuid.equals(this.f_96541_.f_91074_.m_20148_())).orElse(true).booleanValue()) {
            this.m_93228_(poseStack, this.deleteButton.f_93620_ + 1, this.deleteButton.f_93621_ + 1, 176 + (this.selectedButton != -1 ? 0 : 9), 39, 9, 12);
            this.m_93228_(poseStack, this.applyButton.f_93620_ + 1, this.applyButton.f_93621_ + 1, 176 + (this.selectedButton != -1 ? 0 : 12), 51, 12, 12);
        }
        this.m_93228_(poseStack, this.configureButton.f_93620_, this.configureButton.f_93621_, 176, 63, 10, 10);
    }

    private void renderScrollBar(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int scrollThumbHeight = 15;
        int scrollPosition = this.needsScrollBars() ? this.bodyTopPos + (int)((float)(this.buttonAreaHeight - scrollThumbHeight) * this.currentVariantScroll) : this.bodyTopPos;
        this.m_93228_(poseStack, this.leftPos + 9, scrollPosition, 176 + (this.needsScrollBars() ? 0 : 12), 0, 12, scrollThumbHeight);
    }

    private void renderTextBar(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        float f;
        MutableComponent text = Component.m_237110_((String)FIXED_TEXT, (Object[])new Object[]{this.blockEntityInterface.getAnimalCount()});
        poseStack.m_85836_();
        float textWidth = this.f_96547_.m_92852_((FormattedText)text);
        Objects.requireNonNull(this);
        float scale = Math.min(1.0f, 64.0f / textWidth);
        double d = this.sliderBarPos;
        float f2 = this.topPos + 112 + 7;
        Objects.requireNonNull(this.f_96547_);
        poseStack.m_85837_(d, (double)(f2 - 9.0f * scale / 2.0f), 0.0);
        poseStack.m_85841_(scale, scale, 1.0f);
        if (scale < 1.0f) {
            f = 0.0f;
        } else {
            Objects.requireNonNull(this);
            f = (64.0f - textWidth) / 2.0f;
        }
        this.f_96547_.m_92889_(poseStack, (Component)text, f, 0.0f, 0xFFFFFF);
        poseStack.m_85849_();
    }

    private void renderEntity(@NotNull PoseStack poseStack, float partialTicks) {
        float x = this.leftPos + 73 + 48;
        float y = this.bodyTopPos + 46;
        this.displayEntity.f_20883_ = 0.0f;
        this.displayEntity.m_146922_(0.0f);
        this.displayEntity.f_20885_ = 0.0f;
        this.displayEntity.f_20886_ = 0.0f;
        LivingEntity livingEntity = this.displayEntity;
        if (livingEntity instanceof WaterAnimal) {
            WaterAnimal animal = (WaterAnimal)livingEntity;
            animal.m_20124_(Pose.SWIMMING);
            animal.m_20282_(true);
            ((EntityAccessor)animal).setWasTouchingWater(true);
            y -= 10.0f;
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 50.0);
        poseStack.m_85841_(this.entityScale, this.entityScale, this.entityScale);
        poseStack.m_85837_(0.0, (double)this.entityOffset, 0.0);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(this.entityRotation));
        EntityRenderDispatcher erd = Minecraft.m_91087_().m_91290_();
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        erd.m_114468_(false);
        erd.m_114384_((Entity)this.displayEntity, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, (MultiBufferSource)immediate, 0xF000F0);
        erd.m_114468_(true);
        immediate.m_109911_();
        poseStack.m_85849_();
    }

    private void renderCooldown(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)COOLDOWN_TEXTURE);
        this.m_93228_(poseStack, this.leftPos - 12, this.topPos + (this.imageHeight - 18) / 2, 149 + (this.isCooldownOpened ? 0 : 11), this.cooldownButton.m_5953_((double)mouseX, (double)mouseY) ? 18 : 1, 11, 18);
        if (this.isCooldownOpened) {
            this.m_93228_(poseStack, this.leftPos - 12 - this.cooldownWidth, this.topPos, 0, 1, this.cooldownWidth, this.imageHeight + 1);
            List<Pair<ItemStack[], Component>> textList = this.blockEntityInterface.getCooldownLines(false);
            if (!textList.isEmpty()) {
                int leftOffset = this.leftPos - this.cooldownWidth;
                Objects.requireNonNull(this.f_96547_);
                int top = this.topPos + 9;
                for (int i = 0; i < textList.size(); ++i) {
                    this.renderTextLine(poseStack, textList.get(i), leftOffset, top + i * 16, mouseX, mouseY);
                }
            }
        }
    }

    private void renderTextLine(@NotNull PoseStack poseStack, Pair<ItemStack[], Component> componentPair, int leftOffset, int y, int mouseX, int mouseY) {
        Component text = (Component)componentPair.getRight();
        ItemStack first = ((ItemStack[])componentPair.getLeft()).length > 0 ? ((ItemStack[])componentPair.getLeft())[0] : null;
        ItemStack second = ((ItemStack[])componentPair.getLeft()).length > 1 ? ((ItemStack[])componentPair.getLeft())[1] : null;
        ArrayList<Pair> itemPositions = new ArrayList<Pair>();
        int whiteSpace = this.f_96547_.m_92895_(" ");
        boolean isFirst = true;
        for (Component part : text.m_178405_(Style.f_131099_)) {
            String content = part.getString();
            if (content.equals("\ue000")) {
                if (first == null) continue;
                if (!isFirst) {
                    leftOffset -= whiteSpace;
                }
                this.f_96542_.m_115123_(first, leftOffset, y);
                itemPositions.add(Pair.of((Object)first, (Object)new Rect2i(leftOffset, y, 16, 16)));
                leftOffset += 16 - whiteSpace;
            } else if (content.equals("\ue001")) {
                if (second == null) continue;
                if (!isFirst) {
                    leftOffset -= whiteSpace;
                }
                this.f_96542_.m_115123_(second, leftOffset, y);
                itemPositions.add(Pair.of((Object)second, (Object)new Rect2i(leftOffset, y, 16, 16)));
                leftOffset += 16 - whiteSpace;
            } else {
                float f = leftOffset;
                float f2 = y;
                Objects.requireNonNull(this.f_96547_);
                this.f_96547_.m_92889_(poseStack, part, f, f2 + 9.0f / 2.0f + 2.0f, 0xFFFFFF);
                leftOffset += this.f_96547_.m_92852_((FormattedText)part);
            }
            isFirst = false;
        }
        for (Pair itemPos : itemPositions) {
            Rect2i rect = (Rect2i)itemPos.getRight();
            if (mouseX < rect.m_110085_() || mouseX > rect.m_110085_() + rect.m_110090_() || mouseY < rect.m_110086_() || mouseY > rect.m_110086_() + rect.m_110091_()) continue;
            this.m_6057_(poseStack, (ItemStack)itemPos.getLeft(), mouseX, mouseY);
            break;
        }
    }

    private void renderTooltips(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.applyButton.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(poseStack, APPLY, mouseX, mouseY);
        }
        if (this.deleteButton.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(poseStack, this.selectedButton != -1 ? DELETE : SELECT_TO_DELETE, mouseX, mouseY);
        }
        if (this.cooldownButton.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(poseStack, this.isCooldownOpened ? COOLDOWN_CLOSE : COOLDOWN_OPEN, mouseX, mouseY);
        }
        if (this.configureButton.m_5953_((double)mouseX, (double)mouseY)) {
            this.m_96602_(poseStack, CONFIGURE, mouseX, mouseY);
        }
    }

    private boolean needsScrollBars() {
        return this.buttons.size() > 5;
    }

    private void handleDeleteButton(Button button) {
        if (this.selectedButton == -1) {
            return;
        }
        NetworkManager.sendToServer((ResourceLocation)RemoveDisplayAnimalData.ID, (FriendlyByteBuf)RemoveDisplayAnimalData.encode(this.position, this.selectedButton));
        this.selectedButton = -1;
        this.applyButton.f_93623_ = false;
        this.m_7856_();
    }

    private void handleApplyButton(Button button) {
        NetworkManager.sendToServer((ResourceLocation)UpdateDisplayAnimalData.ID, (FriendlyByteBuf)UpdateDisplayAnimalData.encode(this.position, this.blockEntityInterface.getEntityVariants().m_128728_(this.selectedButton)));
        this.displayEntity.m_20258_(this.blockEntityInterface.getEntityVariants().m_128728_(this.selectedButton));
        this.selectedButton = -1;
    }

    private void handleVariantButton(Button button, int index) {
        CompoundTag tag;
        if (button.f_93621_ + button.m_93694_() < this.bodyTopPos || button.f_93621_ > this.bodyTopPos + this.buttonAreaHeight) {
            return;
        }
        if (this.selectedButton == index) {
            this.selectedButton = -1;
            this.applyButton.f_93623_ = false;
        } else {
            this.selectedButton = index;
            boolean bl = this.applyButton.f_93623_ = !this.buttons.isEmpty() && this.blockEntityInterface.getOwner().map(uuid -> uuid.equals(this.f_96541_.f_91074_.m_20148_())).orElse(true) != false;
        }
        if (this.selectedButton != -1) {
            tag = (CompoundTag)this.blockEntityInterface.getEntityVariants().get(index);
        } else {
            tag = new CompoundTag();
            this.blockEntityInterface.getStoredAnimal().ifPresent(entity -> entity.m_20223_(tag));
        }
        this.displayEntity.m_20258_(tag);
        this.currentXOnEntity = 0;
    }

    private void handleConfigureButton(Button button) {
        this.f_96541_.m_91152_((Screen)new VariantsConfigScreen(this));
    }

    private void handleCooldownButton(Button button) {
        this.isCooldownOpened = !this.isCooldownOpened;
        this.m_7856_();
    }

    private boolean scrollBarClicked(double mouseX, double mouseY) {
        int scrollLeft = this.leftPos + 9;
        int scrollRight = scrollLeft + 12;
        int scrollBottom = this.bodyTopPos + this.buttonAreaHeight;
        return mouseX >= (double)scrollLeft && mouseY >= (double)this.bodyTopPos && mouseX < (double)scrollRight && mouseY < (double)scrollBottom;
    }

    private boolean entityAreaClicked(double mouseX, double mouseY) {
        int left = this.leftPos + 73;
        int top = this.bodyTopPos;
        int right = left + 96;
        int bottom = top + 92;
        return mouseX >= (double)left && mouseX < (double)right && mouseY >= (double)top && mouseY < (double)bottom;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.scrollBarClicked(mouseX, mouseY)) {
            this.isScrollingVariants = true;
            this.m_7979_(mouseX, mouseY, button, 0.0, 0.0);
            return true;
        }
        if (this.entityAreaClicked(mouseX, mouseY)) {
            this.currentXOnEntity = (int)mouseX;
            this.isSelectingEntity = true;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isSelectingEntity = false;
        this.isScrollingVariants = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (!this.needsScrollBars()) {
            return false;
        }
        this.currentVariantScroll = (float)((double)this.currentVariantScroll - amount / 10.0);
        this.currentVariantScroll = Mth.m_14036_((float)this.currentVariantScroll, (float)0.0f, (float)1.0f);
        this.updateButtonPositions();
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrollingVariants && this.needsScrollBars()) {
            int scrollBottom = this.bodyTopPos + this.buttonAreaHeight;
            this.currentVariantScroll = ((float)mouseY - (float)this.bodyTopPos) / (float)(scrollBottom - this.bodyTopPos);
            this.currentVariantScroll = Mth.m_14036_((float)this.currentVariantScroll, (float)0.0f, (float)1.0f);
            this.updateButtonPositions();
            return true;
        }
        if (this.isSelectingEntity) {
            int deltaX = (int)mouseX - this.currentXOnEntity;
            this.entityRotation -= (float)deltaX;
            while (this.entityRotation < 0.0f) {
                this.entityRotation += 360.0f;
            }
            while (this.entityRotation >= 360.0f) {
                this.entityRotation -= 360.0f;
            }
            this.currentXOnEntity = (int)mouseX;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 265 || keyCode == 264) && this.buttons.size() > 1) {
            int button = keyCode == 264 ? Math.min(this.selectedButton + 1, this.buttons.size() - 1) : Math.max(this.selectedButton - 1, 0);
            if (button != this.selectedButton) {
                this.ensureButtonVisible(button);
                this.handleVariantButton(this.buttons.get(button), button);
            }
            return true;
        }
        if (keyCode == 257) {
            if (this.selectedButton >= 0 && this.selectedButton < this.buttons.size() && this.applyButton.m_142518_()) {
                this.handleApplyButton(null);
                return true;
            }
        } else if (keyCode == 261 && this.selectedButton >= 0 && this.selectedButton < this.buttons.size()) {
            this.handleDeleteButton(null);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    private void updateButtonPositions() {
        int buttonHeight = 20;
        int totalButtonsHeight = this.buttons.size() * buttonHeight;
        int maxScrollPixels = Math.max(0, totalButtonsHeight - this.buttonAreaHeight);
        int scrollOffset = (int)((float)maxScrollPixels * this.currentVariantScroll);
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button button = this.buttons.get(i);
            button.f_93621_ = this.bodyTopPos + i * buttonHeight - scrollOffset;
        }
    }

    private void ensureButtonVisible(int buttonIndex) {
        if (buttonIndex < 0 || buttonIndex >= this.buttons.size()) {
            return;
        }
        Button targetButton = this.buttons.get(buttonIndex);
        int buttonTop = targetButton.f_93621_;
        int buttonBottom = buttonTop + targetButton.m_93694_();
        float areaDifference = this.buttons.size() * targetButton.m_93694_() - this.buttonAreaHeight;
        if (buttonTop < this.bodyTopPos) {
            float newScrollPos = (float)(this.bodyTopPos - buttonTop) / areaDifference;
            this.currentVariantScroll = Mth.m_14036_((float)(this.currentVariantScroll - newScrollPos), (float)0.0f, (float)1.0f);
            this.updateButtonPositions();
        } else if (buttonBottom > this.bodyTopPos + this.buttonAreaHeight) {
            float newScrollPos = (float)(buttonBottom - this.bodyTopPos - 106) / areaDifference;
            this.currentVariantScroll = Mth.m_14036_((float)(this.currentVariantScroll + newScrollPos), (float)0.0f, (float)1.0f);
            this.updateButtonPositions();
        }
    }
}

