/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.client.screens;

import dev.architectury.networking.NetworkManager;
import lv.id.bonne.animalpen.client.screens.VariantScreenSelection;
import lv.id.bonne.animalpen.network.packets.UpdateConfigurationData;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class VariantsConfigScreen
extends Screen {
    private final VariantScreenSelection parent;
    private final long maxAnimalAmount;
    private long displayAnimalAmount;
    private long minimalAnimalCount;
    private boolean enableProtection;
    private DisplayAnimalAmountSlider displayAnimalAmountSlider;
    private EditBox minimalAnimalCountField;
    private Checkbox protectionCheckbox;
    public static final Component TITLE = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.configure.title");
    public static final Component MINIMAL_ANIMAL_COUNT = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.configure.minimal_animal_count");
    public static final Component PROTECTION = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.configure.enable_protection");
    public static final Component SAVE = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.configure.save");
    public static final Component CANCEL = Component.m_237115_((String)"gui.animal_pen.variant_selection_screen.configure.cancel");

    public VariantsConfigScreen(VariantScreenSelection parent) {
        super(TITLE);
        this.parent = parent;
        this.maxAnimalAmount = this.parent.blockEntityInterface.getAnimalCount();
        this.displayAnimalAmount = this.parent.blockEntityInterface.getAnimalDisplaySize();
        if (!this.parent.blockEntityInterface.canGrowEntity()) {
            this.displayAnimalAmount = this.maxAnimalAmount;
        }
        this.minimalAnimalCount = this.parent.blockEntityInterface.getProtectedAmount();
        this.enableProtection = this.parent.blockEntityInterface.getOwner().isPresent();
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int startY = this.f_96544_ / 2 - 60;
        boolean canEdit = this.parent.blockEntityInterface.getOwner().isEmpty() || this.parent.blockEntityInterface.getOwner().map(owner -> owner.equals(this.f_96541_.f_91074_.m_20148_())).orElse(false) != false;
        this.displayAnimalAmountSlider = new DisplayAnimalAmountSlider(centerX - 100, startY, 200, 20, (int)this.displayAnimalAmount, (int)this.maxAnimalAmount);
        this.m_142416_((GuiEventListener)this.displayAnimalAmountSlider);
        this.displayAnimalAmountSlider.f_93623_ = canEdit;
        if (!this.parent.blockEntityInterface.canGrowEntity()) {
            this.displayAnimalAmountSlider.f_93623_ = false;
        }
        this.minimalAnimalCountField = new EditBox(this.f_96547_, centerX - 100, startY + 40, 200, 20, MINIMAL_ANIMAL_COUNT);
        this.minimalAnimalCountField.m_94144_(String.valueOf(this.minimalAnimalCount));
        this.minimalAnimalCountField.m_94153_(this::isValidNumber);
        this.minimalAnimalCountField.m_94199_(3);
        this.m_142416_((GuiEventListener)this.minimalAnimalCountField);
        this.minimalAnimalCountField.m_94186_(canEdit);
        this.protectionCheckbox = Checkbox.m_306644_((Component)PROTECTION, (Font)this.f_96547_).m_307310_(centerX - 100, startY + 80).m_307950_(this.enableProtection).m_307240_();
        this.m_142416_((GuiEventListener)this.protectionCheckbox);
        this.protectionCheckbox.f_93623_ = canEdit;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)SAVE, this::onSave).m_252794_(centerX - 102, startY + 120).m_253046_(100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CANCEL, this::onCancel).m_252794_(centerX + 2, startY + 120).m_253046_(100, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        int centerX = this.f_96543_ / 2;
        int startY = this.f_96544_ / 2 - 60;
        MutableComponent size = Component.m_237110_((String)"gui.animal_pen.variant_selection_screen.configure.entity_size", (Object[])new Object[]{this.displayAnimalAmountSlider.getIntValue(), this.maxAnimalAmount});
        graphics.m_280430_(this.f_96547_, (Component)size, centerX - 100, startY - 12, 0xFFFFFF);
        graphics.m_280430_(this.f_96547_, MINIMAL_ANIMAL_COUNT, centerX - 100, startY + 28, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void onSave(Button button) {
        this.displayAnimalAmount = this.displayAnimalAmountSlider.getIntValue();
        try {
            int inputValue = Integer.parseInt(this.minimalAnimalCountField.m_94155_());
            if (inputValue < 0) {
                this.minimalAnimalCount = 0L;
                this.minimalAnimalCountField.m_94144_("0");
            } else {
                this.minimalAnimalCount = inputValue;
            }
        }
        catch (NumberFormatException e) {
            this.minimalAnimalCountField.m_94144_(String.valueOf(this.minimalAnimalCount));
        }
        this.enableProtection = this.protectionCheckbox.m_93840_();
        if (this.parent.blockEntityInterface.getOwner().isEmpty() || this.parent.blockEntityInterface.getOwner().map(owner -> owner.equals(this.f_96541_.f_91074_.m_20148_())).orElse(false).booleanValue()) {
            this.saveConfiguration();
        }
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    private void onCancel(Button button) {
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    private void saveConfiguration() {
        NetworkManager.sendToServer((ResourceLocation)UpdateConfigurationData.ID, (FriendlyByteBuf)UpdateConfigurationData.encode(this.parent.getPosition(), this.displayAnimalAmount, this.minimalAnimalCount, this.enableProtection ? this.f_96541_.f_91074_.m_20148_() : null));
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    private boolean isValidNumber(String input) {
        if (input.isEmpty()) {
            return true;
        }
        try {
            int value = Integer.parseInt(input);
            return value >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static class DisplayAnimalAmountSlider
    extends AbstractSliderButton {
        private final int maxValue;

        public DisplayAnimalAmountSlider(int x, int y, int width, int height, int initialValue, int maxValue) {
            super(x, y, width, height, (Component)Component.m_237119_(), (double)(initialValue - 1) / (double)Math.max(1, maxValue - 1));
            this.maxValue = maxValue;
            this.m_5695_();
        }

        protected void m_5695_() {
            this.m_93666_((Component)Component.m_237113_((String)String.valueOf(this.getIntValue())));
        }

        protected void m_5697_() {
        }

        public int getIntValue() {
            if (this.maxValue == 1) {
                return 1;
            }
            int minValue = 1;
            return minValue + (int)((double)(this.maxValue - minValue) * this.f_93577_);
        }
    }
}

