/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.time.LocalTime;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Chicken.class})
public abstract class AnimalPenChicken
extends AnimalPenAnimal {
    @Unique
    private int animalPen$eggCooldown;

    protected AnimalPenChicken(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$eggCooldown > 0) {
            --this.animalPen$eggCooldown;
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.m_128405_("egg_cooldown", this.animalPen$eggCooldown);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$eggCooldown = tag.m_128451_("egg_cooldown");
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42446_)) {
            if (this.animalPen$eggCooldown > 0) {
                AnimalPen.sendDebug("Under cooldown for " + this.animalPen$eggCooldown);
                return false;
            }
            if (player.m_9236_().m_5776_()) {
                return true;
            }
            int dropLimits = AnimalPen.config().getDropLimits(Items.f_42521_);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int eggCount = (int)Math.min(this.animalPen$animalCount, (long)dropLimits);
            while (eggCount > 0) {
                ItemStack eggStack = new ItemStack((ItemLike)Items.f_42521_);
                if (eggCount > 16) {
                    eggStack.m_41764_(16);
                    eggCount -= 16;
                } else {
                    eggStack.m_41764_(eggCount);
                    eggCount = 0;
                }
                Block.m_49840_((Level)player.m_9236_(), (BlockPos)position.m_7494_(), (ItemStack)eggStack);
            }
            player.m_9236_().m_5594_(null, position, SoundEvents.f_11752_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$eggCooldown = AnimalPen.config().getEntityCooldown(this.m_6095_(), Items.f_42446_, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.m_41720_().arch$registryName()));
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public ItemStack animalPen$animalPenInteract(ServerLevel level, ItemStack itemStack, BlockPos position) {
        if (this.animalPen$eggCooldown > 0) {
            AnimalPen.sendDebug("Under cooldown for " + this.animalPen$eggCooldown);
            return ItemStack.f_41583_;
        }
        if (itemStack.m_150930_(Items.f_42446_)) {
            int dropLimits = AnimalPen.config().getDropLimits(Items.f_42521_);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int eggCount = (int)Math.min(this.animalPen$animalCount, (long)dropLimits);
            while (eggCount > 0) {
                ItemStack eggStack = new ItemStack((ItemLike)Items.f_42521_);
                if (eggCount > 16) {
                    eggStack.m_41764_(16);
                    eggCount -= 16;
                } else {
                    eggStack.m_41764_(eggCount);
                    eggCount = 0;
                }
                Block.m_49840_((Level)level, (BlockPos)position.m_7494_(), (ItemStack)eggStack);
            }
            level.m_5594_(null, position, SoundEvents.f_11752_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$eggCooldown = AnimalPen.config().getEntityCooldown(this.m_6095_(), Items.f_42446_, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.m_41720_().arch$registryName()));
            return ItemStack.f_41583_;
        }
        return super.animalPen$animalPenInteract(level, itemStack, position);
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        List<Pair<ItemStack[], Component>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (shortLine && AnimalPen.config().getEntityCooldown(this.m_6095_(), Items.f_42446_, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = Component.m_237113_((String)"");
        if (this.animalPen$eggCooldown == 0) {
            component.m_7220_((Component)Component.m_237110_((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.full_ready"), (Object[])new Object[]{Component.m_237113_((String)"\ue000"), Component.m_237113_((String)"\ue001")}).m_130940_(ChatFormatting.GREEN));
        } else {
            component.m_7220_((Component)Component.m_237110_((String)(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.egg_cooldown"), (Object[])new Object[]{Component.m_237113_((String)"\ue000"), Component.m_237113_((String)"\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$eggCooldown / 20).format(AnimalPen.DATE_FORMATTER)}));
        }
        lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.f_42446_.m_7968_(), Items.f_42521_.m_7968_()}, (Object)component));
        return lines;
    }

    @Override
    @Intrinsic
    public int animalPen$getRedStoneSignal() {
        if (this.animalPen$eggCooldown > 0) {
            return super.animalPen$getRedStoneSignal();
        }
        return super.animalPen$getRedStoneSignal() | 4;
    }
}

