/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.registries;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import lv.id.bonne.animalpen.blocks.AnimalPenBlock;
import lv.id.bonne.animalpen.blocks.AquariumBlock;
import lv.id.bonne.animalpen.registries.AnimalPensCreativeTabRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;

public class AnimalPenBlockRegistry {
    public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((String)"animal_pen", (ResourceKey)Registries.f_256747_);
    public static final Map<WoodType, RegistrySupplier<Block>> ANIMAL_PENS = new HashMap<WoodType, RegistrySupplier<Block>>();
    public static final RegistrySupplier<Block> AQUARIUM = AnimalPenBlockRegistry.registerBlock("aquarium_block", () -> new AquariumBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)Blocks.f_50058_).m_60978_(1.0f).m_60918_(SoundType.f_56744_).m_60955_()));

    public static void register() {
        REGISTRY.register();
    }

    private static <T extends Block> RegistrySupplier<T> registerBlock(String name, Supplier<T> block) {
        RegistrySupplier toReturn = REGISTRY.register(name, block);
        AnimalPenBlockRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistrySupplier<Item> registerBlockItem(String name, RegistrySupplier<T> block) {
        return AnimalPensItemRegistry.REGISTRY.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().arch$tab(AnimalPensCreativeTabRegistry.ANIMAL_PEN_TAB)));
    }

    public static void registerPen(WoodType woodType, MapColor mapColor, FeatureFlag ... flags) {
        String woodName = woodType.f_61839_().toLowerCase();
        if (woodType.f_61839_().contains(":")) {
            woodName = woodName.replaceAll(":", "_");
        }
        RegistrySupplier<Block> block = AnimalPenBlockRegistry.registerBlock("animal_pen_" + woodName, () -> new AnimalPenBlock(BlockBehaviour.Properties.m_284310_().m_284180_(mapColor).m_60978_(1.0f).m_60918_(woodType.f_271317_()).m_60955_().m_246843_(flags)));
        ANIMAL_PENS.put(woodType, block);
    }

    static {
        AnimalPenBlockRegistry.registerPen(WoodType.f_61830_, MapColor.f_283825_, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.f_61831_, MapColor.f_283819_, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.f_61832_, MapColor.f_283761_, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.f_61833_, MapColor.f_283818_, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.f_61834_, MapColor.f_283762_, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.f_61835_, MapColor.f_283748_, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.f_61836_, MapColor.f_283804_, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.f_61837_, MapColor.f_283749_, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.f_223002_, MapColor.f_283913_, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.f_244200_, MapColor.f_283832_, new FeatureFlag[0]);
        AnimalPenBlockRegistry.registerPen(WoodType.f_271224_, MapColor.f_283861_, new FeatureFlag[0]);
    }
}

