/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.listeners;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.architectury.registry.registries.RegistrarManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class TaggableIngredient
implements Predicate<ItemStack> {
    private final Value[] values;
    @Nullable
    private HolderSet<Item> items;
    @Nullable
    private ItemStack[] itemStacks;
    public static final Codec<TaggableIngredient> CODEC = TaggableIngredient.codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, TaggableIngredient> CONTENTS_STREAM_CODEC = ItemStack.OPTIONAL_LIST_STREAM_CODEC.map(list -> TaggableIngredient.fromValues(list.stream().map(ItemStack::getItemHolder).map(ItemValue::new)), ingredient -> Arrays.stream(ingredient.values).flatMap(value -> value.getItems().stream()).map(Holder::value).map(Item::getDefaultInstance).toList());

    private TaggableIngredient(Value[] values) {
        this.values = values;
    }

    public HolderSet<Item> getItems() {
        if (this.items == null) {
            this.items = HolderSet.direct(Arrays.stream(this.values).flatMap(value -> value.getItems().stream()).distinct().toList());
        }
        return this.items;
    }

    public ItemStack[] getItemStacks() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])this.getItems().stream().filter(Holder::isBound).map(holder -> ((Item)holder.value()).getDefaultInstance()).toArray(ItemStack[]::new);
        }
        return this.itemStacks;
    }

    @Override
    public boolean test(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (this.isEmpty()) {
            return itemStack.isEmpty();
        }
        return itemStack.is(this.getItems());
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof TaggableIngredient)) return false;
        TaggableIngredient ingredient = (TaggableIngredient)object;
        if (!Arrays.equals(this.values, ingredient.values)) return false;
        return true;
    }

    private static Codec<TaggableIngredient> codec() {
        Codec codec = Codec.list(Value.CODEC).comapFlatMap(list -> DataResult.success((Object)list.toArray(new Value[0])), List::of);
        return codec.xmap(TaggableIngredient::new, ingredient -> ingredient.values);
    }

    private static TaggableIngredient fromValues(Stream<? extends Value> stream) {
        return new TaggableIngredient((Value[])stream.toArray(Value[]::new));
    }

    static interface Value {
        public static final Codec<Value> CODEC = Codec.STRING.xmap(str -> {
            if (str.startsWith("#")) {
                return new TagValue((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)str.substring(1))));
            }
            return new ItemValue((Holder<Item>)RegistrarManager.get((String)"animal_pen").get(Registries.ITEM).getHolder(ResourceLocation.parse((String)str)));
        }, value -> {
            Holder<Item> item;
            if (value instanceof TagValue) {
                TagKey<Item> patt1$temp;
                TagValue $b$0 = (TagValue)value;
                TagKey<Item> tag = patt1$temp = $b$0.tag();
                return "#" + String.valueOf(tag.location());
            }
            if (!(value instanceof ItemValue)) throw new UnsupportedOperationException("Unknown value type");
            ItemValue $b$2 = (ItemValue)value;
            try {
                Holder<Item> patt3$temp;
                item = patt3$temp = $b$2.item();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return item.getRegisteredName();
        });

        public Collection<Holder<Item>> getItems();
    }

    public record TagValue(TagKey<Item> tag) implements Value
    {
        @Override
        public Collection<Holder<Item>> getItems() {
            ArrayList<Holder<Item>> items = new ArrayList<Holder<Item>>();
            BuiltInRegistries.ITEM.getTagOrEmpty(this.tag).forEach(items::add);
            return items;
        }
    }

    record ItemValue(Holder<Item> item) implements Value
    {
        @Override
        public Collection<Holder<Item>> getItems() {
            return Collections.singleton(this.item);
        }
    }
}

