/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.watercreature;

import java.time.LocalTime;
import java.util.LinkedList;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.registries.AnimalPenFoodRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={AgeableWaterCreature.class})
@Implements(value={@Interface(iface=AnimalPenInterface.class, prefix="animalPen$", unique=true)})
public abstract class AnimalPenWaterCreature
extends Mob {
    @Unique
    protected int animalPen$foodCooldown = 0;
    @Unique
    protected long animalPen$animalCount = 0L;

    protected AnimalPenWaterCreature(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        this.animalPen$animalPenSaveTag(compoundTag);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.animalPen$animalPenLoadTag(compoundTag);
    }

    @Intrinsic
    public boolean animalPen$animalPenUpdateCount(long change) {
        if (change < 0L && this.animalPen$animalCount + change < 0L) {
            return false;
        }
        long maxCount = AnimalPen.CONFIG_MANAGER.getConfiguration().getMaximalAnimalCount();
        if (maxCount > 0L && this.animalPen$animalCount + change > maxCount) {
            return false;
        }
        this.animalPen$animalCount += change;
        return true;
    }

    @Intrinsic
    public long animalPen$animalPenGetCount() {
        return this.animalPen$animalCount;
    }

    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        if (this.animalPen$foodCooldown > 0) {
            --this.animalPen$foodCooldown;
            return true;
        }
        return false;
    }

    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        tag.putInt("food_cooldown", this.animalPen$foodCooldown);
        tag.putLong("animal_count", this.animalPen$animalCount);
    }

    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        this.animalPen$foodCooldown = tag.getIntOr("food_cooldown", 0);
        this.animalPen$animalCount = tag.getLongOr("animal_count", 0L);
    }

    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (AnimalPenFoodRegistry.isFood(this.getType().arch$registryName(), itemStack)) {
            if (this.animalPen$foodCooldown > 0) {
                return false;
            }
            long maxCount = AnimalPen.CONFIG_MANAGER.getConfiguration().getMaximalAnimalCount();
            if (maxCount > 0L && this.animalPen$animalCount >= maxCount) {
                return false;
            }
            int stackSize = itemStack.getCount();
            if ((stackSize = (int)Math.min(this.animalPen$animalCount, (long)stackSize)) < 2) {
                return false;
            }
            if (player.level().isClientSide()) {
                return true;
            }
            stackSize = (int)Math.min((maxCount - this.animalPen$animalCount) * 2L, (long)stackSize);
            if (!player.getAbilities().instabuild) {
                if (stackSize % 2 == 1) {
                    itemStack.shrink(stackSize - 1);
                    player.setItemInHand(hand, itemStack);
                } else {
                    itemStack.shrink(stackSize);
                    player.setItemInHand(hand, itemStack);
                }
            }
            this.animalPen$animalCount += (long)(stackSize / 2);
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, (double)((float)position.getX() + 0.5f), (double)position.getY() + 1.5, (double)((float)position.getZ() + 0.5f), 5, 0.2, 0.2, 0.2, 0.05);
            }
            player.level().playSound(null, position, (SoundEvent)SoundEvents.GENERIC_EAT.value(), SoundSource.NEUTRAL, 1.0f, Mth.randomBetween((RandomSource)player.level().random, (float)0.8f, (float)1.2f));
            SoundEvent soundEvent = this.getAmbientSound();
            if (soundEvent != null) {
                player.level().playSound(null, position, soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            this.animalPen$foodCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.APPLE, this.animalPen$animalCount);
            return true;
        }
        return false;
    }

    @Intrinsic
    public ItemStack animalPen$animalPenInteract(ServerLevel level, ItemStack itemStack, BlockPos position) {
        return ItemStack.EMPTY;
    }

    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        ItemStack foodItem;
        LinkedList<Pair<ItemStack[], Component>> lines = new LinkedList<Pair<ItemStack[], Component>>();
        if (!AnimalPen.config().isShowAllInteractions() && shortLine && AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.APPLE, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = this.animalPen$foodCooldown == 0 ? Component.translatable((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.food_ready"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001")}).withStyle(ChatFormatting.GREEN) : Component.translatable((String)(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.food_cooldown"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$foodCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
        ItemStack[] food = this.animalPen$getFood();
        if (food == null || food.length == 0) {
            return lines;
        }
        if (food.length == 1) {
            foodItem = food[0];
        } else {
            int size = food.length;
            int index = tick / 100 % size;
            foodItem = food[index];
        }
        lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{foodItem, foodItem}, (Object)component));
        return lines;
    }

    @Intrinsic
    @Nullable
    public ItemStack[] animalPen$getFood() {
        return AnimalPenFoodRegistry.getFood(this.getType().arch$registryName());
    }

    @Intrinsic
    public int animalPen$getRedStoneSignal() {
        int value = 1;
        if (this.animalPen$foodCooldown > 0 || this.animalPen$getFood() == null || this.animalPen$getFood().length == 0) {
            return value;
        }
        return value | 2;
    }
}

