/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.entities;

import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.items.AnimalCageItem;
import lv.id.bonne.animalpen.network.packets.UpdateVariantScreenData;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_8567;
import net.minecraft.class_8710;
import net.minecraft.class_8942;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalPenTileEntity
extends class_2586
implements AnimalPenBlockInterface<class_1429> {
    private final class_1277 inventory = new class_1277(1){

        public boolean method_5437(int slot, class_1799 stack) {
            return stack.method_31574((class_1792)AnimalPensItemRegistry.ANIMAL_CAGE.get());
        }

        public void method_5431() {
            super.method_5431();
            AnimalPenTileEntity.this.triggerUpdate();
        }
    };
    private class_1429 storedAnimal;
    private long displaySize = -1L;
    private int tickCounter;
    private final List<Integer> deathTicker = new ArrayList<Integer>();
    public static final String TAG_INVENTORY = "inventory";
    public static final String TAG_DEATH_TICKER = "death_ticker";
    public static final String TAG_DISPLAY_SIZE = "display_size";

    public AnimalPenTileEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)AnimalPenTileEntityRegistry.ANIMAL_PEN_TILE_ENTITY.get(), blockPos, blockState);
    }

    public void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        class_1262.method_5427((class_11372)valueOutput, (class_2371)this.inventory.method_54454(), (boolean)true);
        if (!this.deathTicker.isEmpty()) {
            valueOutput.method_71473(TAG_DEATH_TICKER, this.deathTicker.stream().mapToInt(i -> i).toArray());
        }
        valueOutput.method_71466(TAG_DISPLAY_SIZE, this.displaySize);
    }

    protected void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        this.inventory.method_5448();
        this.deathTicker.clear();
        this.storedAnimal = null;
        class_1262.method_5429((class_11368)valueInput, (class_2371)this.inventory.method_54454());
        valueInput.method_71442(TAG_DEATH_TICKER).ifPresent(deaths -> {
            for (int death : deaths) {
                this.deathTicker.add(death);
            }
        });
        this.displaySize = valueInput.method_71425(TAG_DISPLAY_SIZE, -1L);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public class_1429 getStoredAnimal() {
        if (this.storedAnimal == null && !this.getItemStack().method_7960()) {
            class_9279 customData = (class_9279)this.getItemStack().method_58694(class_9334.field_49609);
            if (customData == null) {
                return this.storedAnimal;
            }
            class_2487 tag = customData.method_57461();
            if (!tag.method_10545("id") || this.field_11863 == null) {
                return this.storedAnimal;
            }
            try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.method_71402(), AnimalPen.LOGGER);){
                class_11368 valueInput = class_11352.method_71417((class_8942)scopedCollector, (class_7225.class_7874)this.field_11863.method_30349(), (class_2487)tag);
                class_1299.method_5892((class_11368)valueInput, (class_1937)this.field_11863, (class_3730)class_3730.field_16461).map(entity -> (class_1429)entity).ifPresent(animal -> {
                    this.storedAnimal = animal;
                });
            }
        } else if (this.storedAnimal != null && this.getItemStack().method_7960()) {
            this.storedAnimal = null;
        }
        return this.storedAnimal;
    }

    public List<Integer> getDeathTicker() {
        return this.deathTicker;
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void tick() {
        ++this.tickCounter;
        if (this.method_10997() == null || this.method_10997().method_8608()) {
            return;
        }
        boolean updated = false;
        class_1429 animal = this.getStoredAnimal();
        if (animal != null && ((AnimalPenInterface)animal).animalPenTick(this)) {
            updated = true;
        }
        for (int i = 0; i < this.deathTicker.size(); ++i) {
            this.deathTicker.set(i, this.deathTicker.get(i) + 1);
            updated = true;
        }
        this.deathTicker.removeIf(integer -> integer > 20);
        if (updated) {
            this.triggerUpdate();
        }
    }

    public boolean processContainer(class_1657 player, class_1268 interactionHand) {
        if (this.inventory.method_5442()) {
            class_1799 itemInHand = player.method_5998(interactionHand);
            if (!itemInHand.method_57826(class_9334.field_49609)) {
                return false;
            }
            if (!player.method_37908().method_8608()) {
                this.inventory.method_5491(itemInHand);
                player.method_6122(interactionHand, class_1799.field_8037);
                if (this.field_11863 != null && !this.field_11863.method_8608()) {
                    NetworkManager.sendToPlayers(((class_3218)this.field_11863).method_18456().stream().filter(other -> other.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) < 50.0).toList(), (class_8710)new UpdateVariantScreenData(this.method_11016()));
                }
            }
            return true;
        }
        class_1799 itemInHand = player.method_5998(interactionHand);
        if (!itemInHand.method_57826(class_9334.field_49609)) {
            class_2487 tag;
            if (!player.method_18276()) {
                return false;
            }
            if (player.method_37908().method_8608()) {
                return true;
            }
            class_1429 animal = this.getStoredAnimal();
            if (animal == null) {
                return false;
            }
            long currentCount = ((AnimalPenInterface)animal).animalPenGetCount();
            if (currentCount < 2L) {
                return false;
            }
            long newCount = currentCount / 2L;
            if (!((AnimalPenInterface)animal).animalPenUpdateCount(-newCount)) {
                return false;
            }
            try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.method_71402(), AnimalPen.LOGGER);){
                class_11362 valueOutput = class_11362.method_71459((class_8942)scopedCollector, (class_7225.class_7874)animal.method_56673());
                animal.method_5662((class_11372)valueOutput);
                tag = valueOutput.method_71475();
            }
            tag.method_10544("animal_count", newCount);
            itemInHand.method_57379(class_9334.field_49609, (Object)class_9279.method_57456((class_2487)tag));
            player.method_6122(interactionHand, itemInHand);
            this.inventory.method_5431();
            return true;
        }
        class_1429 animal = this.getStoredAnimal();
        class_2487 itemInHandTag = ((class_9279)itemInHand.method_58694(class_9334.field_49609)).method_57461();
        if (animal == null || !itemInHandTag.method_10558("id").orElse("").equals(animal.method_5864().arch$registryName().toString())) {
            return false;
        }
        if (player.method_37908().method_8608()) {
            return true;
        }
        long newCount = itemInHandTag.method_68080("animal_count", 0L);
        if (newCount <= 0L || !((AnimalPenInterface)animal).animalPenUpdateCount(newCount)) {
            return false;
        }
        if (newCount > 1L && !AnimalCageItem.canMergeAnimalVariants(this.getItemStack(), itemInHand, player)) {
            ((AnimalPenInterface)animal).animalPenUpdateCount(-1L);
            itemInHandTag.method_10544("animal_count", 1L);
            itemInHand.method_57379(class_9334.field_49609, (Object)class_9279.method_57456((class_2487)itemInHandTag));
        } else {
            AnimalCageItem.mergeAnimalVariants(this.getItemStack(), itemInHand, player);
            itemInHand.method_57381(class_9334.field_49609);
            itemInHand.method_57381((class_9331)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
            if (this.field_11863 != null && !this.field_11863.method_8608()) {
                NetworkManager.sendToPlayers(((class_3218)this.field_11863).method_18456().stream().filter(other -> other.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) < 50.0).toList(), (class_8710)new UpdateVariantScreenData(this.method_11016()));
            }
        }
        player.method_6122(interactionHand, itemInHand);
        this.inventory.method_5431();
        return true;
    }

    public boolean interactWithPen(class_1657 player, class_1268 interactionHand) {
        class_1799 itemInHand = player.method_5998(interactionHand);
        if (itemInHand.method_7960() && !this.inventory.method_5442()) {
            if (player.method_18276() && !player.method_37908().method_8608()) {
                class_1799 item = this.getItemStack();
                player.method_6122(interactionHand, item);
                this.inventory.method_5447(0, class_1799.field_8037);
                this.inventory.method_5431();
            }
            return true;
        }
        class_1429 animal = this.getStoredAnimal();
        if (animal == null) {
            return false;
        }
        if (((AnimalPenInterface)animal).animalPenInteract(player, interactionHand, this.method_11016())) {
            class_2487 tag;
            class_1799 item = this.getItemStack();
            try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.method_71402(), AnimalPen.LOGGER);){
                class_11362 valueOutput = class_11362.method_71459((class_8942)scopedCollector, (class_7225.class_7874)animal.method_56673());
                animal.method_5662((class_11372)valueOutput);
                tag = valueOutput.method_71475();
            }
            item.method_57379(class_9334.field_49609, (Object)class_9279.method_57456((class_2487)tag));
            this.inventory.method_5431();
            return true;
        }
        return false;
    }

    public void attackThePen(class_1657 player, class_1937 level) {
        class_1799 weapon = player.method_5998(class_1268.field_5808);
        class_1429 animal = this.getStoredAnimal();
        if (animal == null) {
            return;
        }
        if (!((AnimalPenInterface)animal).animalPenUpdateCount(-1L)) {
            return;
        }
        weapon.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)class_1268.field_5808));
        this.deathTicker.add(0);
        if (((AnimalPenInterface)animal).animalPenGetCount() <= 0L) {
            class_1799 item = this.getItemStack();
            item.method_57381(class_9334.field_49609);
            item.method_57381((class_9331)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
            class_2248.method_9577((class_1937)level, (class_2338)this.method_11016().method_10084(), (class_1799)item);
            this.inventory.method_5447(0, class_1799.field_8037);
        }
        this.triggerUpdate();
        class_243 position = new class_243((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
        class_52 lootTable = level.method_8503().method_58576().method_58295((class_5321)animal.method_5991().get());
        class_8567.class_8568 paramsBuilder = new class_8567.class_8568((class_3218)level).method_51874(class_181.field_24424, (Object)position).method_51874(class_181.field_1226, (Object)animal).method_51874(class_181.field_1230, (Object)player).method_51874(class_181.field_1227, (Object)player).method_51874(class_181.field_1233, (Object)player).method_51874(class_181.field_1231, (Object)level.method_48963().method_48802(player)).method_51871(player.method_7292());
        lootTable.method_51879(paramsBuilder.method_51875(class_173.field_1173), level.method_8409().method_43055()).forEach(itemStack -> class_2248.method_9577((class_1937)level, (class_2338)this.method_11016().method_10084(), (class_1799)itemStack));
        int reward = animal.method_59923((class_3218)level, (class_1297)player);
        class_1303.method_31493((class_3218)((class_3218)this.field_11863), (class_243)position.method_1031(0.5, 1.0, 0.5), (int)reward);
    }

    public int getRedStoneSignal() {
        if (this.getStoredAnimal() == null) {
            return 0;
        }
        return ((AnimalPenInterface)this.storedAnimal).getRedStoneSignal();
    }

    @Override
    public void triggerUpdate() {
        this.method_5431();
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        class_1429 animal = this.getStoredAnimal();
        if (animal != null) {
            class_2487 tag;
            try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.method_71402(), AnimalPen.LOGGER);){
                class_11362 valueOutput = class_11362.method_71459((class_8942)scopedCollector, (class_7225.class_7874)animal.method_56673());
                animal.method_5662((class_11372)valueOutput);
                tag = valueOutput.method_71475();
            }
            this.getItemStack().method_57379(class_9334.field_49609, (Object)class_9279.method_57456((class_2487)tag));
        }
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
    }

    public class_1277 getInventory() {
        return this.inventory;
    }

    private class_1799 getItemStack() {
        return this.inventory.method_5438(0);
    }

    public void method_66473(class_2338 blockPos, class_2680 blockState) {
        if (this.field_11863 != null) {
            class_1264.method_17349((class_1937)this.field_11863, (class_2338)blockPos, (class_2371)this.inventory.method_54454());
        }
    }

    @Override
    public class_2499 getEntityVariants() {
        if (this.getStoredAnimal() == null) {
            return new class_2499();
        }
        return AnimalCageItem.getAnimalVariants(this.getItemStack()).orElseGet(class_2499::new);
    }

    @Override
    public long getAnimalDisplaySize() {
        return this.displaySize < 1L ? this.getAnimalCount() : Math.min(this.displaySize, this.getAnimalCount());
    }

    @Override
    public void setAnimalDisplaySize(long size) {
        this.displaySize = size;
        this.triggerUpdate();
    }

    @Override
    public void updateAnimalVariant(class_11368 animalVariant) {
        if (this.getStoredAnimal() == null || animalVariant == null) {
            return;
        }
        try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.method_71402(), AnimalPen.LOGGER);){
            class_11362 valueOutput = class_11362.method_71459((class_8942)scopedCollector, (class_7225.class_7874)this.field_11863.method_30349());
            ((AnimalPenInterface)this.storedAnimal).animalPenSaveTag((class_11372)valueOutput);
            class_2487 extraData = valueOutput.method_71475();
            this.storedAnimal.method_5651(animalVariant);
            class_11368 valueInput = class_11352.method_71417((class_8942)scopedCollector, (class_7225.class_7874)this.field_11863.method_30349(), (class_2487)extraData);
            ((AnimalPenInterface)this.storedAnimal).animalPenLoadTag(valueInput);
        }
        this.triggerUpdate();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            NetworkManager.sendToPlayers(((class_3218)this.field_11863).method_18456().stream().filter(other -> other.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) < 50.0).toList(), (class_8710)new UpdateVariantScreenData(this.method_11016()));
        }
    }

    @Override
    public void removeAnimalVariant(int index) {
        if (this.getStoredAnimal() == null || this.getEntityVariants().size() <= index) {
            return;
        }
        class_9279 customData = (class_9279)this.getItemStack().method_58694((class_9331)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        if (customData == null) {
            return;
        }
        this.getItemStack().method_57379((class_9331)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get(), (Object)customData.method_57451(tag -> tag.method_10554("animal_variants").ifPresent(list -> list.method_10536(index))));
        this.inventory.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            NetworkManager.sendToPlayers(((class_3218)this.field_11863).method_18456().stream().filter(other -> other.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) < 50.0).toList(), (class_8710)new UpdateVariantScreenData(this.method_11016()));
        }
    }

    @Override
    public long getAnimalCount() {
        return this.getStoredAnimal() == null ? 0L : ((AnimalPenInterface)this.getStoredAnimal()).animalPenGetCount();
    }

    @Override
    public boolean canGrowEntity() {
        return AnimalPen.CONFIG_MANAGER.getConfiguration().isGrowAnimals();
    }

    @Override
    public List<Pair<class_1799[], class_2561>> getCooldownLines(boolean shortText) {
        if (this.getStoredAnimal() == null) {
            return Collections.emptyList();
        }
        return ((AnimalPenInterface)this.storedAnimal).animalPenGetLines(this.getTickCounter(), shortText);
    }
}

