/*
 * Decompiled with CFR 0.152.
 */
package tk.estecka.selfcarehive.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4466;
import net.minecraft.class_4482;
import net.minecraft.class_4844;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Math;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tk.estecka.selfcarehive.BeehiveUtil;
import tk.estecka.selfcarehive.IBeeColonyTracker;
import tk.estecka.selfcarehive.SelfCareHive;

@Unique
@Mixin(value={class_4482.class})
public class BeehiveEntityMixin
extends class_2586
implements IBeeColonyTracker {
    private static final String KNOWNBEES_KEY = "selfcare-hive:KnownBees";
    private static final Codec<Map<UUID, Long>> CODEC = Codec.unboundedMap((Codec)class_4844.field_41525, (Codec)Codec.LONG);
    private final Map<UUID, Long> knownBees = new HashMap<UUID, Long>(4);
    private long elapsedTicks = 0L;

    private BeehiveEntityMixin() {
        super(null, null, null);
    }

    @Shadow
    public int method_23903() {
        throw new AssertionError();
    }

    private void GarbageCollectBees() {
        int maxAbsence = this.method_10997().method_8503().method_3767().method_8356(SelfCareHive.TRACKING_DURATION);
        Iterator<Map.Entry<UUID, Long>> iterator = this.knownBees.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Long> entry = iterator.next();
            long absenceTime = this.elapsedTicks + entry.getValue();
            if (absenceTime < (long)maxAbsence) {
                entry.setValue(absenceTime);
                continue;
            }
            iterator.remove();
            if (!FabricLoader.getInstance().isDevelopmentEnvironment()) continue;
            SelfCareHive.LOGGER.warn("A bee has gone missing: {}", (Object)entry.getKey());
        }
        this.elapsedTicks = 0L;
        int maxKnownBees = Math.max((int)0, (int)(3 - this.method_23903()));
        if (this.knownBees.size() > maxKnownBees) {
            ArrayList<Map.Entry<UUID, Long>> sortedEntries = new ArrayList<Map.Entry<UUID, Long>>(this.knownBees.entrySet());
            sortedEntries.sort((a, b) -> Long.compare((Long)a.getValue(), (Long)b.getValue()));
            for (int i = maxKnownBees; i < sortedEntries.size(); ++i) {
                if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                    SelfCareHive.LOGGER.warn("Superfluous bee was pruned: {}", (Object)sortedEntries.get(i).getKey());
                }
                this.knownBees.remove(sortedEntries.get(i).getKey());
            }
        }
    }

    @Override
    public void selfcarehive$LogColony() {
        StringBuilder string = new StringBuilder();
        string.append("Inside: ").append(this.method_23903()).append(", Outside: ").append(this.knownBees.size());
        for (Map.Entry<UUID, Long> entry : this.knownBees.entrySet()) {
            string.append("\n - ").append(entry.getKey()).append(' ').append(entry.getValue());
        }
        SelfCareHive.LOGGER.info(string.toString());
    }

    @Override
    public boolean selfcarehive$isColonyFull() {
        this.GarbageCollectBees();
        return this.method_23903() + this.knownBees.size() >= 3;
    }

    @Override
    public void selfcarehive$RememberBee(UUID uuid) {
        this.knownBees.put(uuid, 0L);
    }

    @Inject(method={"method_11007(Lnet/minecraft/class_11372;)V"}, at={@At(value="TAIL")})
    private void WriteCustomData(class_11372 view, CallbackInfo ci) {
        if (!this.knownBees.isEmpty()) {
            view.method_71468(KNOWNBEES_KEY, CODEC, this.knownBees);
        }
    }

    @Inject(method={"method_11014(Lnet/minecraft/class_11368;)V"}, at={@At(value="TAIL")})
    private void ReadCustomData(class_11368 view, CallbackInfo ci) {
        view.method_71426(KNOWNBEES_KEY, CODEC).ifPresent(this.knownBees::putAll);
    }

    @Inject(method={"method_31656(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Lnet/minecraft/class_4482;)V"}, at={@At(value="HEAD")})
    private static void tick(class_1937 world, class_2338 pos, class_2680 state, class_4482 blockEntity, CallbackInfo info) {
        ++((BeehiveEntityMixin)blockEntity).elapsedTicks;
    }

    @Inject(require=1, method={"method_21848(Lnet/minecraft/class_4466;)V"}, at={@At(value="TAIL")})
    private void OnBeeEntrance(class_4466 bee, CallbackInfo ci) {
        UUID uuid = bee.method_5667();
        if (FabricLoader.getInstance().isDevelopmentEnvironment() && !this.knownBees.containsKey(uuid)) {
            SelfCareHive.LOGGER.warn("An unknown bee joined the hive: {}", (Object)uuid);
        }
        this.knownBees.remove(uuid);
    }

    @ModifyExpressionValue(method={"method_21855(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Lnet/minecraft/class_4482$class_9309;Ljava/util/List;Lnet/minecraft/class_4482$class_4484;Lnet/minecraft/class_2338;)Z"}, expect=1, at={@At(value="INVOKE", target="Lnet/minecraft/class_4482$class_9309;method_57588(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;)Lnet/minecraft/class_1297;")})
    private static class_1297 OnBeeEntityCreated(class_1297 original, class_1937 world, class_2338 pos, @Local(argsOnly=true) LocalRef<class_2680> stateRef, @Share(value="baby") LocalRef<class_4466> babyRef) {
        if (original instanceof class_4466) {
            class_2586 class_25862;
            class_4466 bee = (class_4466)original;
            if (!world.method_8608() && (class_25862 = world.method_8321(pos)) instanceof class_4482) {
                class_4482 hive = (class_4482)class_25862;
                IBeeColonyTracker colony = IBeeColonyTracker.Of(hive);
                class_2680 hiveState = (class_2680)stateRef.get();
                class_4466 baby = null;
                Pair<class_4466, class_2680> result = BeehiveUtil.TryCreateBaby(bee, colony, (class_3218)world, hiveState, pos);
                baby = (class_4466)result.getLeft();
                hiveState = (class_2680)result.getRight();
                hiveState = BeehiveUtil.TryHeal(bee, world, hiveState, pos);
                colony.selfcarehive$RememberBee(bee.method_5667());
                babyRef.set((Object)baby);
                stateRef.set((Object)hiveState);
            }
        }
        return original;
    }

    @WrapOperation(method={"method_21855(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2680;Lnet/minecraft/class_4482$class_9309;Ljava/util/List;Lnet/minecraft/class_4482$class_4484;Lnet/minecraft/class_2338;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1297;method_5808(DDDFF)V")})
    private static void OnBeePositionUpdated(class_1297 bee, double x, double y, double z, float yaw, float pitch, Operation<Void> original, @Share(value="baby") LocalRef<class_4466> baby) {
        class_4466 babyEntity = (class_4466)baby.get();
        if (babyEntity != null) {
            babyEntity.method_5808(x, y, z, yaw, pitch);
            babyEntity.method_37908().method_8649((class_1297)babyEntity);
        }
        original.call(new Object[]{bee, x, y, z, Float.valueOf(yaw), Float.valueOf(pitch)});
    }

    @ModifyArg(require=1, method={"method_21848(Lnet/minecraft/class_4466;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_4482;method_35292(Lnet/minecraft/class_4482$class_9309;)V"))
    private class_4482.class_9309 ReduceExitDelay(class_4482.class_9309 original) {
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            return original;
        }
        return new class_4482.class_9309(original.comp_2431(), 0, 20);
    }
}

