local handMirror = (bl and 1) or -1

global.inspectSquish = 1.0;
global.inspectSquishInvert = 1.0;
global.squishInPlayed = false;
global.squishOutPlayed = false;



if I:isOf(item, Items:get("minecraft:bucket"))
or I:isOf(item, Items:get("minecraft:water_bucket"))
or I:isOf(item, Items:get("minecraft:cod_bucket"))
or I:isOf(item, Items:get("minecraft:salmon_bucket"))
or I:isOf(item, Items:get("minecraft:tropical_fish_bucket"))
or I:isOf(item, Items:get("minecraft:pufferfish_bucket"))
or I:isOf(item, Items:get("minecraft:tadpole_bucket"))
or I:isOf(item, Items:get("minecraft:lava_bucket"))
or I:isOf(item, Items:get("minecraft:powder_snow_bucket"))
or I:isOf(item, Items:get("minecraft:milk_bucket")) then
	M:moveZ(matrices, -0.1)
	M:moveY(matrices, -0.05)
    M:rotateX(matrices, 70)
    M:rotateY(matrices, 180 * handMirror)
    M:rotateZ(matrices, -30 * handMirror)
end

if I:isOf(item, Items:get("minecraft:axolotl_bucket")) then
	M:moveZ(matrices, -0.1)
	M:moveY(matrices, -0.05)
	M:rotateX(matrices, 65)
	M:rotateY(matrices, 170 * handMirror)
	M:rotateZ(matrices, -25 * handMirror)
end

if I:isOf(item, Items:get("minecraft:lava_bucket")) then
	particleManager:addParticle(particles,
	false,
	0, --posX
	0, --posY
	0.12, --posZ
	0, --deltaPosX
	0, --deltaPosY
	0, --deltaPosZ
	0, --rotX
	0, --rotY
	0, --rotZ
	0, --deltaRotX
	0, --deltaRotY
	0, --deltaRotZ
	1.9, --size
	Texture:of("minecraft", "textures/particle/orange_glow.png"), "ITEM", hand, "SPAWN", "ADDITIVE", 0, 200 + (20 * M:sin(P:getAge(player) * 0.2)))
end

if not I:isEmpty(item) then
	local customName = I:getComponents(item):get("minecraft:custom_name")
	if customName ~= nil then
		if customName:getAsString() == "Herobrine" and I:isOf(item, Items:get("minecraft:bucket")) then
			if math.random(10000) == 3 then
				S:playSound("ambient.cave", 0.2 * ${sfxVolume})
			end
			
			if KeyBindManager:isKeyPressed(${inspectKeybind}) then
				inspectSquish = inspectSquish - 0.4 * deltaTime * 2
				inspectSquishInvert = inspectSquishInvert + 0.4 * deltaTime * 2
				
				if not squishInPlayed then
					S:playSound("maing_buckets.squeak_in", 1 * ${sfxVolume})
					squishInPlayed = true
				end
				squishOutPlayed = false
			else
				inspectSquish = inspectSquish + 0.4 * deltaTime * 2
				inspectSquishInvert = inspectSquishInvert - 0.4 * deltaTime * 2
				
				if not squishOutPlayed then
					S:playSound("maing_buckets.squeak_out", 1 * ${sfxVolume})
					squishOutPlayed = true
				end
				squishInPlayed = false
			end
			inspectSquish = M:clamp(inspectSquish, 0.9, 1)
			inspectSquishInvert = M:clamp(inspectSquishInvert, 1, 1.1)
			
			M:scale(matrices, Easings:easeInCubic(inspectSquishInvert), Easings:easeInCubic(inspectSquishInvert), Easings:easeInCubic(inspectSquish))
		end
	end
end