/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BasePath<B extends BasePath<B>>
implements Comparable<B> {
    abstract ImmutableList<String> getSegments();

    @Nullable
    B getParent() {
        ImmutableList<String> parts = this.getSegments();
        if (parts.isEmpty()) {
            return null;
        }
        return this.createPathWithSegments((ImmutableList<String>)parts.subList(0, parts.size() - 1));
    }

    B append(String path) {
        return this.append(path, true);
    }

    B append(String path, boolean splitPath) {
        Preconditions.checkArgument(path != null && !path.isEmpty(), "'path' must be a non-empty String");
        ImmutableList.Builder components = ImmutableList.builder();
        components.addAll(this.getSegments());
        if (splitPath) {
            components.add(this.splitChildPath(path));
        } else {
            components.add(path);
        }
        return this.createPathWithSegments((ImmutableList<String>)components.build());
    }

    B append(BasePath<B> path) {
        ImmutableList.Builder components = ImmutableList.builder();
        components.addAll(this.getSegments());
        components.addAll(path.getSegments());
        return this.createPathWithSegments((ImmutableList<String>)components.build());
    }

    boolean isPrefixOf(BasePath<B> path) {
        ImmutableList<String> prefixSegments = this.getSegments();
        ImmutableList<String> childSegments = path.getSegments();
        if (prefixSegments.size() > path.getSegments().size()) {
            return false;
        }
        for (int i = 0; i < prefixSegments.size(); ++i) {
            if (((String)prefixSegments.get(i)).equals(childSegments.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(@Nonnull B other) {
        int length = Math.min(this.getSegments().size(), ((BasePath)other).getSegments().size());
        for (int i = 0; i < length; ++i) {
            int cmp = ((String)this.getSegments().get(i)).compareTo((String)((BasePath)other).getSegments().get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(this.getSegments().size(), ((BasePath)other).getSegments().size());
    }

    int size() {
        return this.getSegments().size();
    }

    abstract String[] splitChildPath(String var1);

    abstract B createPathWithSegments(ImmutableList<String> var1);
}

