/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.Blob;
import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.GeoPoint;
import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.UserDataConverter;
import com.google.common.base.Preconditions;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.Value;
import com.google.firestore.v1.Write;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
public class DocumentSnapshot {
    private final FirestoreRpcContext<?> rpcContext;
    private final DocumentReference docRef;
    @Nullable
    private final Map<String, Value> fields;
    @Nullable
    private final Timestamp readTime;
    @Nullable
    private final Timestamp updateTime;
    @Nullable
    private final Timestamp createTime;

    DocumentSnapshot(FirestoreRpcContext<?> rpcContext, DocumentReference docRef, @Nullable Map<String, Value> fields, @Nullable Timestamp readTime, @Nullable Timestamp updateTime, @Nullable Timestamp createTime) {
        this.rpcContext = rpcContext;
        this.docRef = docRef;
        this.fields = fields;
        this.readTime = readTime;
        this.updateTime = updateTime;
        this.createTime = createTime;
    }

    @Nonnull
    public String getId() {
        return this.docRef.getId();
    }

    static DocumentSnapshot fromObject(FirestoreRpcContext<?> rpcContext, DocumentReference docRef, Map<String, Object> values, UserDataConverter.EncodingOptions options) {
        HashMap<String, Value> fields = new HashMap<String, Value>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Value encodedValue = UserDataConverter.encodeValue(FieldPath.of(entry.getKey()), CustomClassMapper.convertToPlainJavaTypes(entry.getValue()), options);
            if (encodedValue == null) continue;
            fields.put(entry.getKey(), encodedValue);
        }
        return new DocumentSnapshot(rpcContext, docRef, fields, null, null, null);
    }

    static DocumentSnapshot fromDocument(FirestoreRpcContext<?> rpcContext, Timestamp readTime, Document document) {
        return new DocumentSnapshot(rpcContext, new DocumentReference(rpcContext, ResourcePath.create(document.getName())), document.getFieldsMap(), readTime, Timestamp.fromProto(document.getUpdateTime()), Timestamp.fromProto(document.getCreateTime()));
    }

    static DocumentSnapshot fromMissing(FirestoreRpcContext<?> rpcContext, DocumentReference documentReference, Timestamp readTime) {
        return new DocumentSnapshot(rpcContext, documentReference, null, readTime, null, null);
    }

    @Nullable
    public Timestamp getReadTime() {
        return this.readTime;
    }

    @Nullable
    public Timestamp getUpdateTime() {
        return this.updateTime;
    }

    @Nullable
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public boolean exists() {
        return this.fields != null;
    }

    @Nullable
    public Map<String, Object> getData() {
        if (this.fields == null) {
            return null;
        }
        HashMap<String, Object> decodedFields = new HashMap<String, Object>();
        for (Map.Entry<String, Value> entry : this.fields.entrySet()) {
            Object decodedValue = UserDataConverter.decodeValue(this.rpcContext, entry.getValue());
            decodedFields.put(entry.getKey(), decodedValue);
        }
        return decodedFields;
    }

    @Nullable
    public <T> T toObject(@Nonnull Class<T> valueType) {
        Map<String, Object> data = this.getData();
        return data == null ? null : (T)CustomClassMapper.convertToCustomClass(data, valueType, this.docRef);
    }

    public boolean contains(@Nonnull String field) {
        return this.contains(FieldPath.fromDotSeparatedString(field));
    }

    public boolean contains(@Nonnull FieldPath fieldPath) {
        return this.extractField(fieldPath) != null;
    }

    @Nullable
    public Object get(@Nonnull String field) {
        return this.get(FieldPath.fromDotSeparatedString(field));
    }

    @Nullable
    public <T> T get(@Nonnull String field, @Nonnull Class<T> valueType) {
        return this.get(FieldPath.fromDotSeparatedString(field), valueType);
    }

    @Nullable
    public Object get(@Nonnull FieldPath fieldPath) {
        Value value = this.extractField(fieldPath);
        if (value == null) {
            return null;
        }
        return UserDataConverter.decodeValue(this.rpcContext, value);
    }

    @Nullable
    public <T> T get(@Nonnull FieldPath fieldPath, Class<T> valueType) {
        Object data = this.get(fieldPath);
        return data == null ? null : (T)CustomClassMapper.convertToCustomClass(data, valueType, this.docRef);
    }

    @Nullable
    Value extractField(@Nonnull FieldPath fieldPath) {
        Value value = null;
        if (this.fields != null) {
            Iterator components = fieldPath.getSegments().iterator();
            value = this.fields.get(components.next());
            while (value != null && components.hasNext()) {
                if (value.getValueTypeCase() != Value.ValueTypeCase.MAP_VALUE) {
                    return null;
                }
                value = value.getMapValue().getFieldsOrDefault((String)components.next(), null);
            }
        }
        return value;
    }

    @Nullable
    public Boolean getBoolean(@Nonnull String field) {
        return (Boolean)this.get(field);
    }

    @Nullable
    public Double getDouble(@Nonnull String field) {
        Number number = (Number)this.get(field);
        return number == null ? null : Double.valueOf(number.doubleValue());
    }

    @Nullable
    public String getString(@Nonnull String field) {
        return (String)this.get(field);
    }

    @Nullable
    public Long getLong(@Nonnull String field) {
        Number number = (Number)this.get(field);
        return number == null ? null : Long.valueOf(number.longValue());
    }

    @Nullable
    public Date getDate(@Nonnull String field) {
        Timestamp timestamp = this.getTimestamp(field);
        return timestamp == null ? null : timestamp.toDate();
    }

    @Nullable
    public Timestamp getTimestamp(@Nonnull String field) {
        return (Timestamp)this.get(field);
    }

    @Nullable
    public Blob getBlob(@Nonnull String field) {
        return (Blob)this.get(field);
    }

    @Nullable
    public GeoPoint getGeoPoint(@Nonnull String field) {
        return (GeoPoint)this.get(field);
    }

    @Nonnull
    public DocumentReference getReference() {
        return this.docRef;
    }

    boolean isEmpty() {
        return this.fields == null || this.fields.isEmpty();
    }

    Map<String, Value> getProtoFields() {
        return this.fields;
    }

    Write.Builder toPb() {
        Preconditions.checkState(this.exists(), "Can't call toDocument() on a document that doesn't exist");
        Write.Builder write = Write.newBuilder();
        Document.Builder document = write.getUpdateBuilder();
        document.setName(this.docRef.getName());
        document.putAllFields(this.fields);
        return write;
    }

    Document.Builder toDocumentPb() {
        Preconditions.checkState(this.exists(), "Can't call toDocument() on a document that doesn't exist");
        Document.Builder document = Document.newBuilder();
        return document.setName(this.docRef.getName()).putAllFields(this.fields).setCreateTime(this.createTime.toProto()).setUpdateTime(this.updateTime.toProto());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DocumentSnapshot)) {
            return false;
        }
        DocumentSnapshot that = (DocumentSnapshot)obj;
        return Objects.equals(this.rpcContext, that.rpcContext) && Objects.equals(this.docRef, that.docRef) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.rpcContext, this.docRef, this.fields);
    }

    public String toString() {
        return String.format("%s{doc=%s, fields=%s, readTime=%s, updateTime=%s, createTime=%s}", this.getClass().getSimpleName(), this.docRef, this.fields, this.readTime, this.updateTime, this.createTime);
    }
}

