/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.internal.Utils;
import com.google.firebase.internal.EmulatorCredentials;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.NonNull;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;

public final class ImplFirebaseTrampolines {
    private ImplFirebaseTrampolines() {
    }

    public static GoogleCredentials getCredentials(@NonNull FirebaseApp app) {
        if (Utils.isEmulatorMode()) {
            return new EmulatorCredentials();
        }
        return app.getOptions().getCredentials();
    }

    public static String getProjectId(@NonNull FirebaseApp app) {
        return app.getProjectId();
    }

    public static FirestoreOptions getFirestoreOptions(@NonNull FirebaseApp app) {
        return app.getOptions().getFirestoreOptions();
    }

    public static boolean isDefaultApp(@NonNull FirebaseApp app) {
        return app.isDefaultApp();
    }

    public static <T extends FirebaseService> T getService(@NonNull FirebaseApp app, @NonNull String id, @NonNull Class<T> type) {
        return (T)((FirebaseService)type.cast(app.getService(id)));
    }

    public static <T extends FirebaseService> T addService(@NonNull FirebaseApp app, @NonNull T service) {
        app.addService(service);
        return service;
    }

    public static ThreadFactory getThreadFactory(@NonNull FirebaseApp app) {
        return app.getThreadFactory();
    }

    public static <V, X> ApiFuture<X> transform(ApiFuture<? extends V> input, ApiFunction<? super V, ? extends X> function, @NonNull FirebaseApp app) {
        return ApiFutures.transform(input, function, app.getScheduledExecutorService());
    }

    public static <V, X> ApiFuture<X> transformAsync(ApiFuture<V> input, ApiAsyncFunction<V, X> function, @NonNull FirebaseApp app) {
        return ApiFutures.transformAsync(input, function, app.getScheduledExecutorService());
    }

    public static ScheduledFuture<?> schedule(@NonNull FirebaseApp app, @NonNull Runnable runnable, long delayMillis) {
        return app.schedule(runnable, delayMillis);
    }

    public static <T> ApiFuture<T> submitCallable(@NonNull FirebaseApp app, @NonNull Callable<T> command) {
        return app.submit(command);
    }

    public static void startTokenRefresher(@NonNull FirebaseApp app) {
        app.startTokenRefresher();
    }
}

