/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.auth.ProviderConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SamlProviderConfig
extends ProviderConfig {
    @Key(value="idpConfig")
    private GenericJson idpConfig;
    @Key(value="spConfig")
    private GenericJson spConfig;

    public String getIdpEntityId() {
        return (String)this.idpConfig.get("idpEntityId");
    }

    public String getSsoUrl() {
        return (String)this.idpConfig.get("ssoUrl");
    }

    public List<String> getX509Certificates() {
        List idpCertificates = (List)this.idpConfig.get("idpCertificates");
        Preconditions.checkNotNull(idpCertificates);
        ImmutableList.Builder certificates = ImmutableList.builder();
        for (Map idpCertificate : idpCertificates) {
            certificates.add(idpCertificate.get("x509Certificate"));
        }
        return certificates.build();
    }

    public String getRpEntityId() {
        return (String)this.spConfig.get("spEntityId");
    }

    public String getCallbackUrl() {
        return (String)this.spConfig.get("callbackUri");
    }

    public UpdateRequest updateRequest() {
        return new UpdateRequest(this.getProviderId());
    }

    static void checkSamlProviderId(String providerId) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(providerId), "Provider ID must not be null or empty.");
        Preconditions.checkArgument(providerId.startsWith("saml."), "Invalid SAML provider ID (must be prefixed with 'saml.'): " + providerId);
    }

    private static List<Object> ensureNestedList(Map<String, Object> outerMap, String id) {
        ArrayList list = (ArrayList)outerMap.get(id);
        if (list == null) {
            list = new ArrayList();
            outerMap.put(id, list);
        }
        return list;
    }

    private static Map<String, Object> ensureNestedMap(Map<String, Object> outerMap, String id) {
        HashMap map = (HashMap)outerMap.get(id);
        if (map == null) {
            map = new HashMap();
            outerMap.put(id, map);
        }
        return map;
    }

    public static final class UpdateRequest
    extends ProviderConfig.AbstractUpdateRequest<UpdateRequest> {
        public UpdateRequest(String providerId) {
            super(providerId);
            SamlProviderConfig.checkSamlProviderId(providerId);
        }

        public UpdateRequest setIdpEntityId(String idpEntityId) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(idpEntityId), "IDP entity ID must not be null or empty.");
            SamlProviderConfig.ensureNestedMap(this.properties, "idpConfig").put("idpEntityId", idpEntityId);
            return this;
        }

        public UpdateRequest setSsoUrl(String ssoUrl) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(ssoUrl), "SSO URL must not be null or empty.");
            ProviderConfig.assertValidUrl(ssoUrl);
            SamlProviderConfig.ensureNestedMap(this.properties, "idpConfig").put("ssoUrl", ssoUrl);
            return this;
        }

        public UpdateRequest addX509Certificate(String x509Certificate) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(x509Certificate), "The x509 certificate must not be null or empty.");
            Map idpConfigProperties = SamlProviderConfig.ensureNestedMap(this.properties, "idpConfig");
            List x509Certificates = SamlProviderConfig.ensureNestedList(idpConfigProperties, "idpCertificates");
            x509Certificates.add(ImmutableMap.of("x509Certificate", x509Certificate));
            return this;
        }

        public UpdateRequest addAllX509Certificates(Collection<String> x509Certificates) {
            Preconditions.checkArgument(x509Certificates != null, "The collection of x509 certificates must not be null.");
            Preconditions.checkArgument(!x509Certificates.isEmpty(), "The collection of x509 certificates must not be empty.");
            for (String certificate : x509Certificates) {
                this.addX509Certificate(certificate);
            }
            return this;
        }

        public UpdateRequest setRpEntityId(String rpEntityId) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(rpEntityId), "RP entity ID must not be null or empty.");
            SamlProviderConfig.ensureNestedMap(this.properties, "spConfig").put("spEntityId", rpEntityId);
            return this;
        }

        public UpdateRequest setCallbackUrl(String callbackUrl) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(callbackUrl), "Callback URL must not be null or empty.");
            ProviderConfig.assertValidUrl(callbackUrl);
            SamlProviderConfig.ensureNestedMap(this.properties, "spConfig").put("callbackUri", callbackUrl);
            return this;
        }

        @Override
        UpdateRequest getThis() {
            return this;
        }
    }

    public static final class CreateRequest
    extends ProviderConfig.AbstractCreateRequest<CreateRequest> {
        @Override
        public CreateRequest setProviderId(String providerId) {
            SamlProviderConfig.checkSamlProviderId(providerId);
            return (CreateRequest)super.setProviderId(providerId);
        }

        public CreateRequest setIdpEntityId(String idpEntityId) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(idpEntityId), "IDP entity ID must not be null or empty.");
            SamlProviderConfig.ensureNestedMap(this.properties, "idpConfig").put("idpEntityId", idpEntityId);
            return this;
        }

        public CreateRequest setSsoUrl(String ssoUrl) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(ssoUrl), "SSO URL must not be null or empty.");
            ProviderConfig.assertValidUrl(ssoUrl);
            SamlProviderConfig.ensureNestedMap(this.properties, "idpConfig").put("ssoUrl", ssoUrl);
            return this;
        }

        public CreateRequest addX509Certificate(String x509Certificate) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(x509Certificate), "The x509 certificate must not be null or empty.");
            Map idpConfigProperties = SamlProviderConfig.ensureNestedMap(this.properties, "idpConfig");
            List x509Certificates = SamlProviderConfig.ensureNestedList(idpConfigProperties, "idpCertificates");
            x509Certificates.add(ImmutableMap.of("x509Certificate", x509Certificate));
            return this;
        }

        public CreateRequest addAllX509Certificates(Collection<String> x509Certificates) {
            Preconditions.checkArgument(x509Certificates != null, "The collection of x509 certificates must not be null.");
            Preconditions.checkArgument(!x509Certificates.isEmpty(), "The collection of x509 certificates must not be empty.");
            for (String certificate : x509Certificates) {
                this.addX509Certificate(certificate);
            }
            return this;
        }

        public CreateRequest setRpEntityId(String rpEntityId) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(rpEntityId), "RP entity ID must not be null or empty.");
            SamlProviderConfig.ensureNestedMap(this.properties, "spConfig").put("spEntityId", rpEntityId);
            return this;
        }

        public CreateRequest setCallbackUrl(String callbackUrl) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(callbackUrl), "Callback URL must not be null or empty.");
            ProviderConfig.assertValidUrl(callbackUrl);
            SamlProviderConfig.ensureNestedMap(this.properties, "spConfig").put("callbackUri", callbackUrl);
            return this;
        }

        @Override
        CreateRequest getThis() {
            return this;
        }
    }
}

