/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.multitenancy;

import com.google.api.gax.paging.Page;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.internal.ListTenantsResponse;
import com.google.firebase.auth.multitenancy.FirebaseTenantClient;
import com.google.firebase.auth.multitenancy.Tenant;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ListTenantsPage
implements Page<Tenant> {
    static final String END_OF_LIST = "";
    private final ListTenantsResponse currentBatch;
    private final TenantSource source;
    private final int maxResults;

    private ListTenantsPage(@NonNull ListTenantsResponse currentBatch, @NonNull TenantSource source, int maxResults) {
        this.currentBatch = Preconditions.checkNotNull(currentBatch);
        this.source = Preconditions.checkNotNull(source);
        this.maxResults = maxResults;
    }

    @Override
    public boolean hasNextPage() {
        return !END_OF_LIST.equals(this.currentBatch.getPageToken());
    }

    @Override
    @NonNull
    public String getNextPageToken() {
        return this.currentBatch.getPageToken();
    }

    @Nullable
    public ListTenantsPage getNextPage() {
        if (this.hasNextPage()) {
            PageFactory factory = new PageFactory(this.source, this.maxResults, this.currentBatch.getPageToken());
            try {
                return factory.create();
            }
            catch (FirebaseAuthException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    @NonNull
    public Iterable<Tenant> iterateAll() {
        return new TenantIterable(this);
    }

    @Override
    @NonNull
    public Iterable<Tenant> getValues() {
        return this.currentBatch.getTenants();
    }

    static class PageFactory {
        private final TenantSource source;
        private final int maxResults;
        private final String pageToken;

        PageFactory(@NonNull TenantSource source) {
            this(source, 100, null);
        }

        PageFactory(@NonNull TenantSource source, int maxResults, @Nullable String pageToken) {
            Preconditions.checkArgument(maxResults > 0 && maxResults <= 100, "maxResults must be a positive integer that does not exceed %s", 100);
            Preconditions.checkArgument(!ListTenantsPage.END_OF_LIST.equals(pageToken), "Invalid end of list page token.");
            this.source = Preconditions.checkNotNull(source, "Source must not be null.");
            this.maxResults = maxResults;
            this.pageToken = pageToken;
        }

        ListTenantsPage create() throws FirebaseAuthException {
            ListTenantsResponse batch = this.source.fetch(this.maxResults, this.pageToken);
            return new ListTenantsPage(batch, this.source, this.maxResults);
        }
    }

    static class DefaultTenantSource
    implements TenantSource {
        private final FirebaseTenantClient tenantClient;

        DefaultTenantSource(FirebaseTenantClient tenantClient) {
            this.tenantClient = Preconditions.checkNotNull(tenantClient, "Tenant client must not be null.");
        }

        @Override
        public ListTenantsResponse fetch(int maxResults, String pageToken) throws FirebaseAuthException {
            return this.tenantClient.listTenants(maxResults, pageToken);
        }
    }

    static interface TenantSource {
        @NonNull
        public ListTenantsResponse fetch(int var1, String var2) throws FirebaseAuthException;
    }

    private static class TenantIterable
    implements Iterable<Tenant> {
        private final ListTenantsPage startingPage;

        TenantIterable(@NonNull ListTenantsPage startingPage) {
            this.startingPage = Preconditions.checkNotNull(startingPage, "starting page must not be null");
        }

        @Override
        @NonNull
        public Iterator<Tenant> iterator() {
            return new TenantIterator(this.startingPage);
        }

        private static class TenantIterator
        implements Iterator<Tenant> {
            private ListTenantsPage currentPage;
            private List<Tenant> batch;
            private int index = 0;

            private TenantIterator(ListTenantsPage startingPage) {
                this.setCurrentPage(startingPage);
            }

            @Override
            public boolean hasNext() {
                if (this.index == this.batch.size()) {
                    if (this.currentPage.hasNextPage()) {
                        this.setCurrentPage(this.currentPage.getNextPage());
                    } else {
                        return false;
                    }
                }
                return this.index < this.batch.size();
            }

            @Override
            public Tenant next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.batch.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove operation not supported");
            }

            private void setCurrentPage(ListTenantsPage page) {
                this.currentPage = Preconditions.checkNotNull(page);
                this.batch = ImmutableList.copyOf(page.getValues());
                this.index = 0;
            }
        }
    }
}

