/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.remoteconfig.ParameterValue;
import com.google.firebase.remoteconfig.ParameterValueType;
import com.google.firebase.remoteconfig.internal.TemplateResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class Parameter {
    private ParameterValue defaultValue;
    private String description;
    private Map<String, ParameterValue> conditionalValues;
    private ParameterValueType valueType;

    public Parameter() {
        this.conditionalValues = new HashMap<String, ParameterValue>();
    }

    Parameter(@NonNull TemplateResponse.ParameterResponse parameterResponse) {
        TemplateResponse.ParameterValueResponse responseDefaultValue;
        Preconditions.checkNotNull(parameterResponse);
        this.conditionalValues = new HashMap<String, ParameterValue>();
        if (parameterResponse.getConditionalValues() != null) {
            for (Map.Entry<String, TemplateResponse.ParameterValueResponse> entry : parameterResponse.getConditionalValues().entrySet()) {
                this.conditionalValues.put(entry.getKey(), ParameterValue.fromParameterValueResponse(entry.getValue()));
            }
        }
        this.defaultValue = (responseDefaultValue = parameterResponse.getDefaultValue()) == null ? null : ParameterValue.fromParameterValueResponse(responseDefaultValue);
        this.description = parameterResponse.getDescription();
        if (!Strings.isNullOrEmpty(parameterResponse.getValueType())) {
            this.valueType = ParameterValueType.valueOf(parameterResponse.getValueType());
        }
    }

    @Nullable
    public ParameterValue getDefaultValue() {
        return this.defaultValue;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public Map<String, ParameterValue> getConditionalValues() {
        return this.conditionalValues;
    }

    @Nullable
    public ParameterValueType getValueType() {
        return this.valueType;
    }

    public Parameter setDefaultValue(@Nullable ParameterValue value) {
        this.defaultValue = value;
        return this;
    }

    public Parameter setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public Parameter setConditionalValues(@NonNull Map<String, ParameterValue> conditionalValues) {
        Preconditions.checkNotNull(conditionalValues, "conditional values must not be null.");
        this.conditionalValues = conditionalValues;
        return this;
    }

    public Parameter setValueType(@Nullable ParameterValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    TemplateResponse.ParameterResponse toParameterResponse() {
        HashMap<String, TemplateResponse.ParameterValueResponse> conditionalResponseValues = new HashMap<String, TemplateResponse.ParameterValueResponse>();
        for (Map.Entry<String, ParameterValue> entry : this.conditionalValues.entrySet()) {
            conditionalResponseValues.put(entry.getKey(), entry.getValue().toParameterValueResponse());
        }
        TemplateResponse.ParameterValueResponse defaultValueResponse = this.defaultValue == null ? null : this.defaultValue.toParameterValueResponse();
        return new TemplateResponse.ParameterResponse().setDefaultValue(defaultValueResponse).setDescription(this.description).setConditionalValues(conditionalResponseValues).setValueType(this.valueType == null ? null : this.valueType.getValueType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        return Objects.equals(this.defaultValue, parameter.defaultValue) && Objects.equals(this.description, parameter.description) && Objects.equals(this.conditionalValues, parameter.conditionalValues) && Objects.equals((Object)this.valueType, (Object)parameter.valueType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.defaultValue, this.description, this.conditionalValues, this.valueType});
    }
}

