/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.PlayerMessages;

public class EnderChestCommand
implements CommandExecutor {
    private final PlayerMessages messages = ServerEssentials.getInstance().getPlayerMessages();

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("EnderChest.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            if (!player.hasPermission("serveressentials.enderchest")) {
                player.sendMessage(this.messages.get("EnderChest.no-permission", new String[0]));
                return true;
            }
            player.sendMessage(this.messages.get("EnderChest.opening", new String[0]));
            player.openInventory(player.getEnderChest());
            return true;
        }
        if (args.length == 1) {
            if (!player.hasPermission("serveressentials.enderchest.others")) {
                player.sendMessage(this.messages.get("EnderChest.no-permission-others", new String[0]));
                return true;
            }
            Player target = Bukkit.getPlayerExact((String)args[0]);
            if (target != null && target.isOnline()) {
                String msg = PlainTextComponentSerializer.plainText().serialize(this.messages.get("EnderChest.opening-other", new String[0]));
                msg = msg.replace("%player%", target.getName());
                player.sendMessage((Component)Component.text(msg));
                player.openInventory(target.getEnderChest());
                return true;
            }
            OfflinePlayer offline = Bukkit.getOfflinePlayer((String)args[0]);
            if (offline == null || !offline.hasPlayedBefore()) {
                String msg = PlainTextComponentSerializer.plainText().serialize(this.messages.get("EnderChest.player-not-found", new String[0]));
                msg = msg.replace("%player%", args[0]);
                player.sendMessage((Component)Component.text(msg));
                return true;
            }
            player.sendMessage(this.messages.get("EnderChest.offline-not-supported", new String[0]));
            return true;
        }
        player.sendMessage(this.messages.get("EnderChest.usage", new String[0]));
        return true;
    }
}

