/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.PlayerMessages;

public class NotesCommand
implements CommandExecutor,
TabCompleter {
    private final Map<UUID, Map<String, String>> playerNotes = new HashMap<UUID, Map<String, String>>();
    private final PlayerMessages messages;
    private final ServerEssentials plugin;
    private final File notesFile;
    private FileConfiguration notesConfig;

    public NotesCommand(PlayerMessages messages, ServerEssentials plugin) {
        this.messages = messages;
        this.plugin = plugin;
        this.notesFile = new File(plugin.getDataFolder(), "storage/notes.yml");
        if (!this.notesFile.getParentFile().exists()) {
            this.notesFile.getParentFile().mkdirs();
        }
        if (!this.notesFile.exists()) {
            try {
                this.notesFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.notesConfig = YamlConfiguration.loadConfiguration((File)this.notesFile);
        this.loadNotes();
    }

    private void loadNotes() {
        for (String uuidStr : this.notesConfig.getKeys(false)) {
            UUID uuid = UUID.fromString(uuidStr);
            HashMap<String, String> notes = new HashMap<String, String>();
            for (String noteName : this.notesConfig.getConfigurationSection(uuidStr).getKeys(false)) {
                notes.put(noteName, this.notesConfig.getString(uuidStr + "." + noteName));
            }
            this.playerNotes.put(uuid, notes);
        }
    }

    public void saveNotes() {
        for (UUID uuid : this.playerNotes.keySet()) {
            for (Map.Entry<String, String> entry : this.playerNotes.get(uuid).entrySet()) {
                this.notesConfig.set(uuid.toString() + "." + entry.getKey(), (Object)entry.getValue());
            }
        }
        try {
            this.notesConfig.save(this.notesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            Component msg = this.messages.get("notes.only-players", new String[0]);
            sender.sendMessage(msg);
            return true;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        this.playerNotes.putIfAbsent(uuid, new HashMap());
        Map<String, String> notes = this.playerNotes.get(uuid);
        if (args.length == 1) {
            if (!player.hasPermission("serveressentials.note.read")) {
                Component msg = this.messages.get("notes.no-permission-read", new String[0]);
                player.sendMessage(msg);
                return true;
            }
            String noteName = args[0].toLowerCase();
            if (notes.containsKey(noteName)) {
                String content = notes.get(noteName);
                Component msg = this.messages.get("notes.view", "<name>", noteName, "<content>", content);
                player.sendMessage(msg);
            } else {
                Component msg = this.messages.get("notes.not-found", "<name>", noteName);
                player.sendMessage(msg);
            }
            return true;
        }
        if (args.length >= 2) {
            if (!player.hasPermission("serveressentials.note.write")) {
                Component msg = this.messages.get("notes.no-permission-write", new String[0]);
                player.sendMessage(msg);
                return true;
            }
            String noteName = args[0].toLowerCase();
            String noteContent = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            notes.put(noteName, noteContent);
            Component msg = this.messages.get("notes.saved", "<name>", noteName, "<content>", noteContent);
            player.sendMessage(msg);
            this.saveNotes();
            return true;
        }
        player.sendMessage(this.messages.get("notes.usage-header", new String[0]));
        if (player.hasPermission("serveressentials.note.write")) {
            player.sendMessage(this.messages.get("notes.usage-add", new String[0]));
        }
        if (player.hasPermission("serveressentials.note.read")) {
            player.sendMessage(this.messages.get("notes.usage-view", new String[0]));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        Map notes = this.playerNotes.getOrDefault(uuid, Collections.emptyMap());
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            ArrayList<String> completions = new ArrayList<String>();
            if (player.hasPermission("serveressentials.note.read")) {
                for (String noteName : notes.keySet()) {
                    if (!noteName.startsWith(input)) continue;
                    completions.add(noteName);
                }
            }
            return completions;
        }
        return List.of();
    }
}

