/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.economy;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class EconomyManager
implements Economy {
    private static final Map<UUID, Double> balances = new HashMap<UUID, Double>();
    private static File file;
    private static FileConfiguration config;

    public static void loadBalances(File dataFolder) {
        File storageFolder = new File(dataFolder, "storage");
        if (!storageFolder.exists()) {
            storageFolder.mkdirs();
        }
        if (!(file = new File(storageFolder, "balances.yml")).exists()) {
            try {
                file.createNewFile();
                Bukkit.getLogger().info("[EconomyManager] Created new storage/balances.yml file.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        config = YamlConfiguration.loadConfiguration((File)file);
        for (String key : config.getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(key);
                double balance = config.getDouble(key);
                balances.put(uuid, balance);
            }
            catch (IllegalArgumentException ignored) {
                Bukkit.getLogger().warning("[EconomyManager] Invalid UUID in balances.yml: " + key);
            }
        }
    }

    public static void saveBalances() {
        if (config == null || file == null) {
            return;
        }
        for (Map.Entry<UUID, Double> entry : balances.entrySet()) {
            config.set(entry.getKey().toString(), (Object)entry.getValue());
        }
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private double get(UUID uuid) {
        return balances.getOrDefault(uuid, 0.0);
    }

    private void set(UUID uuid, double amount) {
        balances.put(uuid, amount);
        EconomyManager.saveBalances();
    }

    private void add(UUID uuid, double amount) {
        this.set(uuid, this.get(uuid) + amount);
    }

    private void take(UUID uuid, double amount) {
        this.set(uuid, Math.max(0.0, this.get(uuid) - amount));
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return "ServerEssentialsEconomy";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return 2;
    }

    public String format(double amount) {
        return String.format("$%.2f", amount);
    }

    public String currencyNamePlural() {
        return "Dollars";
    }

    public String currencyNameSingular() {
        return "Dollar";
    }

    public boolean hasAccount(String s2) {
        return false;
    }

    public boolean hasAccount(OfflinePlayer player) {
        return true;
    }

    public boolean hasAccount(String s2, String s1) {
        return false;
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer, String s2) {
        return false;
    }

    public double getBalance(String s2) {
        return 0.0;
    }

    public double getBalance(OfflinePlayer player) {
        return this.get(player.getUniqueId());
    }

    public double getBalance(String s2, String s1) {
        return 0.0;
    }

    public double getBalance(OfflinePlayer offlinePlayer, String s2) {
        return 0.0;
    }

    public boolean has(String s2, double v) {
        return false;
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.get(player.getUniqueId()) >= amount;
    }

    public boolean has(String s2, String s1, double v) {
        return false;
    }

    public boolean has(OfflinePlayer offlinePlayer, String s2, double v) {
        return false;
    }

    public EconomyResponse withdrawPlayer(String s2, double v) {
        return null;
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.get(player.getUniqueId()), EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        if (!this.has(player, amount)) {
            return new EconomyResponse(0.0, this.get(player.getUniqueId()), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        }
        this.take(player.getUniqueId(), amount);
        return new EconomyResponse(amount, this.get(player.getUniqueId()), EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse withdrawPlayer(String s2, String s1, double v) {
        return null;
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, String s2, double v) {
        return null;
    }

    public EconomyResponse depositPlayer(String s2, double v) {
        return null;
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.get(player.getUniqueId()), EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
        }
        this.add(player.getUniqueId(), amount);
        return new EconomyResponse(amount, this.get(player.getUniqueId()), EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse depositPlayer(String s2, String s1, double v) {
        return null;
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, String s2, double v) {
        return null;
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        if (!balances.containsKey(player.getUniqueId())) {
            this.set(player.getUniqueId(), 0.0);
        }
        return true;
    }

    public boolean createPlayerAccount(String s2, String s1) {
        return false;
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer, String s2) {
        return false;
    }

    public EconomyResponse createBank(String name, String player) {
        return this.notSupported();
    }

    public EconomyResponse createBank(String s2, OfflinePlayer offlinePlayer) {
        return null;
    }

    public EconomyResponse deleteBank(String name) {
        return this.notSupported();
    }

    public EconomyResponse bankBalance(String name) {
        return this.notSupported();
    }

    public EconomyResponse bankHas(String name, double amount) {
        return this.notSupported();
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return this.notSupported();
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return this.notSupported();
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return this.notSupported();
    }

    public EconomyResponse isBankOwner(String s2, OfflinePlayer offlinePlayer) {
        return null;
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return this.notSupported();
    }

    public EconomyResponse isBankMember(String s2, OfflinePlayer offlinePlayer) {
        return null;
    }

    public List<String> getBanks() {
        return List.of();
    }

    public boolean createPlayerAccount(String s2) {
        return false;
    }

    private EconomyResponse notSupported() {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banking not supported");
    }
}

