/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.kit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import serveressentials.serveressentials.ServerEssentials;

public class KitConfigManager {
    private static FileConfiguration config;
    private static File file;

    public static void setup(JavaPlugin plugin) {
        file = new File(plugin.getDataFolder(), "kits.yml");
        if (!file.exists()) {
            plugin.saveResource("kits.yml", false);
        }
        config = YamlConfiguration.loadConfiguration((File)file);
        try (InputStream defStream = plugin.getResource("kits.yml");){
            if (defStream != null) {
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defStream, StandardCharsets.UTF_8));
                config.setDefaults((Configuration)defConfig);
                config.options().copyDefaults(true);
                KitConfigManager.save();
            }
        }
        catch (IOException e) {
            plugin.getLogger().severe("Failed to apply default kit config:");
            e.printStackTrace();
        }
    }

    public static FileConfiguration getConfig() {
        return config;
    }

    public static void save() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void reload() {
        if (file == null) {
            file = new File(ServerEssentials.getInstance().getDataFolder(), "kits.yml");
        }
        if (!file.exists()) {
            ServerEssentials.getInstance().saveResource("kits.yml", false);
        }
        config = YamlConfiguration.loadConfiguration((File)file);
    }
}

