/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.lobby;

import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import serveressentials.serveressentials.ServerEssentials;

public class LobbyManager {
    private static File file;
    private static FileConfiguration config;
    private static Location lobby;

    public static void setup() {
        File dataFolder = ServerEssentials.getInstance().getDataFolder();
        File storageFolder = new File(dataFolder, "storage");
        if (!storageFolder.exists() && storageFolder.mkdirs()) {
            Bukkit.getLogger().info("[ServerEssentials] Created /storage folder.");
        }
        if (!(file = new File(storageFolder, "lobby.yml")).exists()) {
            try {
                file.createNewFile();
                Bukkit.getLogger().info("[ServerEssentials] Created lobby.yml.");
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("[ServerEssentials] Failed to create lobby.yml!");
                e.printStackTrace();
            }
        }
        config = YamlConfiguration.loadConfiguration((File)file);
        LobbyManager.loadLobbyFromConfig();
    }

    public static void reload() {
        if (file == null) {
            LobbyManager.setup();
            return;
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
                Bukkit.getLogger().info("[ServerEssentials] Recreated missing lobby.yml.");
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("[ServerEssentials] Failed to recreate lobby.yml!");
                e.printStackTrace();
            }
        }
        config = YamlConfiguration.loadConfiguration((File)file);
        LobbyManager.loadLobbyFromConfig();
        Bukkit.getLogger().info("[ServerEssentials] LobbyManager reloaded successfully.");
    }

    public static void fullReload() {
        LobbyManager.reload();
        if (lobby != null) {
            Bukkit.getLogger().info("[ServerEssentials] Lobby loaded at: " + String.format("(%.1f, %.1f, %.1f) in world '%s'", lobby.getX(), lobby.getY(), lobby.getZ(), lobby.getWorld() != null ? lobby.getWorld().getName() : "null"));
        } else {
            Bukkit.getLogger().warning("[ServerEssentials] No lobby location is currently set!");
        }
    }

    private static void loadLobbyFromConfig() {
        if (!config.contains("lobby")) {
            lobby = null;
            return;
        }
        World world = Bukkit.getWorld((String)config.getString("lobby.world"));
        if (world == null) {
            lobby = config.getLocation("lobby");
        } else {
            double x = config.getDouble("lobby.x");
            double y = config.getDouble("lobby.y");
            double z = config.getDouble("lobby.z");
            float yaw = (float)config.getDouble("lobby.yaw", 0.0);
            float pitch = (float)config.getDouble("lobby.pitch", 0.0);
            lobby = new Location(world, x, y, z, yaw, pitch);
        }
    }

    public static void setLobby(Location location) {
        lobby = location;
        config.set("lobby.world", (Object)location.getWorld().getName());
        config.set("lobby.x", (Object)location.getX());
        config.set("lobby.y", (Object)location.getY());
        config.set("lobby.z", (Object)location.getZ());
        config.set("lobby.yaw", (Object)Float.valueOf(location.getYaw()));
        config.set("lobby.pitch", (Object)Float.valueOf(location.getPitch()));
        LobbyManager.save();
    }

    public static Location getLobby() {
        if (lobby == null) {
            LobbyManager.loadLobbyFromConfig();
        }
        return lobby;
    }

    public static void removeLobby() {
        lobby = null;
        config.set("lobby", null);
        LobbyManager.save();
    }

    public static boolean hasLobby() {
        return LobbyManager.getLobby() != null;
    }

    private static void save() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("[ServerEssentials] Failed to save lobby.yml!");
            e.printStackTrace();
        }
    }
}

