/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.staff;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.MessagesManager;

public class PingAllCommand
implements CommandExecutor {
    private final MessagesManager messages;
    private final BukkitAudiences adventure;

    public PingAllCommand(ServerEssentials plugin) {
        this.messages = new MessagesManager(plugin);
        this.adventure = BukkitAudiences.create((Plugin)plugin);
        this.messages.addDefault("pingall.no-permission", "<red>You do not have permission to use this command.");
        this.messages.addDefault("pingall.header", "<green>Online Player Pings:");
        this.messages.addDefault("pingall.player-line", "<yellow><player>: <aqua><ping>");
        this.messages.addDefault("pingall.ping-na", "N/A");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("serveressentials.pingall")) {
            this.send(sender, this.messages.getMessageComponent("pingall.no-permission", new String[0]));
            return true;
        }
        this.send(sender, this.messages.getMessageComponent("pingall.header", new String[0]));
        for (Player player : Bukkit.getOnlinePlayers()) {
            int ping = this.getPlayerPing(player);
            String pingDisplay = ping >= 0 ? ping + "ms" : this.messages.getConfig().getString("pingall.ping-na", "N/A");
            Component line = this.messages.getMessageComponent("pingall.player-line", "<player>", player.getName(), "<ping>", pingDisplay);
            this.send(sender, line);
        }
        return true;
    }

    private int getPlayerPing(Player player) {
        try {
            Method getPingMethod = Player.class.getMethod("getPing", new Class[0]);
            return (Integer)getPingMethod.invoke((Object)player, new Object[0]);
        }
        catch (NoSuchMethodException ignored) {
            try {
                String version = this.getServerVersion();
                Class<?> craftPlayerClass = Class.forName("org.bukkit.craftbukkit." + version + ".entity.CraftPlayer");
                Object craftPlayer = craftPlayerClass.cast(player);
                Method getHandle = craftPlayerClass.getMethod("getHandle", new Class[0]);
                Object entityPlayer = getHandle.invoke(craftPlayer, new Object[0]);
                Field pingField = entityPlayer.getClass().getField("ping");
                return pingField.getInt(entityPlayer);
            }
            catch (Exception e) {
                return -1;
            }
        }
        catch (Exception e) {
            return -1;
        }
    }

    private String getServerVersion() {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private void send(CommandSender sender, Component message) {
        this.adventure.sender(sender).sendMessage(message);
    }
}

