/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.warp;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import serveressentials.serveressentials.ServerEssentials;

public class WarpManager {
    private final ServerEssentials plugin;
    private File file;
    private FileConfiguration config;
    private final Map<String, Location> warps = new HashMap<String, Location>();
    private final Map<String, UUID> creators = new HashMap<String, UUID>();

    public WarpManager(ServerEssentials plugin) {
        this.plugin = plugin;
        this.load();
    }

    public void load() {
        this.file = new File(this.plugin.getDataFolder(), "storage/warps.yml");
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.warps.clear();
        this.creators.clear();
        for (String key : this.config.getKeys(false)) {
            double x = this.config.getDouble(key + ".x");
            double y = this.config.getDouble(key + ".y");
            double z = this.config.getDouble(key + ".z");
            float yaw = (float)this.config.getDouble(key + ".yaw");
            float pitch = (float)this.config.getDouble(key + ".pitch");
            String world = this.config.getString(key + ".world");
            String creatorStr = this.config.getString(key + ".creator");
            if (world == null || Bukkit.getWorld((String)world) == null) continue;
            this.warps.put(key.toLowerCase(), new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch));
            if (creatorStr == null) continue;
            this.creators.put(key.toLowerCase(), UUID.fromString(creatorStr));
        }
    }

    public void save() {
        for (String key : this.warps.keySet()) {
            Location loc = this.warps.get(key);
            this.config.set(key + ".x", (Object)loc.getX());
            this.config.set(key + ".y", (Object)loc.getY());
            this.config.set(key + ".z", (Object)loc.getZ());
            this.config.set(key + ".yaw", (Object)Float.valueOf(loc.getYaw()));
            this.config.set(key + ".pitch", (Object)Float.valueOf(loc.getPitch()));
            this.config.set(key + ".world", (Object)loc.getWorld().getName());
            UUID creator = this.creators.get(key.toLowerCase());
            if (creator == null) continue;
            this.config.set(key + ".creator", (Object)creator.toString());
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addWarp(String name, Location loc, UUID creator) {
        this.warps.put(name.toLowerCase(), loc);
        this.creators.put(name.toLowerCase(), creator);
        this.save();
    }

    public void removeWarp(String name) {
        this.warps.remove(name.toLowerCase());
        this.creators.remove(name.toLowerCase());
        this.config.set(name.toLowerCase(), null);
        this.save();
    }

    public Location getWarp(String name) {
        return this.warps.get(name.toLowerCase());
    }

    public UUID getCreator(String name) {
        return this.creators.get(name.toLowerCase());
    }

    public Map<String, Location> getWarps() {
        return this.warps;
    }

    public boolean exists(String name) {
        return this.warps.containsKey(name.toLowerCase());
    }
}

