/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.firestore.BulkWriter;
import com.google.cloud.firestore.BulkWriterException;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.WriteResult;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Status;

class BulkWriterOperation {
    private final SettableApiFuture<WriteResult> operationFuture = SettableApiFuture.create();
    private final DocumentReference documentReference;
    private final BulkWriter.OperationType operationType;
    private final ApiFunction<BulkWriterOperation, Void> scheduleWriteCallback;
    private final ApiFunction<WriteResult, ApiFuture<Void>> successListener;
    private final ApiFunction<BulkWriterException, ApiFuture<Boolean>> errorListener;
    public static final int DEFAULT_BACKOFF_INITIAL_DELAY_MS = 1000;
    public static final int DEFAULT_BACKOFF_MAX_DELAY_MS = 60000;
    public static final double DEFAULT_BACKOFF_FACTOR = 1.5;
    private int failedAttempts = 0;
    private Status lastStatus;
    private int backoffDuration = 0;

    BulkWriterOperation(DocumentReference documentReference, BulkWriter.OperationType operationType, ApiFunction<BulkWriterOperation, Void> scheduleWriteCallback, ApiFunction<WriteResult, ApiFuture<Void>> successListener, ApiFunction<BulkWriterException, ApiFuture<Boolean>> errorListener) {
        this.documentReference = documentReference;
        this.operationType = operationType;
        this.scheduleWriteCallback = scheduleWriteCallback;
        this.successListener = successListener;
        this.errorListener = errorListener;
    }

    public ApiFuture<WriteResult> getFuture() {
        return this.operationFuture;
    }

    public DocumentReference getDocumentReference() {
        return this.documentReference;
    }

    public int getBackoffDuration() {
        return this.backoffDuration;
    }

    public ApiFuture<Void> onException(FirestoreException exception) {
        ++this.failedAttempts;
        final BulkWriterException bulkWriterException = new BulkWriterException(exception.getStatus(), exception.getMessage(), this.documentReference, this.operationType, this.failedAttempts);
        final SettableApiFuture<Void> callbackFuture = SettableApiFuture.create();
        ApiFutures.addCallback(this.errorListener.apply(bulkWriterException), new ApiFutureCallback<Boolean>(){

            @Override
            public void onFailure(Throwable throwable) {
                BulkWriterOperation.this.operationFuture.setException(throwable);
                callbackFuture.set(null);
            }

            @Override
            public void onSuccess(Boolean shouldRetry) {
                if (shouldRetry.booleanValue()) {
                    BulkWriterOperation.this.lastStatus = bulkWriterException.getStatus();
                    BulkWriterOperation.this.updateBackoffDuration();
                    BulkWriterOperation.this.scheduleWriteCallback.apply(BulkWriterOperation.this);
                } else {
                    BulkWriterOperation.this.operationFuture.setException(bulkWriterException);
                }
                callbackFuture.set(null);
            }
        }, MoreExecutors.directExecutor());
        return callbackFuture;
    }

    private void updateBackoffDuration() {
        this.backoffDuration = this.lastStatus == Status.RESOURCE_EXHAUSTED ? 60000 : (this.backoffDuration == 0 ? 1000 : (int)((double)this.backoffDuration * 1.5));
    }

    public ApiFuture<Void> onSuccess(final WriteResult result) {
        final SettableApiFuture<Void> callbackFuture = SettableApiFuture.create();
        ApiFutures.addCallback(this.successListener.apply(result), new ApiFutureCallback<Void>(){

            @Override
            public void onFailure(Throwable throwable) {
                BulkWriterOperation.this.operationFuture.setException(throwable);
                callbackFuture.set(null);
            }

            @Override
            public void onSuccess(Void aVoid) {
                BulkWriterOperation.this.operationFuture.set(result);
                callbackFuture.set(null);
            }
        }, MoreExecutors.directExecutor());
        return callbackFuture;
    }
}

