/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.json.JsonFactory;
import com.google.api.gax.paging.Page;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firebase.auth.ExportedUserRecord;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseUserManager;
import com.google.firebase.auth.internal.DownloadAccountResponse;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ListUsersPage
implements Page<ExportedUserRecord> {
    static final String END_OF_LIST = "";
    private final ListUsersResult currentBatch;
    private final UserSource source;
    private final int maxResults;

    private ListUsersPage(@NonNull ListUsersResult currentBatch, @NonNull UserSource source, int maxResults) {
        this.currentBatch = Preconditions.checkNotNull(currentBatch);
        this.source = Preconditions.checkNotNull(source);
        this.maxResults = maxResults;
    }

    @Override
    public boolean hasNextPage() {
        return !END_OF_LIST.equals(this.currentBatch.getNextPageToken());
    }

    @Override
    @NonNull
    public String getNextPageToken() {
        return this.currentBatch.getNextPageToken();
    }

    @Nullable
    public ListUsersPage getNextPage() {
        if (this.hasNextPage()) {
            Factory factory = new Factory(this.source, this.maxResults, this.currentBatch.getNextPageToken());
            try {
                return factory.create();
            }
            catch (FirebaseAuthException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    @NonNull
    public Iterable<ExportedUserRecord> iterateAll() {
        return new UserIterable(this);
    }

    @Override
    @NonNull
    public Iterable<ExportedUserRecord> getValues() {
        return this.currentBatch.getUsers();
    }

    static class Factory {
        private final UserSource source;
        private final int maxResults;
        private final String pageToken;

        Factory(@NonNull UserSource source) {
            this(source, 1000, null);
        }

        Factory(@NonNull UserSource source, int maxResults, @Nullable String pageToken) {
            Preconditions.checkArgument(maxResults > 0 && maxResults <= 1000, "maxResults must be a positive integer that does not exceed %s", 1000);
            Preconditions.checkArgument(!ListUsersPage.END_OF_LIST.equals(pageToken), "invalid end of list page token");
            this.source = Preconditions.checkNotNull(source, "source must not be null");
            this.maxResults = maxResults;
            this.pageToken = pageToken;
        }

        ListUsersPage create() throws FirebaseAuthException {
            ListUsersResult batch = this.source.fetch(this.maxResults, this.pageToken);
            return new ListUsersPage(batch, this.source, this.maxResults);
        }
    }

    static final class ListUsersResult {
        private final List<ExportedUserRecord> users;
        private final String nextPageToken;

        ListUsersResult(@NonNull List<ExportedUserRecord> users, @NonNull String nextPageToken) {
            this.users = Preconditions.checkNotNull(users);
            this.nextPageToken = Preconditions.checkNotNull(nextPageToken);
        }

        @NonNull
        List<ExportedUserRecord> getUsers() {
            return this.users;
        }

        @NonNull
        String getNextPageToken() {
            return this.nextPageToken;
        }
    }

    static class DefaultUserSource
    implements UserSource {
        private final FirebaseUserManager userManager;
        private final JsonFactory jsonFactory;

        DefaultUserSource(FirebaseUserManager userManager, JsonFactory jsonFactory) {
            this.userManager = Preconditions.checkNotNull(userManager, "user manager must not be null");
            this.jsonFactory = Preconditions.checkNotNull(jsonFactory, "json factory must not be null");
        }

        @Override
        public ListUsersResult fetch(int maxResults, String pageToken) throws FirebaseAuthException {
            DownloadAccountResponse response = this.userManager.listUsers(maxResults, pageToken);
            ImmutableList.Builder builder = ImmutableList.builder();
            if (response.hasUsers()) {
                for (DownloadAccountResponse.User user : response.getUsers()) {
                    builder.add(new ExportedUserRecord(user, this.jsonFactory));
                }
            }
            String nextPageToken = response.getPageToken() != null ? response.getPageToken() : ListUsersPage.END_OF_LIST;
            return new ListUsersResult((List<ExportedUserRecord>)((Object)builder.build()), nextPageToken);
        }
    }

    static interface UserSource {
        @NonNull
        public ListUsersResult fetch(int var1, String var2) throws FirebaseAuthException;
    }

    private static class UserIterable
    implements Iterable<ExportedUserRecord> {
        private final ListUsersPage startingPage;

        UserIterable(@NonNull ListUsersPage startingPage) {
            this.startingPage = Preconditions.checkNotNull(startingPage, "starting page must not be null");
        }

        @Override
        @NonNull
        public Iterator<ExportedUserRecord> iterator() {
            return new UserIterator(this.startingPage);
        }

        private static class UserIterator
        implements Iterator<ExportedUserRecord> {
            private ListUsersPage currentPage;
            private List<ExportedUserRecord> batch;
            private int index = 0;

            private UserIterator(ListUsersPage startingPage) {
                this.setCurrentPage(startingPage);
            }

            @Override
            public boolean hasNext() {
                if (this.index == this.batch.size()) {
                    if (this.currentPage.hasNextPage()) {
                        this.setCurrentPage(this.currentPage.getNextPage());
                    } else {
                        return false;
                    }
                }
                return this.index < this.batch.size();
            }

            @Override
            public ExportedUserRecord next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.batch.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove operation not supported");
            }

            private void setCurrentPage(ListUsersPage page) {
                this.currentPage = Preconditions.checkNotNull(page);
                this.batch = ImmutableList.copyOf(page.getValues());
                this.index = 0;
            }
        }
    }
}

