/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.core.DatabaseConfig;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.Repo;
import com.google.firebase.database.core.RepoInfo;
import com.google.firebase.database.core.RepoManager;
import com.google.firebase.database.util.EmulatorHelper;
import com.google.firebase.database.utilities.ParsedUrl;
import com.google.firebase.database.utilities.Utilities;
import com.google.firebase.database.utilities.Validation;
import com.google.firebase.internal.EmulatorCredentials;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.SdkUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class FirebaseDatabase {
    private final FirebaseApp app;
    private final RepoInfo repoInfo;
    private final DatabaseConfig config;
    private Repo repo;
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final Object lock = new Object();
    private static final String SERVICE_ID = FirebaseDatabase.class.getName();

    private FirebaseDatabase(FirebaseApp app, RepoInfo repoInfo, DatabaseConfig config) {
        this.app = app;
        this.repoInfo = repoInfo;
        this.config = config;
    }

    public static FirebaseDatabase getInstance() {
        FirebaseApp instance = FirebaseApp.getInstance();
        if (instance == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(instance, instance.getOptions().getDatabaseUrl());
    }

    public static FirebaseDatabase getInstance(String url) {
        FirebaseApp instance = FirebaseApp.getInstance();
        if (instance == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(instance, url);
    }

    public static FirebaseDatabase getInstance(FirebaseApp app) {
        return FirebaseDatabase.getInstance(app, app.getOptions().getDatabaseUrl());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp app, String url) {
        ParsedUrl parsedUrl;
        FirebaseDatabaseService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, FirebaseDatabaseService.class);
        if (service == null) {
            service = ImplFirebaseTrampolines.addService(app, new FirebaseDatabaseService());
        }
        if (url == null || url.isEmpty()) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        boolean connectingToEmulator = false;
        String possibleEmulatorUrl = EmulatorHelper.getEmulatorUrl(url, EmulatorHelper.getEmulatorHostFromEnv());
        if (!Strings.isNullOrEmpty(possibleEmulatorUrl)) {
            parsedUrl = Utilities.parseUrl(possibleEmulatorUrl);
            connectingToEmulator = true;
        } else {
            parsedUrl = Utilities.parseUrl(url);
        }
        if (!parsedUrl.path.isEmpty()) {
            throw new DatabaseException("Specified Database URL '" + url + "' is invalid. It should point to the root of a Firebase Database but it includes a path: " + parsedUrl.path.toString());
        }
        DatabaseInstances dbInstances = (DatabaseInstances)service.getInstance();
        FirebaseDatabase database = dbInstances.get(parsedUrl.repoInfo);
        if (database == null) {
            DatabaseConfig config = new DatabaseConfig();
            if (!ImplFirebaseTrampolines.isDefaultApp(app)) {
                config.setSessionPersistenceKey(app.getName());
            }
            config.setFirebaseApp(app);
            if (connectingToEmulator) {
                config.setCustomCredentials(new EmulatorCredentials(), true);
            }
            database = new FirebaseDatabase(app, parsedUrl.repoInfo, config);
            dbInstances.put(parsedUrl.repoInfo, database);
        }
        return database;
    }

    static FirebaseDatabase createForTests(FirebaseApp app, RepoInfo repoInfo, DatabaseConfig config) {
        FirebaseDatabase db = new FirebaseDatabase(app, repoInfo, config);
        db.ensureRepo();
        return db;
    }

    public static String getSdkVersion() {
        return SdkUtils.getVersion();
    }

    public FirebaseApp getApp() {
        return this.app;
    }

    public DatabaseReference getReference() {
        return new DatabaseReference(this.ensureRepo(), Path.getEmptyPath());
    }

    public DatabaseReference getReference(String path) {
        Preconditions.checkNotNull(path, "Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        Validation.validateRootPathString(path);
        Path childPath = new Path(path);
        return new DatabaseReference(this.ensureRepo(), childPath);
    }

    public DatabaseReference getReferenceFromUrl(String url) {
        Preconditions.checkNotNull(url, "Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        String possibleEmulatorUrl = EmulatorHelper.getEmulatorUrl(url, EmulatorHelper.getEmulatorHostFromEnv());
        if (!Strings.isNullOrEmpty(possibleEmulatorUrl)) {
            url = possibleEmulatorUrl;
        }
        ParsedUrl parsedUrl = Utilities.parseUrl(url);
        Repo repo = this.ensureRepo();
        if (!parsedUrl.repoInfo.host.equals(repo.getRepoInfo().host)) {
            throw new DatabaseException("Invalid URL (" + url + ") passed to getReference().  URL was expected to match configured Database URL: " + this.getReference().toString());
        }
        return new DatabaseReference(repo, parsedUrl.path);
    }

    public void purgeOutstandingWrites() {
        final Repo repo = this.ensureRepo();
        repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                repo.purgeOutstandingWrites();
            }
        });
    }

    public void goOnline() {
        RepoManager.resume(this.ensureRepo());
    }

    public void goOffline() {
        RepoManager.interrupt(this.ensureRepo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPersistenceEnabled(boolean isEnabled) {
        Object object = this.lock;
        synchronized (object) {
            this.assertUnfrozen("setPersistenceEnabled");
            this.config.setPersistenceEnabled(isEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistenceCacheSizeBytes(long cacheSizeInBytes) {
        Object object = this.lock;
        synchronized (object) {
            this.assertUnfrozen("setPersistenceCacheSizeBytes");
            this.config.setPersistenceCacheSizeBytes(cacheSizeInBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertUnfrozen(String methodCalled) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotDestroyed();
            if (this.repo != null) {
                throw new DatabaseException("Calls to " + methodCalled + "() must be made before any other usage of FirebaseDatabase instance.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Repo ensureRepo() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotDestroyed();
            if (this.repo == null) {
                this.repo = RepoManager.createRepo(this.config, this.repoInfo, this);
            }
            return this.repo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNotDestroyed() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState(!this.destroyed.get(), "FirebaseDatabase instance is no longer alive. This happens when the parent FirebaseApp instance has been deleted.");
        }
    }

    DatabaseConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.destroyed.get()) {
                return;
            }
            RepoManager.destroy(this.getConfig());
            this.destroyed.compareAndSet(false, true);
        }
    }

    private static class FirebaseDatabaseService
    extends FirebaseService<DatabaseInstances> {
        FirebaseDatabaseService() {
            super(SERVICE_ID, new DatabaseInstances());
        }

        @Override
        public void destroy() {
            ((DatabaseInstances)this.instance).destroy();
        }
    }

    private static class DatabaseInstances {
        private final Map<RepoInfo, FirebaseDatabase> databases = Collections.synchronizedMap(new HashMap());

        private DatabaseInstances() {
        }

        void put(RepoInfo repo, FirebaseDatabase database) {
            this.databases.put(repo, database);
        }

        FirebaseDatabase get(RepoInfo repo) {
            return this.databases.get(repo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy() {
            Map<RepoInfo, FirebaseDatabase> map = this.databases;
            synchronized (map) {
                for (FirebaseDatabase database : this.databases.values()) {
                    database.destroy();
                }
                this.databases.clear();
            }
        }
    }
}

