/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.NonNull;
import com.google.firebase.messaging.ApsAlert;
import com.google.firebase.messaging.CriticalSound;
import java.util.HashMap;
import java.util.Map;

public class Aps {
    private final Map<String, Object> fields;

    private Aps(Builder builder) {
        Preconditions.checkArgument(Strings.isNullOrEmpty(builder.alertString) || builder.alert == null, "Multiple alert specifications (string and ApsAlert) found.");
        Preconditions.checkArgument(Strings.isNullOrEmpty(builder.sound) || builder.criticalSound == null, "Multiple sound specifications (sound and CriticalSound) found.");
        ImmutableMap.Builder<String, Object> fields = ImmutableMap.builder();
        if (builder.alert != null) {
            fields.put("alert", builder.alert);
        } else if (builder.alertString != null) {
            fields.put("alert", builder.alertString);
        }
        if (builder.badge != null) {
            fields.put("badge", builder.badge);
        }
        if (!Strings.isNullOrEmpty(builder.sound)) {
            fields.put("sound", builder.sound);
        } else if (builder.criticalSound != null) {
            fields.put("sound", builder.criticalSound.getFields());
        }
        if (builder.contentAvailable) {
            fields.put("content-available", 1);
        }
        if (builder.mutableContent) {
            fields.put("mutable-content", 1);
        }
        if (builder.category != null) {
            fields.put("category", builder.category);
        }
        if (builder.threadId != null) {
            fields.put("thread-id", builder.threadId);
        }
        fields.putAll(builder.customData);
        this.fields = fields.build();
    }

    Map<String, Object> getFields() {
        return this.fields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String alertString;
        private ApsAlert alert;
        private Integer badge;
        private String sound;
        private CriticalSound criticalSound;
        private boolean contentAvailable;
        private boolean mutableContent;
        private String category;
        private String threadId;
        private final Map<String, Object> customData = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alertString = alert;
            return this;
        }

        public Builder setAlert(ApsAlert alert) {
            this.alert = alert;
            return this;
        }

        public Builder setBadge(int badge) {
            this.badge = badge;
            return this;
        }

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder setSound(CriticalSound sound) {
            this.criticalSound = sound;
            return this;
        }

        public Builder setContentAvailable(boolean contentAvailable) {
            this.contentAvailable = contentAvailable;
            return this;
        }

        public Builder setMutableContent(boolean mutableContent) {
            this.mutableContent = mutableContent;
            return this;
        }

        public Builder putCustomData(@NonNull String key, @NonNull Object value) {
            this.customData.put(key, value);
            return this;
        }

        public Builder putAllCustomData(@NonNull Map<String, Object> fields) {
            this.customData.putAll(fields);
            return this;
        }

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder setThreadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public Aps build() {
            return new Aps(this);
        }
    }
}

