/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

final class RemoteConfigUtil {
    private static final String ZULU_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS000000'Z'";
    private static final String ZULU_DATE_NO_FRAC_SECS_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String UTC_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");

    RemoteConfigUtil() {
    }

    static boolean isValidVersionNumber(String versionNumber) {
        return !Strings.isNullOrEmpty(versionNumber) && versionNumber.matches("^\\d+$");
    }

    static long convertToMilliseconds(String dateString) throws ParseException {
        try {
            return RemoteConfigUtil.convertFromUtcZuluFormat(dateString);
        }
        catch (ParseException e) {
            return RemoteConfigUtil.convertFromUtcDateFormat(dateString);
        }
    }

    static String convertToUtcZuluFormat(long millis) {
        Preconditions.checkArgument(millis >= 0L, "Milliseconds duration must not be negative");
        SimpleDateFormat dateFormat = new SimpleDateFormat(ZULU_DATE_PATTERN);
        dateFormat.setTimeZone(UTC_TIME_ZONE);
        return dateFormat.format(new Date(millis));
    }

    static String convertToUtcDateFormat(long millis) {
        Preconditions.checkArgument(millis >= 0L, "Milliseconds duration must not be negative");
        SimpleDateFormat dateFormat = new SimpleDateFormat(UTC_DATE_PATTERN);
        dateFormat.setTimeZone(UTC_TIME_ZONE);
        return dateFormat.format(new Date(millis));
    }

    static long convertFromUtcZuluFormat(String dateString) throws ParseException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(dateString), "Date string must not be null or empty");
        int indexOfPeriod = dateString.indexOf(".");
        if (indexOfPeriod != -1) {
            dateString = dateString.substring(0, indexOfPeriod);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(ZULU_DATE_NO_FRAC_SECS_PATTERN);
        dateFormat.setTimeZone(UTC_TIME_ZONE);
        return dateFormat.parse(dateString).getTime();
    }

    static long convertFromUtcDateFormat(String dateString) throws ParseException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(dateString), "Date string must not be null or empty");
        SimpleDateFormat dateFormat = new SimpleDateFormat(UTC_DATE_PATTERN);
        dateFormat.setTimeZone(UTC_TIME_ZONE);
        return dateFormat.parse(dateString).getTime();
    }
}

