/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Daily;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import serveressentials.serveressentials.util.DailyMessagesManager;
import serveressentials.serveressentials.util.DailyRewardsManager;

public class DailyRewards
implements Listener {
    private final JavaPlugin plugin;
    private final DailyMessagesManager messagesManager;
    private final DailyRewardsManager rewardsManager;
    private final Map<UUID, Set<String>> claimedRewards = new HashMap<UUID, Set<String>>();
    private final Map<UUID, LocalDateTime> lastClaimTime = new HashMap<UUID, LocalDateTime>();
    private final int cooldownHours = 24;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public DailyRewards(JavaPlugin plugin) {
        File configFile;
        File configFolder;
        this.plugin = plugin;
        this.messagesManager = new DailyMessagesManager(plugin);
        this.rewardsManager = new DailyRewardsManager(plugin);
        File pluginFolder = plugin.getDataFolder();
        if (!pluginFolder.exists()) {
            pluginFolder.mkdirs();
        }
        if (!(configFolder = new File(pluginFolder, "config/Daily")).exists()) {
            configFolder.mkdirs();
        }
        if (!(configFile = new File(configFolder, "daily.yml")).exists()) {
            try (InputStream in = plugin.getResource("config/Daily/daily.yml");){
                if (in != null) {
                    Files.copy(in, configFile.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                plugin.getLogger().severe("Failed to copy daily.yml!");
                e.printStackTrace();
            }
        }
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public DailyMessagesManager getMessagesManager() {
        return this.messagesManager;
    }

    public void openRewardsGUI(Player player, int page) {
        Object guiTitle = this.miniMessage.deserialize(this.messagesManager.get("gui-title", "%page%", String.valueOf(page)));
        Inventory gui = Bukkit.createInventory(null, (int)54, guiTitle);
        List<String> keys = this.rewardsManager.getRewardDays();
        int totalPages = 1;
        for (String day : keys) {
            totalPages = Math.max(totalPages, this.rewardsManager.getRewardPage(day));
        }
        UUID uuid = player.getUniqueId();
        Set claimed = this.claimedRewards.getOrDefault(uuid, new HashSet());
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime lastClaim = this.lastClaimTime.getOrDefault(uuid, LocalDateTime.MIN);
        Duration cooldownLeft = Duration.ofHours(24L).minus(Duration.between(lastClaim, now));
        boolean onCooldown = !cooldownLeft.isNegative();
        for (String day : keys) {
            ItemMeta meta;
            ItemStack displayItem;
            List<Map<String, Object>> itemList;
            int slot;
            int rewardPage = this.rewardsManager.getRewardPage(day);
            if (rewardPage != page || (slot = this.rewardsManager.getRewardSlot(day)) < 0 || slot > 53 || (itemList = this.rewardsManager.getRewardItems(day)).isEmpty()) continue;
            Map<String, Object> rewardItemData = itemList.get(0);
            Material material = Material.matchMaterial((String)((String)rewardItemData.getOrDefault("type", "DIAMOND")));
            if (material == null) {
                material = Material.DIAMOND;
            }
            if (claimed.contains(day)) {
                displayItem = new ItemStack(Material.LIME_CONCRETE);
                meta = displayItem.getItemMeta();
                meta.displayName(this.miniMessage.deserialize(this.messagesManager.get("reward-claimed-name", new Object[0])));
                meta.lore(Collections.singletonList(this.miniMessage.deserialize(this.messagesManager.get("reward-claimed-lore", new Object[0]))));
            } else if (onCooldown || !this.canClaimDay(claimed, Integer.parseInt(day))) {
                displayItem = new ItemStack(Material.RED_CONCRETE);
                meta = displayItem.getItemMeta();
                meta.displayName(this.miniMessage.deserialize(this.messagesManager.get("reward-locked-name", new Object[0])));
                String loreMsg = onCooldown ? this.messagesManager.get("reward-locked-cooldown", "%time%", this.formatDuration(cooldownLeft)) : this.messagesManager.get("reward-locked-previous", new Object[0]);
                meta.lore(Collections.singletonList(this.miniMessage.deserialize(loreMsg)));
            } else {
                displayItem = new ItemStack(material);
                meta = displayItem.getItemMeta();
                meta.displayName(this.miniMessage.deserialize(this.messagesManager.get("reward-name", "%day%", day)));
                meta.lore(Collections.singletonList(this.miniMessage.deserialize((String)rewardItemData.getOrDefault("lore", "&7Click to claim!"))));
            }
            displayItem.setItemMeta(meta);
            gui.setItem(slot, displayItem);
        }
        if (page > 1) {
            gui.setItem(45, this.navItem(Material.ARROW, (Component)this.miniMessage.deserialize(this.messagesManager.get("previous-page", new Object[0]))));
        }
        if (page < totalPages) {
            gui.setItem(53, this.navItem(Material.ARROW, (Component)this.miniMessage.deserialize(this.messagesManager.get("next-page", new Object[0]))));
        }
        gui.setItem(49, this.navItem(Material.BARRIER, (Component)this.miniMessage.deserialize(this.messagesManager.get("close-button", new Object[0]))));
        player.openInventory(gui);
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
    }

    private boolean canClaimDay(Set<String> claimed, int day) {
        for (int i = 1; i < day; ++i) {
            if (claimed.contains(String.valueOf(i))) continue;
            return false;
        }
        return true;
    }

    private ItemStack navItem(Material mat, Component name) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(name);
        item.setItemMeta(meta);
        return item;
    }

    private String formatDuration(Duration d) {
        return String.format("%02dh %02dm %02ds", d.toHoursPart(), d.toMinutesPart(), d.toSecondsPart());
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        final Player player = (Player)humanEntity;
        String guiTitleText = PlainTextComponentSerializer.plainText().serialize(e.getView().title());
        String expectedTitleText = PlainTextComponentSerializer.plainText().serialize(this.miniMessage.deserialize(this.messagesManager.get("gui-title-placeholder", new Object[0])));
        if (!guiTitleText.contains(expectedTitleText)) {
            return;
        }
        e.setCancelled(true);
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        if (clicked.getType() == Material.BARRIER) {
            player.closeInventory();
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 0.6f);
            return;
        }
        if (clicked.getType() == Material.ARROW) {
            String prevText;
            String clickedName = PlainTextComponentSerializer.plainText().serialize(clicked.getItemMeta().displayName());
            final int newPage = clickedName.contains(prevText = PlainTextComponentSerializer.plainText().serialize(this.miniMessage.deserialize(this.messagesManager.get("previous-page", new Object[0])))) ? 1 : 2;
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            new BukkitRunnable(){

                public void run() {
                    DailyRewards.this.openRewardsGUI(player, newPage);
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
            return;
        }
        UUID uuid = player.getUniqueId();
        Set claimed = this.claimedRewards.computeIfAbsent(uuid, k -> new HashSet());
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime lastClaim = this.lastClaimTime.getOrDefault(uuid, LocalDateTime.MIN);
        Duration cooldownLeft = Duration.ofHours(24L).minus(Duration.between(lastClaim, now));
        if (!cooldownLeft.isNegative()) {
            player.sendMessage(this.miniMessage.deserialize(this.messagesManager.get("claim-cooldown", "%time%", this.formatDuration(cooldownLeft))));
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        int clickedSlot = e.getSlot();
        String clickedDay = null;
        for (String day : this.rewardsManager.getRewardDays()) {
            if (this.rewardsManager.getRewardSlot(day) != clickedSlot) continue;
            clickedDay = day;
            break;
        }
        if (clickedDay == null) {
            return;
        }
        if (claimed.contains(clickedDay)) {
            player.sendMessage(this.miniMessage.deserialize(this.messagesManager.get("claim-already", new Object[0])));
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        if (!this.canClaimDay(claimed, Integer.parseInt(clickedDay))) {
            player.sendMessage(this.miniMessage.deserialize(this.messagesManager.get("claim-previous", new Object[0])));
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        List<Map<String, Object>> itemList = this.rewardsManager.getRewardItems(clickedDay);
        for (Map<String, Object> itemData : itemList) {
            String typeName = itemData.getOrDefault("type", "DIAMOND").toString().toUpperCase();
            Material mat = Material.matchMaterial((String)typeName);
            if (mat == null) continue;
            int amount = 1;
            Object amtObj = itemData.get("amount");
            if (amtObj instanceof Number) {
                amount = ((Number)amtObj).intValue();
            } else if (amtObj != null) {
                try {
                    amount = Integer.parseInt(amtObj.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String lore = itemData.getOrDefault("lore", "&7Daily Reward").toString();
            ItemStack item = new ItemStack(mat, amount);
            ItemMeta meta = item.getItemMeta();
            meta.displayName(this.miniMessage.deserialize(this.messagesManager.get("reward-name", "%day%", clickedDay)));
            meta.lore(Collections.singletonList(this.miniMessage.deserialize(lore)));
            item.setItemMeta(meta);
            player.getInventory().addItem(new ItemStack[]{item});
        }
        claimed.add(clickedDay);
        this.lastClaimTime.put(uuid, now);
        player.sendMessage(this.miniMessage.deserialize(this.messagesManager.get("claim-success", "%day%", clickedDay)));
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.2f);
        player.closeInventory();
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        String expectedTitleText;
        String guiTitleText = PlainTextComponentSerializer.plainText().serialize(e.getView().title());
        if (guiTitleText.contains(expectedTitleText = PlainTextComponentSerializer.plainText().serialize(this.miniMessage.deserialize(this.messagesManager.get("gui-title-placeholder", new Object[0]))))) {
            // empty if block
        }
    }
}

