/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.gui;

import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.ServerEssentials;

public class PlayTimeRewardGUI {
    public static void openGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)"Playtime Rewards");
        long playtime = player.getStatistic(Statistic.PLAY_ONE_MINUTE) / 20;
        PlayTimeRewardGUI.addReward(gui, 11, playtime, 3600L, player);
        player.openInventory(gui);
    }

    private static void addReward(Inventory gui, int slot, long playtime, long requiredTime, Player player) {
        Object lore;
        String name;
        Material type;
        if (PlayTimeRewardGUI.hasClaimedReward(player, requiredTime)) {
            type = Material.GREEN_STAINED_GLASS_PANE;
            name = "\u00a7aClaimed";
            lore = "\u00a77You've already claimed this reward.";
        } else if (playtime >= requiredTime) {
            type = Material.YELLOW_STAINED_GLASS_PANE;
            name = "\u00a7eClick to claim!";
            lore = "\u00a77Reward available!";
        } else {
            type = Material.GRAY_STAINED_GLASS_PANE;
            name = "\u00a77Locked";
            lore = "\u00a7cPlaytime required: " + requiredTime / 60L + " minutes";
        }
        ItemStack item = new ItemStack(type);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(Collections.singletonList(lore));
        item.setItemMeta(meta);
        gui.setItem(slot, item);
    }

    private static boolean hasClaimedReward(Player player, long requiredTime) {
        return player.getPersistentDataContainer().has(new NamespacedKey((Plugin)ServerEssentials.getInstance(), "reward_" + requiredTime), PersistentDataType.BYTE);
    }

    public static void claimReward(Player player, long requiredTime) {
        player.getPersistentDataContainer().set(new NamespacedKey((Plugin)ServerEssentials.getInstance(), "reward_" + requiredTime), PersistentDataType.BYTE, (Object)1);
        player.sendMessage("\u00a7aYou claimed your reward!");
        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.DIAMOND, 3)});
        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.NETHERITE_SCRAP, 1)});
    }
}

