/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.homes;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.homes.Home;
import serveressentials.serveressentials.homes.HomeManager;
import serveressentials.serveressentials.homes.HomesConfirmHolder;
import serveressentials.serveressentials.homes.HomesGUI;
import serveressentials.serveressentials.homes.HomesMainHolder;
import serveressentials.serveressentials.util.HomeMessages;

public class HomeListener
implements Listener {
    private final ServerEssentials plugin;
    private final HomeManager homeManager;
    private final HomesGUI homesGUI;
    private final HomeMessages messages;
    private final Map<UUID, PendingAction> pending = new HashMap<UUID, PendingAction>();
    private final Map<UUID, Integer> awaitingRename = new HashMap<UUID, Integer>();

    public HomeListener(ServerEssentials plugin, HomeManager homeManager, HomesGUI homesGUI, HomeMessages messages) {
        this.plugin = plugin;
        this.homeManager = homeManager;
        this.homesGUI = homesGUI;
        this.messages = messages;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        UUID uuid = p.getUniqueId();
        if (e.getInventory().getHolder() instanceof HomesMainHolder) {
            int i;
            e.setCancelled(true);
            int slot = e.getRawSlot();
            for (i = 0; i < this.homesGUI.getBedSlots().length; ++i) {
                if (slot != this.homesGUI.getBedSlots()[i]) continue;
                this.handleBedClick(p, i + 1, e.getClick());
            }
            for (i = 0; i < this.homesGUI.getDyeSlots().length; ++i) {
                if (slot != this.homesGUI.getDyeSlots()[i]) continue;
                this.handleDyeClick(p, i + 1);
            }
        }
        if (e.getInventory().getHolder() instanceof HomesConfirmHolder) {
            e.setCancelled(true);
            PendingAction pa = this.pending.get(uuid);
            if (pa == null) {
                p.closeInventory();
                return;
            }
            int slot = e.getRawSlot();
            if (slot == 10) {
                switch (pa.action.ordinal()) {
                    case 0: {
                        this.homeManager.setHome(uuid, pa.index, new Home("Home" + pa.index, p.getLocation()));
                        p.sendMessage(this.messages.get("msg.home-set", "{home}", String.valueOf(pa.index), "{x}", String.valueOf(Math.round(p.getLocation().getX())), "{y}", String.valueOf(Math.round(p.getLocation().getY())), "{z}", String.valueOf(Math.round(p.getLocation().getZ()))));
                        this.pending.remove(uuid);
                        break;
                    }
                    case 1: {
                        this.homeManager.removeHome(uuid, pa.index);
                        p.sendMessage(this.messages.get("msg.home-removed", "{home}", String.valueOf(pa.index)));
                        this.pending.remove(uuid);
                        break;
                    }
                    case 2: {
                        this.awaitingRename.put(uuid, pa.index);
                        this.pending.remove(uuid);
                        p.closeInventory();
                        p.sendMessage(this.messages.get("msg.rename-prompt"));
                    }
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.homesGUI.openMain(p));
            } else if (slot == 16) {
                this.pending.remove(uuid);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.homesGUI.openMain(p));
            }
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        Player p = e.getPlayer();
        UUID uuid = p.getUniqueId();
        if (!this.awaitingRename.containsKey(uuid)) {
            return;
        }
        e.setCancelled(true);
        int index = this.awaitingRename.remove(uuid);
        String msg = e.getMessage().trim();
        this.homeManager.getHome(uuid, index).ifPresent(h2 -> {
            h2.setName(msg);
            this.homeManager.setHome(uuid, index, (Home)h2);
            p.sendMessage(this.messages.get("msg.renamed", "{name}", msg));
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.homesGUI.openMain(p));
        });
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        UUID uuid = e.getPlayer().getUniqueId();
        this.awaitingRename.remove(uuid);
        this.pending.remove(uuid);
    }

    private void handleBedClick(Player p, int homeIndex, ClickType clickType) {
        UUID uuid = p.getUniqueId();
        boolean allowed = this.homesGUI.canSetHome(p, homeIndex);
        boolean hasHome = this.homeManager.getHome(uuid, homeIndex).isPresent();
        if (!allowed) {
            p.sendMessage(this.messages.get("msg.no-permission"));
            return;
        }
        if (hasHome && clickType.isLeftClick()) {
            this.homeManager.getHome(uuid, homeIndex).ifPresent(h2 -> {
                if (h2.toLocation() != null) {
                    p.teleport(h2.toLocation());
                } else {
                    p.sendMessage(this.messages.get("msg.home-world-missing"));
                }
            });
            return;
        }
        if (!hasHome) {
            this.pending.put(uuid, new PendingAction(PendingAction.Action.SET, homeIndex));
            p.openInventory(this.homesGUI.createConfirmInventory(p, homeIndex, "set"));
        } else if (p.hasPermission("serveressentials.renamehome")) {
            this.pending.put(uuid, new PendingAction(PendingAction.Action.RENAME, homeIndex));
            p.openInventory(this.homesGUI.createConfirmInventory(p, homeIndex, "rename"));
        } else {
            p.sendMessage(this.messages.get("msg.no-permission"));
        }
    }

    private void handleDyeClick(Player p, int homeIndex) {
        UUID uuid = p.getUniqueId();
        boolean allowed = p.hasPermission("serveressentials.sethome") && (p.hasPermission("serveressentials.sethome.*") || p.hasPermission("serveressentials.sethome." + homeIndex) || this.hasNumericAllow(p));
        boolean removeAllowed = p.hasPermission("serveressentials.removehome");
        boolean hasHome = this.homeManager.getHome(uuid, homeIndex).isPresent();
        if (!allowed || !removeAllowed) {
            p.sendMessage(this.messages.get("msg.no-permission"));
            return;
        }
        if (!hasHome) {
            p.sendMessage(this.messages.get("lore.empty"));
            return;
        }
        this.pending.put(uuid, new PendingAction(PendingAction.Action.REMOVE, homeIndex));
        p.openInventory(this.homesGUI.createConfirmInventory(p, homeIndex, "remove"));
    }

    private boolean hasNumericAllow(Player p) {
        for (int i = 1; i <= 8; ++i) {
            if (!p.hasPermission("serveressentials.sethome." + i)) continue;
            return true;
        }
        return false;
    }

    private static class PendingAction {
        public final Action action;
        public final int index;

        public PendingAction(Action action, int index) {
            this.action = action;
            this.index = index;
        }

        static enum Action {
            SET,
            REMOVE,
            RENAME;

        }
    }
}

