/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.kit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.kit.KitConfigManager;
import serveressentials.serveressentials.kit.KitGUIListener;
import serveressentials.serveressentials.kit.KitManager;

public class KitCommand
implements CommandExecutor {
    private final Map<UUID, Map<String, Long>> cooldowns = new HashMap<UUID, Map<String, Long>>();
    private final KitGUIListener guiListener = new KitGUIListener(this);

    public KitCommand() {
        ServerEssentials.getInstance().getServer().getPluginManager().registerEvents((Listener)this.guiListener, (Plugin)ServerEssentials.getInstance());
    }

    private String getPrefix() {
        String rawPrefix = ServerEssentials.getInstance().getPrefixConfig().getString("prefix", "&9&l[&bSE&9&l] &r");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)rawPrefix);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("serveressentials.kit.reload")) {
                sender.sendMessage(ServerEssentials.getInstance().getKitMessages().get("reload-no-permission", "%player%", sender.getName()));
                return true;
            }
            KitConfigManager.reload();
            KitManager.loadKits(KitConfigManager.getConfig());
            sender.sendMessage(ServerEssentials.getInstance().getKitMessages().get("reload-success", "%player%", sender.getName()));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ServerEssentials.getInstance().getKitMessages().get("only-players", "%player%", sender.getName()));
            return true;
        }
        Player player = (Player)sender;
        this.guiListener.openKitGUI(player);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        FileConfiguration config = KitConfigManager.getConfig();
        ConfigurationSection kits = config.getConfigurationSection("kits");
        if (kits != null) {
            for (String kit : kits.getKeys(false)) {
                if (args.length != 1 || !kit.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                suggestions.add(kit);
            }
        }
        return suggestions;
    }

    public Map<UUID, Map<String, Long>> getCooldowns() {
        return this.cooldowns;
    }

    public KitGUIListener getGuiListener() {
        return this.guiListener;
    }
}

