/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.nick;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class NickManager
implements CommandExecutor {
    private static NickManager instance;
    private final MiniMessage mini = MiniMessage.miniMessage();
    private final File nickConfigFile;
    private final File messagesFile;
    private final File storageFile;
    private FileConfiguration nickConfig;
    private FileConfiguration messagesConfig;
    private FileConfiguration storageConfig;
    private final Map<Player, String> nickCache = new HashMap<Player, String>();

    public NickManager(File dataFolder) {
        instance = this;
        this.nickConfigFile = new File(dataFolder, "config/nick/nick.yml");
        this.messagesFile = new File(dataFolder, "messages/player.yml");
        this.storageFile = new File(dataFolder, "storage/nicks.yml");
        this.loadConfigs();
        this.loadNicks();
    }

    public static void reload() {
        if (instance != null) {
            instance.reloadConfigs();
        } else {
            Bukkit.getLogger().warning("[NickManager] Reload called before initialization!");
        }
    }

    private void loadConfigs() {
        if (!this.nickConfigFile.exists()) {
            this.nickConfigFile.getParentFile().mkdirs();
        }
        if (!this.messagesFile.exists()) {
            this.messagesFile.getParentFile().mkdirs();
        }
        if (!this.storageFile.exists()) {
            this.storageFile.getParentFile().mkdirs();
        }
        this.nickConfig = YamlConfiguration.loadConfiguration((File)this.nickConfigFile);
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.storageConfig = YamlConfiguration.loadConfiguration((File)this.storageFile);
    }

    public void saveStorage() {
        try {
            this.storageConfig.save(this.storageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadNicks() {
        for (String uuid : this.storageConfig.getKeys(false)) {
            String nick = this.storageConfig.getString(uuid);
            Player p = Bukkit.getPlayer((UUID)UUID.fromString(uuid));
            if (p == null || nick == null) continue;
            this.applyNick(p, nick);
        }
    }

    private void applyNick(Player player, String nick) {
        Object displayName = this.mini.deserialize(nick);
        player.displayName(displayName);
        player.playerListName(displayName);
        this.nickCache.put(player, nick);
    }

    private void resetNick(Player player) {
        player.displayName((Component)Component.text(player.getName()));
        player.playerListName((Component)Component.text(player.getName()));
        this.nickCache.remove(player);
        this.storageConfig.set(player.getUniqueId().toString(), null);
        this.saveStorage();
    }

    private String msg(String path, Map<String, String> placeholders) {
        String raw = this.messagesConfig.getString(path, "<red>Message not found: " + path);
        if (placeholders != null) {
            for (Map.Entry<String, String> e : placeholders.entrySet()) {
                raw = raw.replace("%" + e.getKey() + "%", e.getValue());
            }
        }
        return raw;
    }

    private boolean validateNick(Player p, String nick) {
        int minLen = this.nickConfig.getInt("nick-settings.min-length", 3);
        int maxLen = this.nickConfig.getInt("nick-settings.max-length", 16);
        boolean allowFormatting = this.nickConfig.getBoolean("nick-settings.allow-formatting", true);
        List blocked = this.nickConfig.getStringList("nick-settings.blocked-words");
        String stripped = nick.replaceAll("<.*?>", "");
        if (stripped.length() < minLen || stripped.length() > maxLen) {
            p.sendMessage(this.mini.deserialize(this.msg("nick.invalid_length", Map.of("min", String.valueOf(minLen), "max", String.valueOf(maxLen)))));
            return false;
        }
        for (String word : blocked) {
            if (!stripped.toLowerCase().contains(word.toLowerCase())) continue;
            p.sendMessage(this.mini.deserialize(this.msg("nick.blocked_word", Map.of("word", word))));
            return false;
        }
        if (!allowFormatting && nick.contains("<")) {
            p.sendMessage(this.mini.deserialize(this.msg("nick.no_formatting", null)));
            return false;
        }
        return true;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("nick")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Only players can use /nick");
                return true;
            }
            Player p = (Player)sender;
            if (args.length < 1) {
                p.sendMessage(this.mini.deserialize(this.msg("nick.usage", null)));
                return true;
            }
            if (args[0].equalsIgnoreCase("reset")) {
                this.resetNick(p);
                p.sendMessage(this.mini.deserialize(this.msg("nick.reset_self", null)));
                return true;
            }
            String newNick = String.join((CharSequence)" ", args);
            if (!this.validateNick(p, newNick)) {
                return true;
            }
            this.applyNick(p, newNick);
            this.storageConfig.set(p.getUniqueId().toString(), (Object)newNick);
            this.saveStorage();
            p.sendMessage(this.mini.deserialize(this.msg("nick.set", Map.of("nick", newNick))));
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("nicks")) {
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                NickManager.reload();
                sender.sendMessage(this.mini.deserialize(this.msg("nicks.reload", null)));
                return true;
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("reset")) {
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target != null) {
                    this.resetNick(target);
                    sender.sendMessage(this.mini.deserialize(this.msg("nicks.reset", Map.of("player", target.getName()))));
                } else {
                    sender.sendMessage(this.mini.deserialize(this.msg("nicks.not_found", Map.of("player", args[1]))));
                }
                return true;
            }
        }
        return false;
    }

    private void reloadConfigs() {
        this.nickConfig = YamlConfiguration.loadConfiguration((File)this.nickConfigFile);
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.storageConfig = YamlConfiguration.loadConfiguration((File)this.storageFile);
        this.reloadNicks();
    }

    private void reloadNicks() {
        this.nickCache.clear();
        for (String uuid : this.storageConfig.getKeys(false)) {
            String nick = this.storageConfig.getString(uuid);
            Player player = Bukkit.getPlayer((UUID)UUID.fromString(uuid));
            if (player == null || nick == null) continue;
            this.applyNick(player, nick);
        }
    }
}

