/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.serverEssentials;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Consumer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.Managers.ReloadManager;
import serveressentials.serveressentials.ServerEssentials;

public class ServerEssentialsCommand
implements CommandExecutor {
    private final Plugin plugin;
    private final String PREFIX = this.hex("#00E5FF") + "[ServerEssentials] \u00a7r";
    private final Map<String, Consumer<CommandSender>> subCommands = new HashMap<String, Consumer<CommandSender>>();

    public ServerEssentialsCommand(Plugin plugin) {
        this.plugin = plugin;
        this.subCommands.put("info", this::showInfo);
        this.subCommands.put("version", this::showVersion);
        this.subCommands.put("reload", this::reloadPlugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendMessage(sender, "#FF5555", "Unknown subcommand. Use /" + label + " <info|version|reload>");
            return true;
        }
        Consumer<CommandSender> sub = this.subCommands.get(args[0].toLowerCase());
        if (sub == null) {
            this.sendMessage(sender, "#FF5555", "Unknown subcommand. Use /" + label + " <info|version|reload>");
            return true;
        }
        sub.accept(sender);
        return true;
    }

    private void showInfo(CommandSender sender) {
        this.sendMessage(sender, "#00FF7F", "ServerEssentials: Modern All-in-One Minecraft Plugin");
        this.sendMessage(sender, "#AAAAAA", "\u2022 RTP GUI");
        this.sendMessage(sender, "#AAAAAA", "\u2022 Home System");
        this.sendMessage(sender, "#AAAAAA", "\u2022 TPA System");
        this.sendMessage(sender, "#AAAAAA", "\u2022 Auction House");
        this.sendMessage(sender, "#AAAAAA", "\u2022 Shop");
        this.sendMessage(sender, "#AAAAAA", "\u2022 Admin Commands");
        this.sendMessage(sender, "#AAAAAA", "\u2022 Ranks");
        this.sendMessage(sender, "#AAAAAA", "\u2022 Join/Leave Messages");
        this.sendMessage(sender, "#AAAAAA", "\u2022 Warp System");
        this.sendMessage(sender, "#AAAAAA", "\u2022 Coinflip System");
        this.sendMessage(sender, "#AAAAAA", "\u2022 Customizable Scoreboard");
    }

    private void showVersion(CommandSender sender) {
        String currentVersion = this.plugin.getDescription().getVersion();
        String latestVersion = this.getLatestVersionFromModrinth();
        this.sendMessage(sender, "#00E5FF", "Current Version: " + this.hex("#FFFFFF") + currentVersion);
        if (latestVersion != null) {
            this.sendMessage(sender, "#FFD700", "Latest on Modrinth: " + this.hex("#FFFFFF") + latestVersion);
            if (!currentVersion.equals(latestVersion)) {
                this.sendMessage(sender, "#FF5555", "Your version is outdated! Please update.");
            } else {
                this.sendMessage(sender, "#55FF55", "You are using the latest version.");
            }
        } else {
            this.sendMessage(sender, "#FF5555", "Could not check for updates.");
        }
    }

    private String getLatestVersionFromModrinth() {
        try {
            URL url = new URL("https://api.modrinth.com/v2/project/serveressentials/version");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.connect();
            if (conn.getResponseCode() != 200) {
                return null;
            }
            Scanner scanner = new Scanner(conn.getInputStream());
            StringBuilder json = new StringBuilder();
            while (scanner.hasNext()) {
                json.append(scanner.nextLine());
            }
            scanner.close();
            String result = json.toString();
            int idx = result.indexOf("\"version_number\":");
            if (idx != -1) {
                int start = result.indexOf(34, idx + 17) + 1;
                int end = result.indexOf(34, start);
                return result.substring(start, end);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void reloadPlugin(CommandSender sender) {
        if (this.plugin instanceof ServerEssentials) {
            try {
                ReloadManager.reloadAll(sender);
            }
            catch (Exception e) {
                this.sendMessage(sender, "#FF5555", "An error occurred while reloading. Check console for details.");
                e.printStackTrace();
                return;
            }
        } else {
            this.sendMessage(sender, "#FF5555", "Reload failed: plugin instance mismatch.");
            return;
        }
        this.sendMessage(sender, "#55FF55", "All configuration files and systems have been reloaded!");
    }

    private void sendMessage(CommandSender sender, String hexColor, String message) {
        sender.sendMessage(this.PREFIX + this.hex(hexColor) + message);
    }

    private String hex(String hexColor) {
        if ((hexColor = hexColor.replace("#", "")).length() != 6) {
            return "\u00a7f";
        }
        StringBuilder sb = new StringBuilder("\u00a7x");
        for (char c : hexColor.toCharArray()) {
            sb.append("\u00a7").append(c);
        }
        return sb.toString();
    }
}

